/***************************************************************************

  Chromaplas
  cpimcosp.h

 **************************************************************************/



#ifndef CPIMCOSP_H
#define CPIMCOSP_H

/****************************************************************************
 Includes
 */


/****************************************************************************
 Defines
 */


/****************************************************************************
 Macros
 */


/****************************************************************************
 Global Types
 */

/* Used to store pre-calculated colour-space values for the source image. */
typedef struct CpImgColSpTag
{
	int nW, nH;
	uint32_t *naImgColSpChannels;	/* Each pixel is encoded as a uint32_t. A int16_t for the h (signed so we can allow for warparound) and 2 uint8_ts for the s and v */
}
CpImgColSp;


/****************************************************************************
 Global Variables (across program)
 */

extern CpImgColSp G_icsImgColSpc;


/****************************************************************************
 Function Prototypes
 */



void cpImgColSpInit(CpImgColSp *icspThis);
AeBool cpImgColSpIsUsed(CpImgColSp *icspThis);
AeBool cpImgColSpAlloc(CpImgColSp *icspThis, int nW, int nH);
void cpImgColSpSafeFree(CpImgColSp *icspThis);


AeBool cpPreCalcImgColSpcVals(CpImgColSp *icspColSpcDest, BITMAP *bmpSourceImage, PALETTE pSourcePicPal);




#endif /* CPIMCOSP_H */
