/***************************************************************************
 *
 * cpfunpal.c
 * ChromaPlas funky palette effect
 * 
 * By Andrei Ellman
 * Portions of this code were taken from plasma code by Jan Moeller & Erik Hansen.
 *
 **************************************************************************/


/****************************************************************************
 Includes
 */


#include <stdlib.h>
#include <math.h>
#include <allegro.h>	// For PALETTE

#include "aeglobal.h"

#include "cpglobal.h"

#include "aecolspc.h"

#include "cpmthhlp.h"

#include "cpsttngs.h"

#include "cpgfx.h"	// For G_pPal

#include "cpfunpal.h"


/****************************************************************************
 Local Types
 */


/* Pre-calculated values for the stimuli that remain constant while the funky palette effect is running */
typedef struct CpStimulusPreCalcTag
{
	float nFrequency;	/* The frequrency of a colour-component stimulus (in RADIANS PER 1/CPREFERENCEREFRESHRATEth SECOND). This is pre-calculated because the settings in the config are in cycles per second. */
}
CpStimulusPreCalc;


/* The current state of a single stimulus. This corresponds to the position in the sinewave of a stimulis in the first colour-index at any given time. */
typedef struct CpStimulusStateTag
{
	float nPhase;	/* The current phase-angle (in RADIANS) */
}
CpStimulusState;


/****************************************************************************
 Global Prototypes
 */


/****************************************************************************
 Local (Static) Prototypes
 */


/****************************************************************************
 Local Defines
 */


/****************************************************************************
 Local Macros
 */


/****************************************************************************
 Global Variables (across program)
 */


/****************************************************************************
 Local (static) Global Variables
 */



/* Pre-calculated values to help change the state of the funky palette effect. */
static CpStimulusPreCalc g_spaColourSpaceStimuliPreCalcs[CPNUMSTIMULIPERCOLOURSPACE];

/* State of the funky palette effect */
/* The current phase-angle of each wave representing a colour-space stimulus at palette-entry #0 (in RADIANS) */
static CpStimulusState g_ssaColourSpaceStimuliStates[CPNUMSTIMULIPERCOLOURSPACE];




/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

                                   Helpers

 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */




/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

                              Pre Calculations

 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */




/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

                           Setting up and cleaning

 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */


// ?: rename: init -> setup
void
cpInitFunkyPaletteEffect(void)
{
	unsigned int nI;



	/* Initialise the plasma colours state */


	/* Because the settings are in degrees (more human-readable) and we want the state to be in radians (faster to compute), convert phase-angles to radians */

	/* Set current phase to initial phase-angles */
	for(nI=0;nI<CPNUMSTIMULIPERCOLOURSPACE;nI++)
	{
		/* Set current phase to initial phase-angles */
		/* Because the settings are in degrees (more human-readable) and we want the state to be in radians (faster to compute), convert phase-angles to radians */
		g_ssaColourSpaceStimuliStates[nI].nPhase = CPDEG2RAD(G_cps.csssetColourspacestimulusWaveSettings[nI].nInitialPhase);


		/* Work out the frequencies in the correct units */
		/* Because the settings are in cycles per second (more human-readable) and each tick we want to add the number of radians per 1/CPREFERENCEREFRESHRATE second, we must convert between the two units. */

		g_spaColourSpaceStimuliPreCalcs[nI].nFrequency = (G_cps.csssetColourspacestimulusWaveSettings[nI].nFrequency * (2.0f*pi)) / CPREFERENCEREFRESHRATE;
	}

}






/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

                   Calculations while program is running

 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */



/*
When the plasma is diaplayed using a palette, this funkifies the palette
*/

// logic
void
cpUpdateFunkyPaletteParams(float nColourMovementDelta)
{
	unsigned int nI;
	
	/* Parts of this code taken from code by Jan Moeller & Erik Hansen. */

	for(nI=0;nI<CPNUMSTIMULIPERCOLOURSPACE;nI++)
	{
		g_ssaColourSpaceStimuliStates[nI].nPhase += g_spaColourSpaceStimuliPreCalcs[nI].nFrequency * nColourMovementDelta;
	}
}







//#define mycol(wavesegment,phase,amp) ((MAX(0.0,sin((wavesegment)+(phase))*(amp)))*(256.0f-0.00025f)*(amp)) // try this line instead
//#define mycol(wavesegment,phase,amp) ((ABS(sin((wavesegment)+(phase))*(amp)))*(256.0f-0.00025f)*(amp)) // try this line instead

#define mycol(wavesegment,phase,amp) (((sin((wavesegment)+(phase))*(amp))+1.0f)*(128.0f-0.00025f))
//#define mycol(u,a) (nIndex>>2) // Makes a monochrome palette.

#define myhue(wavesegment,phase,amp) (((sin((wavesegment)+(phase))*(amp))+1.0f)*(768.0f-0.00025f))
#define mysvl(wavesegment,phase,amp) (((sin((wavesegment)+(phase))*(amp))+1.0f)*(128.0f-0.00025f))

// ?: merge mycol and mysvl?
// ?: For the multiplier, pass in val/(1<<nRs) which should remain constant throughout (or even precalc)? Although with HSV, would still need to multiply by full ammount coz these values then passed to an Hxx2RGB conversion function.

/* Work out what the palette of the next frame will be (if not using a hardware palette, this works out the CLUT). */
// render (pre-calc)
void
cpPreCalcFunkyPalette(int nDestBPP)
{
	/* Parts of this code taken from code by Jan Moeller & Erik Hansen. */

	int nIndex;
	int nJ;
	float naPaletteWavePerStimuliPos[CPNUMSTIMULIPERCOLOURSPACE] = {0.0f, 0.0f, 0.0f};
	AL_CONST float naPaletteWavePerStimuliPosDeltaForNextPaletteEntry[CPNUMSTIMULIPERCOLOURSPACE] =
	{
		((2.0f*pi)/256.0f)*G_cps.csssetColourspacestimulusWaveSettings[0].nWaveNumber,
		((2.0f*pi)/256.0f)*G_cps.csssetColourspacestimulusWaveSettings[1].nWaveNumber,
		((2.0f*pi)/256.0f)*G_cps.csssetColourspacestimulusWaveSettings[2].nWaveNumber,
	};
	/* This should divide the wave-number sinewaves into 256 segments */


	unsigned char nRs, nGs, nBs;


	cpGetColourComponentShift(nDestBPP, &nRs, &nGs, &nBs);



	for(nIndex=0;nIndex<256;nIndex++)
	{


		// Could use fn() pointers instead of a switch
		switch(G_cps.csFunkyPaletteEffectColourSpace)
		{
			case cpCOLOURSPACE_RGB:
			{
				/* RGB */

				G_pPal[nIndex].r = ((unsigned char) mycol(naPaletteWavePerStimuliPos[0],g_ssaColourSpaceStimuliStates[0].nPhase,G_cps.csssetColourspacestimulusWaveSettings[0].nAmp)) >> nRs;
				G_pPal[nIndex].g = ((unsigned char) mycol(naPaletteWavePerStimuliPos[1],g_ssaColourSpaceStimuliStates[1].nPhase,G_cps.csssetColourspacestimulusWaveSettings[1].nAmp)) >> nGs;
				G_pPal[nIndex].b = ((unsigned char) mycol(naPaletteWavePerStimuliPos[2],g_ssaColourSpaceStimuliStates[2].nPhase,G_cps.csssetColourspacestimulusWaveSettings[2].nAmp)) >> nBs;
			}
			break;

			case cpCOLOURSPACE_HSV:
			{
				int16_t h = (int16_t) myhue(naPaletteWavePerStimuliPos[0],g_ssaColourSpaceStimuliStates[0].nPhase,G_cps.csssetColourspacestimulusWaveSettings[0].nAmp);
				uint8_t s = (uint8_t) mysvl(naPaletteWavePerStimuliPos[1],g_ssaColourSpaceStimuliStates[1].nPhase,G_cps.csssetColourspacestimulusWaveSettings[1].nAmp);
				uint8_t v = (uint8_t) mysvl(naPaletteWavePerStimuliPos[2],g_ssaColourSpaceStimuliStates[2].nPhase,G_cps.csssetColourspacestimulusWaveSettings[2].nAmp);

				unsigned int nColour24 = cpTurboHSV2RGB(h, s, v);

				G_pPal[nIndex].b = ((unsigned char) (nColour24&0xFF)) >> nRs;
				nColour24>>=8;
				G_pPal[nIndex].g = ((unsigned char) (nColour24&0xFF)) >> nGs;
				nColour24>>=8;
				G_pPal[nIndex].r = ((unsigned char) (nColour24&0xFF)) >> nBs;
			}
			break;

			case cpCOLOURSPACE_HLS:
			{
				int16_t h = (int16_t) myhue(naPaletteWavePerStimuliPos[0],g_ssaColourSpaceStimuliStates[0].nPhase,G_cps.csssetColourspacestimulusWaveSettings[0].nAmp);
				uint8_t l = (uint8_t) mysvl(naPaletteWavePerStimuliPos[1],g_ssaColourSpaceStimuliStates[1].nPhase,G_cps.csssetColourspacestimulusWaveSettings[1].nAmp);
				uint8_t s = (uint8_t) mysvl(naPaletteWavePerStimuliPos[2],g_ssaColourSpaceStimuliStates[2].nPhase,G_cps.csssetColourspacestimulusWaveSettings[2].nAmp);

				unsigned int nColour24 = cpTurboHLS2RGB(h, l, s);

				G_pPal[nIndex].b = ((unsigned char) (nColour24&0xFF)) >> nRs;
				nColour24>>=8;
				G_pPal[nIndex].g = ((unsigned char) (nColour24&0xFF)) >> nGs;
				nColour24>>=8;
				G_pPal[nIndex].r = ((unsigned char) (nColour24&0xFF)) >> nBs;
			}
			break;

			default:
			{
				TRACE("Invalid colour-space.\n");
				ASSERT(FALSE);
			}
		}


		/* Advance to the next segment */
		for(nJ=0;nJ<CPNUMSTIMULIPERCOLOURSPACE;nJ++)
		{
			naPaletteWavePerStimuliPos[nJ]+=naPaletteWavePerStimuliPosDeltaForNextPaletteEntry[nJ];
		}
	}

	G_bPalIsMucky = TRUE;
}
