/***************************************************************************/
/*!
  \file aeglobal.h

  \brief AE's Global utility functions header file.

  Declares variables and datastructures and #defines etc. that often come in handy.

  \author Andrei Ellman

 **************************************************************************/



#ifndef AEGLOBAL_H
#define AEGLOBAL_H

/****************************************************************************
 Includes
 */


/****************************************************************************
 Defines
 */

/* Useful macros */

#ifndef TRUE
#define TRUE         -1	/*!< Value for the boolean TRUE value (all bits set) */
#define FALSE        0	/*!< Value for the boolean FALSE value (no bits set) */
#endif

#ifndef MIN
#define MIN(x,y)     (((x) < (y)) ? (x) : (y))	/*!< Find the minimum of the two values. */
#define MAX(x,y)     (((x) > (y)) ? (x) : (y))	/*!< Find the maximum of the two values. */
#define MID(x,y,z) ((x) > (y) ? ((y) > (z) ? (y) : ((x) > (z) ? (z) : (x))) : ((y) > z ? ((z) > (x) ? (z) : (x)) : (y)))	/*!< Find the value that is the middle value in the three values. */
#define CLAMP(x,y,z)   MAX((x), MIN((y), (z)))	/*!< If \p x <= \p z, find the value that is the middle value in the three values. This is useful for clamping values of \p y to the range \p x .. \p z */
#endif

#ifndef ABS
#define ABS(x)       (((x) >= 0) ? (x) : (-(x)))	/*!< Find the absolute value of the passed in value. */
#endif

#ifndef SGN
#define SGN(x)       (((x) >= 0) ? 1 : -1)	/*!< Find the sign of the passed in value */
#endif

#if defined(_MSC_VER)
#define AENOCODE	NULL	/*!< To be used for an empty block of code. Note that GCC and MSVC differ as to whether or not NULL is needed. */
#else
#define AENOCODE	/*!< To be used for an empty block of code. Note that GCC and MSVC differ as to whether or not NULL is needed. */
#endif


#define XSTR(x) (#x)
#define STR(x) XSTR(x) /* Use a second macro expansion to expand numeric defines to numbers before they are stringified */



/*! \brief How fast our timer G_nTargetGameTime is ticking
Let's choose 60Hz because it's what all NTSC and most PAL tellies are capable of doing
And I think SVGA modes do 60HZ too. Or if not, we should set the HZ to 60 or 120 */
#define AEDEFAULTTICKSPERSECOND	60
// -> aegfx.h?

#define AEGAMETIMENUMDIVISIONSPERSECOND	10	/* Howmany times per second are we going to update the framerate-timer. 10 is a good choice because it is a factor of 60. */
// -> aeprglp ?



#define AESECSPERMIN 60	/*!< Number of seconds per minute */




/****************************************************************************
 Macros
 */

/*!
  Given a static array, returns howmany elements the array contains.

  \param a	The static array.

  \warning \p a must be an array anf not a pointer or any other datatype.
*/
#define AEGETNUMELEMENTSINSTATICARRAY(a)	(sizeof((a))/sizeof((a)[0]))


/****************************************************************************
 Global Types
 */

typedef int AeBool;	/*!< Boolean-type */


// ?: Should the number of bits in the bitfield be defined (bitfield32, bitfield8, etc.)?
typedef unsigned int AeBitfield;	/*!< Generic bitfield type */



/****************************************************************************
 Global Variables (across program)
 */


/****************************************************************************
 Function Prototypes
 */



#endif /* AEGLOBAL_H */
