/***************************************************************************/
/*!
  \file aeconfig.h

  \brief Configuration managment header file.

  Declares global variables and datastructures and #defines etc.

  \author Andrei Ellman

 **************************************************************************/

#ifndef AECONFIG_H
#define AECONFIG_H



/****************************************************************************
 Includes
 */


/****************************************************************************
 Defines
 */


#define AECONFIGSETTINGSVALUEBUFFERLENGTH	1024	/*!< Length of a temporary settings-buffer when serialising a multi-valued key to the config */


/****************************************************************************
 Macros
 */

#define aeSERIALISECONFIGINT(npintval, settingname, ndefault)	aeSerialiseConfigInt(npintval, AECONFIGCURRENTSECTION, settingname, ndefault, bWrite)	/*!< A shortcut used for serialising INT values form the configuration settings. */
#define aeSERIALISECONFIGUINT(npuintval, settingname, ndefault)	aeSerialiseConfigUInt(npuintval, AECONFIGCURRENTSECTION, settingname, ndefault, bWrite)	/*!< A shortcut used for serialising unsigned INT values form the configuration settings. */
#define aeSERIALISECONFIGUINT8(npintval, settingname, ndefault)	aeSerialiseConfigUInt8(npintval, AECONFIGCURRENTSECTION, settingname, ndefault, bWrite)	/*!< A shortcut used for serialising UINT8 values form the configuration settings. */
#define aeSERIALISECONFIGUINT16(npintval, settingname, ndefault)	aeSerialiseConfigUInt16(npintval, AECONFIGCURRENTSECTION, settingname, ndefault, bWrite)	/*!< A shortcut used for serialising UINT16 values form the configuration settings. */
#define aeSERIALISECONFIGHEXFIXED(npfixedval, settingname, ndefault)	aeSerialiseConfigHexFixed(npfixedval, AECONFIGCURRENTSECTION, settingname, ndefault, bWrite)	/*!< A shortcut used for serialising hexadecimal FIXED values form the configuration settings. */
#define aeSERIALISECONFIGBOOL(npboolval, settingname, bdefault)	aeSerialiseConfigBool(npboolval, AECONFIGCURRENTSECTION, settingname, bdefault, bWrite)	/*!< A shortcut used for serialising BOOL values form the configuration settings. */
#ifndef AECONFIG_NO_FLOAT
#define aeSERIALISECONFIGFLOAT(npfloatval, settingname, ndefault)	aeSerialiseConfigFloat(npfloatval, AECONFIGCURRENTSECTION, settingname, ndefault, bWrite)	/*!< A shortcut used for serialising FLOAT values form the configuration settings. */
#define aeSERIALISECONFIGDOUBLE(npdoubleval, settingname, ndefault)	aeSerialiseConfigDouble(npdoubleval, AECONFIGCURRENTSECTION, settingname, ndefault, bWrite)	/*!< A shortcut used for serialising DOUBLE values form the configuration settings. */
#endif
#define aeSERIALISECONFIGSTRING(szstringvalbuf, nstringvalbufsize, settingname, szdefault)	aeSerialiseConfigString(szstringvalbuf, nstringvalbufsize, AECONFIGCURRENTSECTION, settingname, szdefault, bWrite)	/*!< A shortcut used for getting STRIMG values form the configuration settings. */


/*!< A shortcut used for serialising typedef'd scalar-types and enumerated types form the configuration settings. Pass in the type to do the cast, and the appropriate serialisation acro and it's associated type. */
#define aeSERIALISECONFIGTYPEDEFDSCALARTYPE(npintval, settingname, ndefault, typedefdscalartype, appropriateserialisationmacro, appropriateserialisationtype)	\
{		\
	appropriateserialisationtype nTmpInt;	\
		\
	if(bWrite)	\
	{	\
		nTmpInt = (appropriateserialisationtype)(*npintval);	\
	}	\
	appropriateserialisationmacro(&nTmpInt, settingname, ndefault);	\
	if(!bWrite)	\
	{	\
		(*npintval) = (typedefdscalartype)nTmpInt;	\
	}	\
}



/****************************************************************************
 Global Types
 */


/****************************************************************************
 Global Variables (across program)
 */


/****************************************************************************
 Function Prototypes
 */

void aeCopyKeyValueToSettingsBufferAndCheckForPresenceAndOverflow(char *szSettingsBuffer, size_t nSettingsBufferSize, AL_CONST char *szSection, AL_CONST char *szKeyName);
void aeCheckToSeeIfAnyRemainingValuesInSettingsBufferPostReadAndPrintMessageIfYes(char *szSettingsBufferPosPostSerialise, AL_CONST char *szSection, AL_CONST char *szKeyName, AL_CONST char *szKeyDesc, AL_CONST char *szValDesc, unsigned int nMaxNumValuesToSerialise);

void aeAddTabToValueBuffer(char **szpSettingsPos, int *npSettingsBufferRemainingSize, AL_CONST char *szSection, AL_CONST char *szKeyName);

void aeSerialiseConfigInt(int *npIntVal, AL_CONST char *szSection, AL_CONST char *szName, AL_CONST int nDefaultInt, AeBool bWrite);
void aeSerialiseConfigUInt(unsigned int *npUIntVal, AL_CONST char *szSection, AL_CONST char *szName, AL_CONST unsigned int nDefaultUInt, AeBool bWrite);
void aeSerialiseConfigUInt8(uint8_t *npUInt8Val, AL_CONST char *szSection, AL_CONST char *szName, AL_CONST uint8_t nDefaultUInt8, AeBool bWrite);
void aeSerialiseConfigUInt16(uint16_t *npUInt16Val, AL_CONST char *szSection, AL_CONST char *szName, AL_CONST uint16_t nDefaultUInt16, AeBool bWrite);
void aeSerialiseConfigBool(AeBool *bpBoolVal, AL_CONST char *szSection, AL_CONST char *szName, AL_CONST AeBool bDefaultBool, AeBool bWrite);
void aeSerialiseConfigHexFixed(fixed *npFixedVal, AL_CONST char *szSection, AL_CONST char *szName, AL_CONST fixed nDefaultFixed, AeBool bWrite);
#ifndef AECONFIG_NO_FLOAT
void aeSerialiseConfigFloat(float *npFloatVal, AL_CONST char *szSection, AL_CONST char *szName, AL_CONST float nDefaultFloat, AeBool bWrite);
void aeSerialiseConfigDouble(double *npDoubleVal, AL_CONST char *szSection, AL_CONST char *szName, AL_CONST double nDefaultDouble, AeBool bWrite);
#endif
void aeSerialiseConfigString(char *szValueBuffer, int nValueBufferSize, AL_CONST char *szSection, AL_CONST char *szName, AL_CONST char *szDefaultString, AeBool bWrite);

void aeSerialiseArrayOfIntsFromStringAndNotifyIfChangesFromDefault(int *naIntVals, char **szpSettingsPos, int *npSettingsBufferRemainingSize, unsigned int nNumValuesToSerialise, AL_CONST int *naDefaultIntVals, AeBool bWrite, AL_CONST char *szSection, AL_CONST char *szKeyName, AL_CONST char *szValDesc);
void aeSerialiseArrayOfUIntsFromStringAndNotifyIfChangesFromDefault(unsigned int *naUIntVals, char **szpSettingsPos, int *npSettingsBufferRemainingSize, unsigned int nNumValuesToSerialise, AL_CONST unsigned int *naDefaultUIntVals, AeBool bWrite, AL_CONST char *szSection, AL_CONST char *szKeyName, AL_CONST char *szValDesc);
void aeSerialiseArrayOfBoolsFromStringAndNotifyIfChangesFromDefault(AeBool *baBoolVals, char **szpSettingsPos, int *npSettingsBufferRemainingSize, unsigned int nNumValuesToSerialise, AL_CONST AeBool *baDefaultBoolVals, AeBool bWrite, AL_CONST char *szSection, AL_CONST char *szKeyName, AL_CONST char *szValDesc);
#ifndef AECONFIG_NO_FLOAT
void aeSerialiseArrayOfFloatsFromStringAndNotifyIfChangesFromDefault(float *naFloatVals, char **szpSettingsPos, int *npSettingsBufferRemainingSize, unsigned int nNumValuesToSerialise, AL_CONST float *naDefaultFloatVals, AeBool bWrite, AL_CONST char *szSection, AL_CONST char *szKeyName, AL_CONST char *szValDesc);
void aeSerialiseArrayOfDoublesFromStringAndNotifyIfChangesFromDefault(double *naDoubleVals, char **szpSettingsPos, int *npSettingsBufferRemainingSize, unsigned int nNumValuesToSerialise, AL_CONST double *naDefaultDoubleVals, AeBool bWrite, AL_CONST char *szSection, AL_CONST char *szKeyName, AL_CONST char *szValDesc);
#endif

void aeSerialiseArrayOfIntsFromConfigListAndNotifyIfChangesFromDefault(int *naIntVals, AL_CONST char *szSection, AL_CONST char *szKeyName, unsigned int nNumValuesToSerialise, AL_CONST int *naDefaultIntVals, AeBool bWrite, AL_CONST char *szValDesc);
void aeSerialiseArrayOfUIntsFromConfigListAndNotifyIfChangesFromDefault(unsigned int *naUIntVals, AL_CONST char *szSection, AL_CONST char *szKeyName, unsigned int nNumValuesToSerialise, AL_CONST unsigned int *naDefaultUIntVals, AeBool bWrite, AL_CONST char *szValDesc);
void aeSerialiseArrayOfBoolsFromConfigListAndNotifyIfChangesFromDefault(AeBool *baBoolVals, AL_CONST char *szSection, AL_CONST char *szKeyName, unsigned int nNumValuesToSerialise, AL_CONST AeBool *baDefaultBoolVals, AeBool bWrite, AL_CONST char *szValDesc);
#ifndef AECONFIG_NO_FLOAT
void aeSerialiseArrayOfFloatsFromConfigListAndNotifyIfChangesFromDefault(float *naFloatVals, AL_CONST char *szSection, AL_CONST char *szKeyName, unsigned int nNumValuesToSerialise, AL_CONST float *naDefaultFloatVals, AeBool bWrite, AL_CONST char *szValDesc);
void aeSerialiseArrayOfDoublesFromConfigListAndNotifyIfChangesFromDefault(double *naDoubleVals, AL_CONST char *szSection, AL_CONST char *szKeyName, unsigned int nNumValuesToSerialise, AL_CONST double *naDefaultDoubleVals, AeBool bWrite, AL_CONST char *szValDesc);
#endif


#ifndef AECONFIG_NO_INTCOORD2D
void aeSerialiseConfigIntCoord2D(AeIntCoords2 *icpIntCoords, AL_CONST char *szSection, AL_CONST char *szKeyName, AL_CONST int nDefaultIX, AL_CONST int nDefaultIY, AeBool bWrite);
#endif
#ifndef AECONFIG_NO_ANIMPARAMDESC
void aeSerialiseConfigAnimParams(ChAminParamsDesc *apdpAnimParams, AL_CONST char *szSection, AL_CONST char *szKeyName, AL_CONST unsigned int nDefaultNumFrames, AL_CONST unsigned int nDefaultFrameCountdown, AeBool bWrite);
#endif


#endif /* AECONFIG_H */
