/***************************************************************************

  Colour-space conversion code header file
  aecolspc.h

 **************************************************************************/



#ifndef AECOLSPC_H
#define AECOLSPC_H

/****************************************************************************
 Includes
 */


/****************************************************************************
 Defines
 */


/****************************************************************************
 Macros
 */


/****************************************************************************
 Global Types
 */

/* Tyedef pointers to colour-space conversion functions */

// \sa CpColourSpaceToFunction
typedef uint32_t(CpColourSpaceFromFunction)(int16_t n16Stim1, uint8_t c8Stim2, uint8_t c8Stim3);

// \sa CpColourSpaceFromFunction
typedef void(CpColourSpaceToFunction)(uint8_t r, uint8_t g, uint8_t b, int16_t *np16Stim1Out, uint8_t *cp8Stim2Out, uint8_t *cp8Stim3Out);
// ?: Instead of passing params as out-params, should the return value be a long?


/****************************************************************************
 Global Variables (across program)
 */


/****************************************************************************
 Function Prototypes
 */

uint32_t cpTurboHSV2RGB(int16_t h, uint8_t s, uint8_t v);
void cpTurboRGB2HSV(uint8_t r, uint8_t g, uint8_t b, int16_t *hout, uint8_t *sout, uint8_t *vout);
uint32_t cpTurboHLS2RGB(int16_t h, uint8_t l, uint8_t s);
void cpTurboRGB2HLS(uint8_t r, uint8_t g, uint8_t b, int16_t *hout, uint8_t *lout, uint8_t *sout);
void hls_to_rgb_float(float h, float l, float s, int *r, int *g, int *b);
uint32_t cpTurboDecRGB(int16_t r, uint8_t g, uint8_t b);
void cpTurboEncRGB(uint8_t r, uint8_t g, uint8_t b, int16_t *rout, uint8_t *gout, uint8_t *bout);



#endif /* AECOLSPC_H */
