/***************************************************************************
 *
 * cpwin_.c
 * ChromaPlas Windows specific code
 *
 * By Andrei Ellman
 *
 **************************************************************************/






/****************************************************************************
 Includes
 */



// TODO: Create cpplatfm.c which contains platform-independent versions of functions in cpwin_.c


#include <allegro.h>
#include <winalleg.h>
#ifndef SPI_GETDESKWALLPAPER
#define SPI_GETDESKWALLPAPER 115	/* For some reason, this isn't in any of the windows headers */
#endif


#include "aeglobal.h"

//#include "cpglobal.h"

//#include "cpsttngs.h"

#include "cpwin_.h"



/****************************************************************************
 Local Types
 */


/****************************************************************************
 Global Prototypes
 */


/****************************************************************************
 Local (Static) Prototypes
 */


/****************************************************************************
 Local Defines
 */


/****************************************************************************
 Local Macros
 */


/****************************************************************************
 Global Variables (across program)
 */


/****************************************************************************
 Local (static) Global Variables
 */




static HANDLE g_hChromaPlasMutex;

#ifdef CP_IS_SCREENSAVER

/* In Windows, remember the previous priority-class so we can revert to it when exiting screensaver mode. */
DWORD g_nPreviouslyExistingPriorityClass;

#endif



/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

                  Platform dependant image-building functions.

 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */


int
cpGetDesktopResolution_Win(int *npWidth, int *npHeight)
{
	// Taken from Allegro's sys_directx_get_desktop_resolution()


   HDC dc;

   dc = GetDC(NULL);
   *npWidth  = GetDeviceCaps(dc, HORZRES);
   *npHeight = GetDeviceCaps(dc, VERTRES);
   ReleaseDC(NULL, dc);

   return 0;

}



// ?: Shold I just use Allegro's desktop_color_depth() instead?
// Or is it better to leave this code here in case we use some lib other than Allegro?
int
cpGetDesktopColorDepth_Win(void)
{
	// Taken from Allegro's sys_directx_desktop_color_depth()

   HDC dc;
   int depth;

   dc = GetDC(NULL);
   depth = GetDeviceCaps(dc, BITSPIXEL);
   ReleaseDC(NULL, dc);

   return depth;

}



// ?: Shold I just use Allegro's get_desktop_resolution() instead?
// Or is it better to leave this code here in case we use some lib other than Allegro?
AeBool
cpGrabDesktopImage_Win(BITMAP *bmpBitmapToCopyDesktopTo)
{
	/* bmpBitmapToCopyDesktopTo has already been created and it's the desktop size */


	// ?: Am I only supposed to use these in SYSTEM_NONE, or is it OK with the standard SYSTEM driver?
	// See the bit in docs about having to use SYSTEM_NONE if using things like blitting desktop-image to a bitmap. Is this part of the docs correct even?

	HWND dwnd =  GetDesktopWindow();
	HDC ddc = GetDC(dwnd);


	blit_from_hdc(ddc, bmpBitmapToCopyDesktopTo, 0, 0, 0, 0, bmpBitmapToCopyDesktopTo->w, bmpBitmapToCopyDesktopTo->h);
	// ?: Does this automatically convert to #BPP of bmpBitmapToCopyDesktopTo?

	ReleaseDC(dwnd, ddc);

	return TRUE;
}


AeBool
cpGetDesktopWallpaperPath_Win(char *szDesktopWallpaperPath)
{
	return (SystemParametersInfo(SPI_GETDESKWALLPAPER, MAX_PATH*2 /* Wide characters */, szDesktopWallpaperPath, 0)?TRUE:FALSE);
}


// Get's the solid-colour colour of the desktop.
void
cpGetDesktopSolidColour_Win(uint8_t *npR, uint8_t *npG, uint8_t *npB)
{
	DWORD nColourDW = GetSysColor(COLOR_DESKTOP);	// or COLOR_BACKGROUND
	*npR = GetRValue(nColourDW);
	*npG = GetGValue(nColourDW);
	*npB = GetBValue(nColourDW);

	// Note, values should always be in range 0..255 regardless of bpp, but test (eg. 15 and 16 bpp).
}








/* Used to mkae sure only one instace can run at a time. */
// \sa cpReleaseAppMutex_Win
AeBool
cpCreateAppMutex_Win(void)
{
	g_hChromaPlasMutex = CreateMutex(NULL, TRUE, "Chromaplas Screensaver");

	if (!g_hChromaPlasMutex || (GetLastError() == ERROR_ALREADY_EXISTS))
	{
		return FALSE;	
	}

	return TRUE;
}


// \sa cpCreateAppMutex_Win
void
cpReleaseAppMutex_Win(void)
{
	ReleaseMutex(g_hChromaPlasMutex);
}




#ifdef CP_IS_SCREENSAVER


void
cpSetPriorityClassIdle_Win(void)
{
	g_nPreviouslyExistingPriorityClass = GetPriorityClass(GetCurrentProcess());	// As we're putting this inside the if(), assume it doesn't change throughout the lifetime of the program (not counting the settings dialog that launched 'test-mode').
	SetPriorityClass(GetCurrentProcess(), IDLE_PRIORITY_CLASS); /* Ignore return-value */	// TODO: Test this on Windows 9x
}



void
cpRestorePriorityClass_Win(void)
{
	SetPriorityClass(GetCurrentProcess(), g_nPreviouslyExistingPriorityClass); /* Ignore return-value */	// TODO: Test this on Windows 9x
}


#endif
