/***************************************************************************

  Chromaplas
  cpplasma.h

 **************************************************************************/



#ifndef CPPLASMA_H
#define CPPLASMA_H



/****************************************************************************
 Includes
 */


/****************************************************************************
 Defines
 */


/****************************************************************************
 Macros
 */


/****************************************************************************
 Global Types
 */


/****************************************************************************
 Global Variables (across program)
 */

/* Memory area for generating the plasma in. 1x1 plasma pixels corespond to 2x2 screen pixels */
extern int G_nPlasmaBoxW;
extern int G_nPlasmaBoxH;

extern AeBool G_bIntensityHasChanged;


/****************************************************************************
 Function Prototypes
 */


/* Helpers */

uint8_t *cpGetPlasmaBuffer(void);
uint8_t *cpGetPlasmaTab(int nTab);


/* Setting up and cleaning */

AeBool cpInitPlasma(int nWidth, int nHeight);
void cpTiniPlasma(void);


/* Calculations while program is running */

void cpResetPlasmaRiseTimeTicks(int nRefreshRate);
void cpUpdateCurrentPlasmaIntensity(float nTicks);

uint8_t cpGetCurrentPlasmaIntensity(void);

void cpCalculatePlasmaParams(float nPlasMovementDelta);
void cpCalculatePlasmaBody(AeBool bUseIntensityAndBounce, uint8_t cIntensity);




#endif /* CPPLASMA_H */
