/***************************************************************************

  Chromaplas
  cpgfx.h

 **************************************************************************/



#ifndef CPGFX_H
#define CPGFX_H

/****************************************************************************
 Includes
 */


/****************************************************************************
 Defines
 */


#ifdef ALLEGRO_WINDOWS

// This should be a card where get_gfx_mode_list() works (in WINDOWS and possibly ither platforms too, it doesn't). Currently only used when attempting to set a different rez from the one we first tried, and in the Windows GUI.
#define CPGFXCARD GFX_DIRECTX

// GFX_DIRECTX_ACCEL ( = GFX_DIRECTX)
// GFX_DIRECTX_SOFT
// GFX_DIRECTX_SAFE
// GFX_DIRECTX_OVL
// GFX_GDI


#else

#define CPGFXCARD GFX_AUTODETECT

#endif

/****************************************************************************
 Macros
 */


/****************************************************************************
 Global Types
 */


/****************************************************************************
 Global Variables (across program)
 */


extern int G_nRefreshRate;
extern AeBool G_bActualRefreshRateIsUnknown;

extern CpRenderingType G_rtRenderingType;

// ?: Is G_bmpDest really needed outside of cpgfx.c?
extern BITMAP *G_bmpDest;

extern PALETTE G_pPal;
extern AeBool G_bPalIsMucky;

extern AeBool G_bApplyingColourLookupTableDirectlyToPlasmaPixels;


/****************************************************************************
 Function Prototypes
 */

int cpMapCpColourSpaceToInt(CpColourSpace csColourSpace);

int cpGetAllowedBPP(int nIndex);
AeBool cpBPPIsAllowed(int nBPPToTest);

int cpGetXOffsetForCenteringImageOnScreen(int nSourceWidth, int nDestWidth);
int cpGetYOffsetForCenteringImageOnScreen(int nSourceHeight, int nDestHeight);
void cpGetOffsetsForCenteringImageOnScreen(int *npXOffset, int *npYOffset, int nSourceWidth, int nSourceHeight, int nDestWidth, int nDestHeight);

void cpGetSizeToMakePlasma(int *npW, int *npH);

void cpSetPalette(void);

void cpGetColourComponentShift(int nBPP, unsigned char *npRs, unsigned char *npGs, unsigned char *npBs);
void cpCreateMonoPalette(int nDestBPP);
void cpCreateMonoPaletteWithBounceAndIntensity(int nDestBPP, uint8_t nIntensity);



void cpTRACEGFXmodelistContents(GFX_MODE_LIST *gmlpModes, int nCard);

void cpFindRezWithLargestAreaForGivenBPP(int *npWidth, int *npHeight, int nBPP, GFX_MODE_LIST *gmlpModes);



AeBool cpSetupGfx(AeBool bSetGfxMode, int nDestWidth, int nDestHeight, int nDestBPP);
void cpCleanUpGfx(AeBool bSetGfxMode);


#endif /* CPGFX_H */
