/***************************************************************************
 *
 * cpbltiim.c
 * ChromaPlas built-in image code
 *
 * By Andrei Ellman
 *
 **************************************************************************/



/****************************************************************************
 Includes
 */

#include <stdlib.h>
#include <math.h>	/* Needed for generating the builtin image */
#include <allegro.h>


#include "aeglobal.h"

#include "cpglobal.h"

#include "aecolspc.h"

#include "cpmthhlp.h"	// for CPRAD2DEG

#include "cpsttngs.h"	// In case we implement settings for the builtin image.

#include "cpimcosp.h"

#include "cpbltiim.h"


/****************************************************************************
 Local Types
 */


/****************************************************************************
 Global Prototypes
 */


/****************************************************************************
 Local (Static) Prototypes
 */


/****************************************************************************
 Local Defines
 */


/****************************************************************************
 Local Macros
 */


/****************************************************************************
 Global Variables (across program)
 */

 
/****************************************************************************
 Local (static) Global Variables
 */



/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

                          Various ancillary functions.

 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */






/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

                        Building the built-in image

 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */


// TODO: A more elaborate builtin pic. Or more paramaters (eg. is hue radial or angular?)

AeBool
cpMakeBuiltinPic(CpImgColSp *icspColSpcDest, int nWidth, int nHeight)
{
	/* Note: This part is not speed-critical */


	int nX,nY;

	float nAngle;
	float nDistance, nNormalisedDistance;

	float nSaturation;	// ?: -> nAsymptoticDistance



	int16_t n16Stim1;
	uint8_t c8Stim2, c8Stim3;


	uint32_t *npImgColSpChannelsBufPos;


	/* Allocate buffer to store the pre-calculated colourspace values for each pixel */
	if(!cpImgColSpAlloc(icspColSpcDest, nWidth, nHeight))
	{
		TRACE("EEK! Could not create the colour-space data-structure.\n");
		return FALSE;
	}



	npImgColSpChannelsBufPos = icspColSpcDest->naImgColSpChannels;





	/* Create an image where the hue represents the angle round a circle,
	 * and the saturation decays asymptotically (1/polynomially) to 0
	 */



	/* Create our masterpiece */
	for(nY=0;nY<nHeight;nY++)
	{

		float nFy;


		/* If we want to escape while doing the pre-calcs, then escape. */
		/* Only do this once per line to prevent too much slowdown */
		if(cpCanExitApp())
		{
			break;
			// ?: What if we return FALSE? A: The app would think owt went wrong.
			// If we can return error-codes with severity, return one with Severity_OK.
		}



		// TODO: If using margins, set npImgColSpChannelsBufPos to start of line.


		nFy = nY-((float)nHeight/2.0f);

		for(nX=0;nX<nWidth;nX++)
		{
			float nFx = nX-((float)nWidth/2.0f);

			nAngle = atan2(nFy,nFx);
			nDistance = hypot(nFx,nFy);

			nNormalisedDistance = nDistance/((float)nHeight*0.5f);	/* 0 is centre, 1 is top or bottom edge of screen. Divide by height coz it's the smallest dimension. */


			#define CPONEOVERVALUEATDIST1	(32.0/4.0)
			nSaturation = 1.0/(1.0+(CPONEOVERVALUEATDIST1 - 1.0)*pow(nNormalisedDistance,3.0));
		


			/*
			// Old way of doing it (linear decay of s)

			nSaturation = 1.0f-nNormalisedDistance/0.95f;

			// Clamp saturation to a value somewhere above 0
			if(nSaturation<3.0f/32.0f)
			{
				nSaturation=3.0f/32.0f;
			}

			// or even... 1/(nNormalisedDistance+1)^(nNormalisedDistance+1)^(nNormalisedDistance+1)^((nNormalisedDistance+1)/2)
			// but that's weird!

			*/



			/* Now store in the colour-space buffer (TODO: converting the colour-space to that of the dest) */


			switch(G_cps.csColourSpaceToUse)
			{
				case cpCOLOURSPACE_RGB:
				{
					int nTmpR, nTmpG, nTmpB;

					hls_to_rgb_float(CPRAD2DEG(nAngle),0.5f,nSaturation, &nTmpR, &nTmpG, &nTmpB);				

					n16Stim1 = (uint16_t) nTmpR;
					c8Stim2 = (uint8_t) nTmpG;
					c8Stim3 = (uint8_t) nTmpB;
				}
				break;

				case cpCOLOURSPACE_HSV:
				{
					/* HSV mode */
					// TODO: Convert HLS to HSV
					n16Stim1 = (uint16_t) (CPRAD205FF(nAngle)+0.5f);
					c8Stim2 = (uint8_t) ((nSaturation * 255.0f) + 0.5f);	/* Saturation: 0..1 -> 0..255 */
					c8Stim3 = (uint8_t) ((1.0f * 255.0f) + 0.5f);	/* Brightness */
				}
				break;

				case cpCOLOURSPACE_HLS:
				{
					/* HLS mode (native for this built-in pic) */
					n16Stim1 = (uint16_t) (CPRAD205FF(nAngle)+0.5f);
					c8Stim2 = (uint8_t) ((0.5f * 255.0f) + 0.5f);	/* Lightness */
					c8Stim3 = (uint8_t) ((nSaturation * 255.0f) + 0.5f);	/* Saturation: 0..1 -> 0..255 */
				}
				break;

				default:
				{
					TRACE("Invalid colour-space.\n");
					n16Stim1=c8Stim2=c8Stim3=0;
					ASSERT(FALSE);
				}
			}



			/* And store it in the buffer */
			*npImgColSpChannelsBufPos++ = (n16Stim1<<16)+(c8Stim2<<8)+c8Stim3;
		}
	}


	return TRUE;
}
