/*
  Name: Poeng
  Date: 06/03/06

  Version 1.7
*/

// ======================================== Leak detection
#if defined _DEBUG && defined _MSC_VER
#define _CRTDBG_MAP_ALLOC
#include <stdlib.h>
#include <crtdbg.h>
#endif
// =======================================================

#include <allegro.h>
#include <fstream>
#include <string>

using namespace std;

// Test stuff.
#ifdef _DEBUG
#define TEST_STARTING_LEVEL 30
//#define TEST_CANTLOSE
//#define TEST_CHEATS
#endif

#define numBALLS 32
#define numLEVELS 32
#define numEFFETS 16
#define numBONUS 16
#define bonusRAND 3	// The greater, the rarer bonusses are.

bool FSCREEN=true;	// Fullscreen.
DATAFILE *datafile=NULL;
BITMAP *buffer,*levelbmp;
BITMAP *layer0;		// Background.
BITMAP *layer1;		// Shadows.
BITMAP *layer_wall; // Wall.
BITMAP *b1,*b2;		// Borders.
PALETTE palette;

volatile long ticks=0;
void Ticker()
{
	++ticks;
}END_OF_FUNCTION(Ticker)

void Yield()
{
	while (ticks==0)
	{
		rest(1);
	}
	--ticks;
}

struct bla0
{
	bool bIsActive;
	int x,y;
	unsigned char type;
	unsigned char animtime[2];
	unsigned char t;
} Bonus[numBONUS];
struct bla1	// Scores, 10 highscores and current at last index.
{
	unsigned long int score;
	char nom[16];
} ScoreTable[11];
struct bla2	// Score table per brick type.
{
	unsigned long int score;
} BricksValues[8];
struct bla3	// Levels.
{
	char map[40][11];
	unsigned short int broken;
	char border[20][2];
	short int wall;
} Level[numLEVELS];
struct bla4	// Ball.
{
	bool bIsAlive;
	bool bIsOut;
	bool bIsGlued;
	float x,y,vx,vy;
} Ball[numBALLS];
struct bla5	// Player.
{
	unsigned short int y,lenght;
	char mode,life,push;
	int bonustime,gball;
	const char *bonusname;
	unsigned long int score;
	unsigned short int level;
	unsigned short int numballs,ballsout;
	short int lazerx,lazery;
} Player;
struct bla6	// Effects.
{
	short int timer,x,y,type;
} BFX[numEFFETS];

void breaktile(int,int);
void init(bool);
void deinit();
void ball_init();
void ball_move();
void player();
void initmap();
void drawmap();
int tile(int,int);
int checkcol(int);
void effects();
bool TitleScreen();
void drawscore();
void game_timer();
bool check_esc();
void color_cycle();
void check_pause();
bool res_BFX(unsigned short int,unsigned short int,unsigned short int,unsigned short int);
void res_bonus(int,int,unsigned char);
void draw_bonus();
void reset_bonus();
void givebonus(unsigned char,int,int);
bool newball(int);
void killbonus();
void affichescore(int,int);
void setscorename(const char*,int);
void kill_BFX();
void savescores();
void nextlevel();
void prevlevel(int);
void cooltext(int,int,const char*,unsigned long int);
void high_input(int &rank);
void winnar();

inline void play_surround(const SAMPLE* spl,const int vol,const int freq,const int x)
{
	play_sample(spl,vol,x/2.5,freq,0);
}

void error()
{
	allegro_message("Error'd");
	exit(EXIT_FAILURE);
}

void load()
{
	char compmap[20][11][numLEVELS];
	ifstream plop("plev.bof",ios::in|ios::binary);
	plop.read(reinterpret_cast<char *>(compmap),220*numLEVELS);
	plop.close();
	for (int level=0;level<numLEVELS;level++)
	{
		for (int x=0;x<20;x++)
		{
			for (int y=0;y<11;y++)
			{
 				Level[level].map[x*2][y]=compmap[x][y][level]&0x0F;
				Level[level].map[x*2+1][y]=(compmap[x][y][level]&0xF0)>>4;
			}
		}
	}
}

// ================================================================================
// Entry point
// ================================================================================
int main(int argn, char* argc[])
{
// ======================================== Leak detection
#if defined _DEBUG && defined _MSC_VER
	_CrtSetDbgFlag(_CRTDBG_ALLOC_MEM_DF|_CRTDBG_LEAK_CHECK_DF);
#endif
// =======================================================

	bool bwin=true;
	if (argn>1)
	{
		std::string s(argc[1]);
		if (s.compare("-f")==0)
		bwin=false;
	}
	init(bwin);
	bool bQuit=false;
	while(!bQuit)	// Application loop
	{
		// Intro
		if(!TitleScreen()) break;
		
		// Start new game
		load(); // Load all levels
		for (int i=0;i<numLEVELS;i++)
		{
			Level[i].wall=10+i/4;	// Wall strenght
			for(int i2=0;i2<20;i2++)// Borders
			{
				Level[i].border[i2][0]=rand()%3;
				Level[i].border[i2][1]=rand()%3;
			}
		}

		for(int i=0;i<numBALLS;i++)
		{
			Ball[i].bIsOut=false;
		}
		ball_init();
		reset_bonus();
		Player.level=0;
#ifdef TEST_STARTING_LEVEL
		Player.level=TEST_STARTING_LEVEL;
#endif
		initmap();
		Player.gball=0;
		Player.lenght=32;
		Player.life=3;
		Player.mode=0;
		Player.bonustime=0;
		Player.bonusname="I like turtles";
		Player.lazerx=0;
		Player.lazery=0;
		ScoreTable[10].score=0;
		setscorename("              ",10);
		Ball[0].x=16;
		Ball[0].y=100;
		Ball[0].bIsAlive=true;
		Ball[0].bIsGlued=true;
		Player.numballs=1;
		Player.ballsout=0;//?
		kill_BFX();

		while (Player.life>=0) // Main loop (playing)
		{
			drawmap();
			drawscore();
			player();
			draw_bonus();
			ball_move();
			effects();
			check_pause();
		    blit(buffer, screen, 0,0,0,0,640,480);
		   	clear_to_color(buffer,1);
			Yield();
			//if(game_time2>500){color_cycle();game_time2=0;}
			if (check_esc()) break;
		}
	}
	deinit();
	return 0;
}END_OF_MAIN()

inline void init(bool bWindowed)
{
	srand(time(NULL));
	int res;
	if (allegro_init()) exit(EXIT_FAILURE);

	if (install_sound(DIGI_AUTODETECT,MIDI_NONE,NULL)==-1)
	{
		allegro_message("install_sound failed: %s",allegro_error);
	}
	set_color_depth(32);
	set_color_conversion(COLORCONV_8_TO_24);
	if (bWindowed)
		res = set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0);
	else
		res = set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0);
	if (res != 0)
	{
		allegro_message("Cannot create window: %s",allegro_error);
		exit(-1);
	}
	set_window_title("Poeng");
	install_timer();
	LOCK_VARIABLE(ticks);
	LOCK_FUNCTION(Timer);
	install_int_ex(&Ticker,BPS_TO_TIMER(120));
	install_keyboard();
	install_mouse();
	// Bitmaps
	datafile = load_datafile("poengstuff.dat");
	if(datafile == NULL)
	{
		allegro_message("poengstuff.dat missing.");
		exit(EXIT_FAILURE);
	}
	set_palette((RGB*)datafile[7].dat);
	buffer = create_bitmap(640,480);	// Buffer
	levelbmp = create_bitmap(640,352);	// Bricks layer
	layer0 = create_bitmap(640,352);	// Background layer
	layer1 = create_bitmap(640,352);	// Shadows layer
	clear_to_color(layer1,0);
	layer_wall = create_bitmap(16,352);
	b1=create_bitmap(640,32);	// Border layers
	b2=create_bitmap(640,32);	//
	for(int y=0;y<11;y++)
	{
		blit((BITMAP*)datafile[6].dat,layer_wall,0,0,0,y*32,16,32);
	}
	font=(FONT*)datafile[8].dat;
	// Set default values.
	for (int i=0;i<8;i++)//brick score val
	{
		BricksValues[i].score=50+i*10;
	}
	// Load scores.
    fstream plop("pscores.zob");
	if (!plop)
	{
		// No file so create one.
        fstream plop("pscores.zob",ios::out|ios::binary);
		for (int i=0;i<10;i++)
		{
		setscorename("Poeng          ",i);
		ScoreTable[i].score=55000-(5000+i*5000);
		plop.write(reinterpret_cast<char *>(&ScoreTable[i]),sizeof(ScoreTable[i]));
		}
		plop.close();
	}
	else
	{
		// Read.
		for (int i=0;i<10;i++)
		{
			plop.read(reinterpret_cast<char *>(&ScoreTable[i]),sizeof(ScoreTable[i]));
		}
		plop.close();
	}
}

// Cleanup.
void deinit()
{
	savescores();
	clear_keybuf();
	destroy_bitmap(b1);
	destroy_bitmap(b2);
	destroy_bitmap(layer0);
	destroy_bitmap(layer1);
	destroy_bitmap(layer_wall);
	destroy_bitmap(buffer);
	destroy_bitmap(levelbmp);
	unload_datafile(datafile);
}

// Reset balls. Called on level switch or upon dying.
void ball_init()
{
	for (int i=0;i<numBALLS;i++)
	{
		Ball[i].x=17;
		if (Ball[i].bIsOut)
		{
			Ball[i].bIsOut=false;
			Ball[i].bIsAlive=true;
			Player.numballs++;
			Player.ballsout--;
			continue;
		}
		Ball[i].x=0;
		Ball[i].y=0;
		Ball[i].vx=2;Ball[i].vy=0;
		Ball[i].bIsAlive=false;
		Ball[i].bIsOut=false;
		Ball[i].bIsGlued=false;
	}
}


// Balls update.
void ball_move()

{
	int touche=0;
	for (int i=0;i<numBALLS;i++)
	{
		if (Ball[i].bIsGlued)	// Glue
		{
			Ball[i].x=16;
			Ball[i].y=Player.y+(Player.lenght/2)-8;
			draw_sprite(buffer,(BITMAP*)datafile[0+(Player.gball>0)].dat,(int)Ball[i].x,(int)Ball[i].y);
			continue;
		}
		if(!Ball[i].bIsAlive||Ball[i].bIsOut) continue;	// Jump if lost.
		Ball[i].x+=Ball[i].vx;
		Ball[i].y+=Ball[i].vy;
		Ball[i].vy+=0.1;
		if (abs((int)Ball[i].vy)>12) Ball[i].vy/=2;

		// Check player collision.
		if (Ball[i].x<=16)
		{
			touche=(int)Ball[i].y+16-Player.y;
			if((touche>0)&&(touche<Player.lenght+16))
			{
				Ball[i].bIsGlued=(Player.mode==2);	// Glued?
				// Bounce.
				//if (Ball[i].vx=-8.1234) Ball[i].vx=3;?
				Ball[i].vx=3;
				Ball[i].vx=abs((int)Ball[i].vx)+Player.push/50.0;
				Ball[i].vy=(float)(touche-Player.lenght/2)/3;
				play_sample((SAMPLE*)datafile[42].dat,155,0,1000,0);
			}
		}

		if 	(Level[Player.level].wall>0)
		{
			if (Ball[i].x>600)
			{
				Ball[i].x=600;
				Ball[i].vx=-abs((int)Ball[i].vx);
				Level[Player.level].wall--;
				res_BFX(0,0,5,2);
				play_sample((SAMPLE*)datafile[52].dat,255,255,1000,0);
				if(Level[Player.level].wall==0)	// Wall destroyed.
					play_sample((SAMPLE*)datafile[51].dat,255,255,1000,0);
			}
		}

		// Ball lost.
		if (Ball[i].x<4)
		{
#ifdef TEST_CANTLOSE
			Ball[i].vx=4;
			return;
#endif
			Ball[i].bIsAlive=false;
			Player.numballs--;
			if (Player.numballs==0)
			{
				// Destroy balls that went through.
         		for(int t=0;t<numBALLS;t++)
				{
					Ball[t].bIsOut=false;
				}
				Player.ballsout=0;
				// Go to previous stage.
				if (Player.level>0)
				{
					prevlevel(i);
					return;
				}
				else
				{
					// Lose a life.
					Player.life--;
					ball_init();
					Ball[0].x=16;
					Ball[0].y=100;
					Ball[0].bIsAlive=true;
					Ball[0].bIsGlued=true;
					Player.numballs=1;
					play_sample((SAMPLE*)datafile[51].dat,255,0,900,0);
					return;
				}
			}
		}

#ifdef TEST_CHEATS
		if (key[KEY_N])
		{
			Ball[i].x=640;
			clear_keybuf();
			rest(100);
		}
#endif
		if (Ball[i].x>622)
		{
			Ball[i].bIsOut=true;
			Ball[i].bIsAlive=false;
			Player.ballsout++;
			Player.numballs--;
			if (Player.numballs==0)
			{
				nextlevel();
				return;
			}
		}
		if (Ball[i].y>400) {Ball[i].y=400;Ball[i].vy=-Ball[i].vy/1.1;play_sample((SAMPLE*)datafile[43].dat,128,Ball[i].x/3,1000,0);}
		if (Ball[i].y<64) {Ball[i].y=64;Ball[i].vy=-Ball[i].vy;play_sample((SAMPLE*)datafile[43].dat,128,Ball[i].x/3,1000,0);}
		checkcol(i);
		draw_sprite(buffer,(BITMAP*)datafile[0+(Player.gball>0)].dat,(int)Ball[i].x,(int)Ball[i].y);
	}
}

// Player update.
void player()
{
	if (mouse_b&1)
	{
		// Laser.
		if ((Player.mode==3)&&(Player.lazerx==0))
		{
			Player.lazerx=18;
			Player.lazery=Player.y+14;
			play_sample((SAMPLE*)datafile[49].dat,255,127,1000,0);
		}
		
		// Unglue.
		for (int i=0;i<numBALLS;i++)
		{
			if (!Ball[i].bIsGlued) continue;
			Ball[i].bIsGlued=false;
			Ball[i].vx=1.5+Player.push/50.0;
		}
	}
	Player.y=mouse_y+(64-mouse_y)*(mouse_y<64)+((416-Player.lenght)-mouse_y)*(mouse_y>(416-Player.lenght));
	draw_sprite(buffer,(BITMAP*)datafile[9+Player.mode].dat,8,Player.y);
	// Laser movement.
	if (Player.lazerx>0)
	{
		draw_sprite(buffer,(BITMAP*)datafile[39].dat,Player.lazerx,Player.lazery);
		Player.lazerx+=15;
		if (tile(Player.lazerx+16,Player.lazery)>0)
		{
			breaktile((Player.lazerx+16)/16,(Player.lazery-64)/32);
            Player.lazerx=0;
		}
		if(Player.lazerx>640)
		    Player.lazerx=0;
	}

	// Push.
	int rx,ry;
	get_mouse_mickeys(&rx,&ry);
	if (rx>Player.push) Player.push=(char)rx;
	Player.push--;
	if (Player.push<0) Player.push=0;

	// Bonus bar.
	if (Player.bonustime>0)
	{
	    Player.bonustime--;
	    textprintf_right_ex(buffer, font, 256, 17,0xE100,1, "%s",Player.bonusname);
       	rectfill(buffer,258,17,258+(Player.bonustime)/8,24,0xE100);
		if (Player.bonustime==0)
		{
			Player.mode=0;
			Player.lenght=32;
		}
	}
}

// Stage change.
void initmap()
{
   	clear_to_color(levelbmp,0xFF00FF);
   	clear_to_color(layer1,0xFF00FF);	// Shadows.
   	Level[Player.level].broken=0;
	for(int x=0;x<40;x++){for(int y=0;y<11;y++){
		if(Level[Player.level].map[x][y]>0)
		{
			blit((BITMAP*)datafile[5].dat,levelbmp,(Level[Player.level].map[x][y]-1)*16,0,x*16,y*32,16,32);
			rectfill(layer1,x*16,y*32,15+x*16,31+y*32,0);
			if (Level[Player.level].map[x][y]!=8) Level[Player.level].broken++;	// Breakables count.
		}
	}}
	for(int x=0;x<20;x++)	// Borders.
	{
		blit((BITMAP*)datafile[4].dat,b1,Level[Player.level].border[x][0]*32,0,x*32,0,32,32);
		blit((BITMAP*)datafile[4].dat,b2,Level[Player.level].border[x][1]*32,32,x*32,0,32,32);
		blit((BITMAP*)datafile[3].dat,layer0,32,(Player.level%4)*32,x*32,0,32,32);
	}
	for(int x=0;x<20;x++){	// Background.
    for(int y=1;y<11;y++){
		blit((BITMAP*)datafile[3].dat,layer0,0,(Player.level%4)*32,x*32,y*32,32,32);
	}}
}

void drawmap()
{
	draw_sprite(buffer,layer0,0,64);
	draw_sprite(buffer,layer1,8,72);
	draw_sprite(buffer,levelbmp,0,64);
	if	(Level[Player.level].wall>0)
		draw_sprite(buffer,layer_wall,624,64);
	draw_sprite(buffer,b1,0,32);
	draw_sprite(buffer,b2,0,416);
}

// Returns tile number at screen coords.
int tile(int x,int y)
{
	x=x>>4;y=(y-64)>>5;
  	if ((y<0)||(y>10)||(x<0)||(x>39)) return 0;	// Out of bounds.
	if (y<0) y=0;
	if (y>10) y=10;
	return Level[Player.level].map[x][y];
}

void breaktile(int x,int y)	// x,y in tile coords.
{
   	if ((y<0)||(y>10)||(x<0)||(x>39)) return;		// Out of bounds.
	if (Level[Player.level].map[x][y]==0) return;	// Nothing to break.
   	
	// 8 is unbreakable.
	if (Level[Player.level].map[x][y]==8)
	{
		play_surround((SAMPLE*)datafile[47].dat,255,1000,x*16);
		return;
	}
	// 9 is metal.
	if (Level[Player.level].map[x][y]==9)
	{
	    res_BFX(x,y,19,1);
	 	play_surround((SAMPLE*)datafile[46].dat,255,1000,x*16);
		return;
	}
	
	// Normal bricks.
	play_surround((SAMPLE*)datafile[45].dat,64,1000+(Level[Player.level].map[x][y])*16,x*16);
	rectfill(levelbmp,x<<4,y<<5,x*16+15,y*32+31,0xFF00FF);
	Level[Player.level].broken--;

	// Clear wall when no more bricks.
	if (Level[Player.level].broken==0)
	{
		play_sample((SAMPLE*)datafile[51].dat,255,127,1000,0);
		Level[Player.level].wall=0;
	}

	ScoreTable[10].score+=((Player.gball>0)+1)*BricksValues[ static_cast<int>(Level[Player.level].map[x][y]) ].score;

	// Randomly spawn a powerup.
	if (rand()%bonusRAND==0)
	{
		res_bonus(x,y,rand()%7);
	}

	// Effects.
	if (res_BFX(x,y,5,0)) rectfill(levelbmp,x*16,y*32,x*16+15,y*32+31,0xFFFFFF);

	rectfill(layer1,x*16,y*32,15+x*16,32+y*32,0xFF00FF);// Removes the shadow.
	Level[Player.level].map[x][y]=0;
}

// Check collisions for ball ni.
inline int checkcol(int i) 
{
	int m[8]={1,1,13,1,1,13,13,13}; // 4 points.
	int xc,yc;
	xc=yc=0;
	bool xt,yt;
	xt=yt=false;
	
	for (int t=0;t<8;t=t+2)
	{
		if (tile((int)(m[t]+Ball[i].x+Ball[i].vx),m[t+1]+(int)(Ball[i].y))>0)
		{
			yc=m[t+1]+(int)(Ball[i].y);
			xc=m[t]+(int)(Ball[i].x+Ball[i].vx);
			xt=true;
			break;
		}
		if (tile((int)(m[t]+Ball[i].x),m[t+1]+(int)(Ball[i].y+Ball[i].vy))>0)
		{
			xc=m[t]+(int)Ball[i].x;
			yc=m[t+1]+(int)(Ball[i].y+Ball[i].vy);
			yt=true;
			break;
		}
	}
	if (xt)
	{
		Ball[i].vx=-Ball[i].vx;
		Ball[i].vy=Ball[i].vy*1.08;
		breaktile(xc/16,(yc-64)/32);
	}
	if (yt&&!xt)
	{
		Ball[i].vy=-Ball[i].vy*1.08;
		breaktile(xc/16,(yc-64)/32);
	}
	return (xt||yt);
}

// Update temporary graphic effects.
void effects()
{
	for(int i=0;i<numEFFETS;i++)
	{
		if (BFX[i].timer==-1) continue;

		switch (BFX[i].type)
		{
		case 0:	// Basick brick blinking.
			if (BFX[i].timer==0)
				rectfill(levelbmp,BFX[i].x*16,BFX[i].y*32,BFX[i].x*16+15,BFX[i].y*32+31,0xFF00FF);
			break;
		case 1:	// Grey brick.
   			blit((BITMAP*)datafile[5].dat,levelbmp,(8+BFX[i].timer/5)*16,0,BFX[i].x*16,BFX[i].y*32,16,32);
   			if (BFX[i].timer==0) Level[Player.level].map[BFX[i].x][BFX[i].y]=1;	// Grey bricks becomes red.
			break;
		case 2:	// Wall hit.
	    	draw_sprite(buffer,layer_wall,622+rand()%2,64);
	    	break;
		case 3:	// Explosion.
		    draw_sprite(buffer,(BITMAP*)datafile[38-BFX[i].timer/3].dat,BFX[i].x*16-24,BFX[i].y*32-16);
		    break;
		default:
			break;
		}
		--BFX[i].timer;
	}
}

bool TitleScreen()
{
	int rank=-1;

	// New score ?
	for (int i=0;i<10;i++)
	{
		if(ScoreTable[10].score>=ScoreTable[i].score)
		{
			for (int j=9;j>i;j--)
			{
				ScoreTable[j]=ScoreTable[j-1];
			}
			ScoreTable[i].score=ScoreTable[10].score;
				for (int t=0;t<16;t++)
				{
					ScoreTable[i].nom[t]=ScoreTable[10].nom[t];
				}
			rank=i;
			break;
		}
	}

	while (!(mouse_b&1))
	{
		Yield();
   		clear_to_color(buffer,1);
		textprintf_centre_ex(buffer,font,320,400,0xFFFFFF,1, "Click to start");
		affichescore(248,222);
		draw_sprite(buffer,(BITMAP*)datafile[53].dat,200,100);
		textout_ex(buffer,font,"1.17",442,140,0x686868,-1);

		blit(buffer, screen, 0,0,0,0,640,480);
	    
		if (rank>-1)
		{
			high_input(rank);
		}
   		clear_to_color(buffer,1);

		if(check_esc()) return false;
	};
	while (mouse_b&1){};	// Wait for release.
	return true;
}

// Draw score n'stuff.
void drawscore()
{
	textprintf_ex(buffer, font, 16, 8,0xFFFFFF,1, "SCORE %lu",ScoreTable[10].score);
	for(int i=0;i<Player.life;i++)
	{
		draw_sprite(buffer,(BITMAP*)datafile[40].dat,16+i*5,18);
	}
	textout_ex(buffer, font,"PUSH", 16, 450,0xE0E0E0,1);
	textprintf_ex(buffer, font, 300, 450,0xFFFFFF,1, "STAGE %d",Player.level+1);
	rectfill(buffer,52,450,52+Player.push,458,0xFF0000);
	if (Player.gball>0)
	{
       	textout_ex(buffer, font, "x2", 128, 8,0xFFE500,1);
       	rectfill(buffer,146,8,146+Player.gball/64,15,0xCDB200);
		--Player.gball;
	}
}

bool check_esc()
{
	if (key[KEY_ESC])
	{
		rectfill(screen,205,220,430,258,0);
   		rect(screen,206,221,429,257,0xFFFFFF);
		textout_centre_ex(screen, font,"Press [ESC] again to exit,",320,230,0xE0E0E0,1);
		textout_centre_ex(screen, font,"any other key to continue .",320,240,0xE0E0E0,1);
		while (key[KEY_ESC]){};
		do
		{
 			clear_keybuf();
 			Yield();
			if (key[KEY_ESC])
			{
           		while (key[KEY_ESC]){};
           		clear_keybuf();
				return true;
			}
		}while ((!keypressed())&&(!key[KEY_ESC]));
	}
	return false;
}

/*
void color_cycle()	// Deprecated
{
	return;
	RGB color[4];
	for (int i=0;i<4;i++)
	{
		get_color(64+i,&color[i]);
	}
	set_color(64,&color[1]);
	set_color(65,&color[2]);
	set_color(66,&color[3]);
	set_color(67,&color[0]);
}*/

void check_pause()
{
	if(key[KEY_P])
	{
   		while (key[KEY_P]);
		textout_ex(screen, font,"**PAUSED**",500, 450,0xC20000,1);
		while (!key[KEY_P])
			Yield();
   		while (key[KEY_P]);
   	}
   	clear_keybuf();
}

// Reserve an effect.
bool res_BFX(unsigned short int x,unsigned short int y,unsigned short int timer,unsigned short int type)
{
	for(int i=0;i<numEFFETS;i++)
	{
		if (BFX[i].timer>=0) continue;
		BFX[i].timer=timer;BFX[i].x=x;BFX[i].y=y;
		BFX[i].type=type;
		return true;
	}
	return false;
}

void res_bonus(int x,int y,unsigned char type)
{
	for(int i=0;i<numBONUS;i++)
	{
		if(Bonus[i].bIsActive) continue;
		Bonus[i].bIsActive=true;
		Bonus[i].x=x<<4;Bonus[i].y=(y<<5)+64;
		Bonus[i].type=type;
		Bonus[i].t=0;
		switch (Bonus[i].type)
		{
			case 5:
				Bonus[i].animtime[0]=5;
				Bonus[i].animtime[1]=10;
				break;
			case 6:
				Bonus[i].animtime[0]=15;
				Bonus[i].animtime[1]=30;
				break;
			default:
				Bonus[i].animtime[0]=100;
				Bonus[i].animtime[1]=104;
				break;
		}
		return;
	}
}

void draw_bonus()
{
	// Brute force ball/bonus collision.
	for(int i=0;i<numBONUS;i++)
	{
		if(!Bonus[i].bIsActive) continue;

		for(int ib=0;ib<numBALLS;ib++)
		{
			if (!Ball[ib].bIsAlive) continue;
			if (((int)(Ball[ib].x+8)/16==Bonus[i].x/16)&&((int)(Ball[ib].y+8)/32==Bonus[i].y/32))
			{
					Bonus[i].bIsActive=false;
					givebonus(Bonus[i].type,ib,i);
					break;
			}
		}
    	draw_sprite(buffer,(BITMAP*)datafile[(13+(Bonus[i].type)*2)+(Bonus[i].t>Bonus[i].animtime[0])].dat,Bonus[i].x,Bonus[i].y);
    	Bonus[i].t++;
    	if (Bonus[i].t>Bonus[i].animtime[1]) Bonus[i].t=0;
	}
}

void reset_bonus()
{
	for (int i=0;i<numBONUS;i++)
	{
		Bonus[i].bIsActive=false;
		Bonus[i].animtime[0]=100;
		Bonus[i].animtime[1]=104;
	}
}

void givebonus(unsigned char type,int balle,int nb)
{
	switch(type)
	{
		case 0:
			Player.mode=1;
			Player.lenght=64;
			Player.bonusname="BROAD";
			Player.bonustime=1024;
			play_sample((SAMPLE*)datafile[48].dat,255,127,1000,0);
			break;
		case 1:
			Player.mode=2;
			Player.lenght=32;
			Player.bonusname="GLUE";
			Player.bonustime=1024;
			break;
		case 2:
			Player.mode=3;
			Player.lenght=32;
			Player.bonusname="LASER";
			Player.bonustime=1024;
			play_sample((SAMPLE*)datafile[50].dat,255,127,1000,0);
			break;
		case 3:	// 1 extra ball.
		    newball(balle);
		    break;
   		case 4:	// 3 extra balls.
		    newball(balle);
   		    newball(balle);
   		    newball(balle);
			break;
		case 5:	// Bomb.
		    int bx,by;
		    bx=Bonus[nb].x/16;
		    by=Bonus[nb].y/32;
            res_BFX(bx,by,21,3);
            by-=2;
            for (int ty=-2;ty<3;ty++)
            {
				for (int tx=-2;tx<3;tx++)
				{
					breaktile(bx+tx,by+ty);
				}
			}
            play_sample((SAMPLE*)datafile[44].dat,255,127,1000,0);
			break;
		case 6:	// Golden ball.
		    Player.gball=1000;
		    break;
	}
}

bool newball(int balle)
{
	for(int i=0;i<numBALLS;i++)
	{
		if(Ball[i].bIsAlive) continue;
		
		Ball[i].bIsAlive=true;
		Ball[i].bIsOut=false;
		Ball[i].x=Ball[balle].x;
		Ball[i].y=Ball[balle].y;
		Ball[i].vx=abs((int)Ball[balle].vx)+(rand()%10)/10.;
		Ball[i].vy=abs((int)Ball[balle].vy)+(rand()%10)/10.;
		Player.numballs++;
		return true;
	}
	return false;
}

void killbonus()
{
	for(int i=0;i<numBONUS;i++)
	{
		Bonus[i].bIsActive=false;
	}
}

void affichescore(int x,int y)
{
	for (int i=0;i<10;i++)
	{
        textprintf_right_ex(buffer, font, x, 12*i+y,0xFF0000,1,"%i.",i+1);
        textprintf_ex(buffer, font, x+82, 12*i+y,0xE100,-1,"%s",ScoreTable[i].nom);
		cooltext(x+80, 12*i+y,"%u",ScoreTable[i].score);
		hline(buffer,x-2,12*i+y+8,x+78,31);
	}
	textout_ex(buffer,font,"** TOP TEN **",x+34,y-20,0xFF0000,-1);
}

void setscorename(const char* s,int rank)
{
	for (int t=0;t<15;t++)
	{
		ScoreTable[rank].nom[t]=s[t];
	}
	ScoreTable[rank].nom[15]=0;
}

void kill_BFX()
{
    for(int i=0;i<numEFFETS;i++)
	{
		BFX[i].timer=-1;
	}
}

void savescores()
{
	fstream plop;
    plop.open("pscores.zob",ios::out|ios::ate);
	for (int i=0;i<10;i++)
	{
		plop.write(reinterpret_cast<char *>(&ScoreTable[i]),sizeof(ScoreTable[i]));
	}
	plop.close();
}

void nextlevel()
{
		Player.level++;
		if (Player.level==32)
		{
			winnar();
			return;
		}
		ball_init();
		initmap();
		killbonus();
        kill_BFX();
}

void prevlevel(int b)
{
	Ball[b].bIsOut=true;
	Player.ballsout=1;
	ball_init();
	Player.numballs=1;
	Ball[b].bIsGlued=false;
	Ball[b].x=620;Ball[b].vx=-2;
	Ball[b].vx=-8.1234;
	unsigned int penalty=100+Player.level*10;
	if (ScoreTable[10].score>penalty) ScoreTable[10].score-=penalty;
	Player.level--;
	killbonus();
	kill_BFX();
	initmap();
}

void cooltext(int x,int y,const char *c,unsigned long int n)
{
	textprintf_right_ex(buffer, font, x,y+1,0xFF0000,-1,c,n);
	textprintf_right_ex(buffer, font, x,y,0xFFFFFF,-1,c,n);
}

void high_input(int &rank)
{
    textout_ex(screen,font,"ENTER YOUR NAME",275,202,0xFF0000,1);
	char Nom[16];
	int iter=0;
	bool bDone=false;
   	textprintf_ex(screen, font,330,12*rank+222,0xFFFFFF,1,"<");
	do
	{
		while(keypressed())
		{
			Yield();
			int newkey=readkey();
			char ASCII=newkey&0xFF;
			char scancode=newkey>>8;
			if(ASCII >= 32 && ASCII <= 126 && iter<15)
				{
				Nom[iter]=ASCII;
				Nom[iter+1]=0;
  			 	textprintf_ex(screen, font,330,12*rank+222,0xFFFFFF,1,"%s<",Nom);
				++iter;
				}
				else
				{
					switch(scancode)
					{
						case KEY_BACKSPACE:
   						--iter;
   						if(iter<0) iter=0;
						Nom[iter]=0;
        				textprintf_ex(screen, font,330,12*rank+222,0xFFFFFF,1,"                ");
  		 				textprintf_ex(screen, font,330,12*rank+222,0xFFFFFF,1,"%s<",Nom);
						break;
					    case KEY_ENTER:
					    bDone=true;
					    break;
					}
				}
		}
	}while(!bDone);
	
	for (int i=0;i<16;i++)
	{
		ScoreTable[rank].nom[i]=Nom[i];
	}
	rank=-1;
}

void winnar()
{
	rectfill(screen,180,190,458,288,0);
   	rect(screen,181,191,457,287,0xFFFFFF);
    textout_centre_ex(screen,font,"Congratulations!",320,200,0xFF0000,1);
    textout_centre_ex(screen,font,"You broke all them bricks.",320,230,0xFFFFFF,1);
    textout_centre_ex(screen,font,"Thanks for playing.",320,240,0xFFFFFF,1);
    textout_centre_ex(screen,font,"Press any key to continue...",320,270,0xC8C8C8,1);
    clear_keybuf();
    readkey();
    
    // Reset
	load();
	for (int i=0;i<numLEVELS;i++)
	{
		Level[i].wall=10+i;
		for(int i2=0;i2<20;i2++)
		{
			Level[i].border[i2][0]=rand()%3;
			Level[i].border[i2][1]=rand()%3;
		}
	}
	for(int i=0;i<numBALLS;i++)
	{
		Ball[i].bIsOut=false;
	}
	ball_init();
	reset_bonus();
	Player.level=0;//test
	initmap();
	Player.gball=0;
	Player.lenght=32;
	Player.life++;
	Player.mode=0;
	Player.bonustime=0;
	Player.lazerx=0;
	Player.lazery=0;
	ScoreTable[10].score+=10000;
	Ball[0].x=16;
	Ball[0].y=100;
	Ball[0].bIsAlive=true;
	Ball[0].bIsGlued=true;
	Player.numballs=1;
	Player.ballsout=0;
	kill_BFX();
}
