#define MAX_RANGE 10000

#define CREDITS_SPACE 480

#define MAX_IMAGES 256
#define MAX_SOUNDS 256

#define CONFIG_GFX_MODE           0
#define CONFIG_FX_ON              1
#define CONFIG_RESET_HUDS         2
#define CONFIG_SOUND_ON           3
#define CONFIG_MUSIC_ON           4
#define CONFIG_SFX_VOLUME         5
#define CONFIG_MUSIC_VOLUME       6
#define CONFIG_VSYNC              7
#define CONFIG_NET_MODE           8
#define CONFIG_COMMENTARY         9
#define CONFIG_COMMENTARY_VOLUME 10
#define CONFIG_DEPTH             11
#define CONFIG_UPLOAD            12
#define CONFIG_FINE_TUNE         13
#define CONFIG_MIX               14

/* sound defines */
#define SOUND_SWING0          0
#define SOUND_SWING1          1
#define SOUND_SWING2          2
#define SOUND_BALLCOLLISION0  3
#define SOUND_BALLCOLLISION1  4
#define SOUND_BALLCOLLISION2  5
#define SOUND_HOLESINK        6
#define SOUND_HOLEFINISH00    7
#define SOUND_HOLEFINISH01    8
#define SOUND_HOLEFINISH02    9
#define SOUND_HOLEFINISH03   10
#define SOUND_HOLEFINISH10   11
#define SOUND_HOLEFINISH11   12
#define SOUND_HOLEFINISH12   13
#define SOUND_HOLEFINISH13   14
#define SOUND_HOLEFINISH20   15
#define SOUND_HOLEFINISH21   16
#define SOUND_HOLEFINISH22   17
#define SOUND_HOLEFINISH23   18
#define SOUND_AHH0           19
#define SOUND_AHH1           20
#define SOUND_BALLSPLASH     21
#define SOUND_BALLROTATE     22
#define SOUND_MENUSELECT     23
#define SOUND_MENUESCAPE     24
#define SOUND_MENUSLIDER     25
#define SOUND_MENUITEMSEL    26
#define SOUND_COIN           27
#define SOUND_BALLZAPPED     28
#define SOUND_BALLTELEPORT   29
#define SOUND_TITLE_SWING    30

#define MAX_AVATARS 17

#define MAX_ANIMDEF_FRAMES 6

#define MAX_BALL_ANIM_MODES 4

#define MAX_HOLE_POLYS 32
#define MAX_HOLE_VERTS 64
#define MAX_HOLE_PIC_LAYERS 3

#define MAX_PLAYERS 4
#define MAX_PLAYER_COURSES_COMPLETED 16
#define MAX_PLAYER_SAVED_STATS 16

#define MAX_COURSE_HOLES 18
#define MAX_COURSE_TOPSCORES 3

#define MAX_TRAJECTORY_POINTS 24

#define VERT_FLAG_TEE               0
#define VERT_FLAG_HOLE              1
#define VERT_FLAG_TREE_0          100
#define VERT_FLAG_TREE_1          101
#define VERT_FLAG_TREE_2          102
#define VERT_FLAG_TREE_3          103
#define VERT_FLAG_ANIMAL_0         50
#define VERT_FLAG_ANIMAL_1         51
#define VERT_FLAG_ANIMAL_2         52
#define VERT_FLAG_HAZARD_WATER     30
#define VERT_FLAG_HAZARD_SAND      31
#define VERT_FLAG_HAZARD_ROUGH     32
#define VERT_FLAG_HAZARD_SLIME     33
#define VERT_FLAG_PIPE_ENTER       40
#define VERT_FLAG_PIPE_EXIT        41
#define VERT_FLAG_INDENT_HILL      20
#define VERT_FLAG_INDENT_RUT       21
#define VERT_FLAG_POLY_MORPH       60
#define VERT_FLAG_POLY_MOVE_HORIZ  61
#define VERT_FLAG_POLY_MOVE_VERT   62
#define VERT_FLAG_POLY_MOTION_AREA 63
#define VERT_FLAG_GOPHER_MOUND     70
#define VERT_FLAG_CLOUD_VERT       80
#define VERT_FLAG_CLOUD_HORIZ      81
#define VERT_FLAG_COIN_0          120
#define VERT_FLAG_LASER_SEND      110
#define VERT_FLAG_LASER_RECV      111
#define VERT_FLAG_LASER_RESPAWN   112
#define VERT_FLAG_TELEPORT        130
#define VERT_FLAG_CONVEYOR        140
#define VERT_FLAG_BLINKER         145
#define VERT_FLAG_POLY_DOOR_HORIZ 150
#define VERT_FLAG_POLY_DOOR_VERT  151
#define VERT_FLAG_SMASH_RESPAWN   152
#define VERT_FLAG_BUBBLE_HORIZ    153
#define VERT_FLAG_BUBBLE_VERT     154
#define VERT_FLAG_NULL            999

#define MAX_VERT_FLAG_TYPES 255
#define MAX_VERT_RADIUS 1000
#define MAX_VERT_REFS 8
#define MAX_VERT_REF_TYPES 20

#define DEFAULT_DOOR_DURATION 100

#define MAX_COURSE_VERT_PIC_TYPES 16
#define MAX_VERT_ANIMS 4
#define MAX_COURSE_ANIMAL_TYPES 4
#define MAX_ANIMAL_ANIMS 4
#define MAX_COURSE_OBJECT_TYPES 8
#define MAX_OBJECT_ANIMS 4
#define MAX_COIN_PICS 4

#define GAMEMODE_STROKE_PLAY 0
#define GAMEMODE_MATCH_PLAY 1
#define GAMEMODE_COIN_COLLECT 2

#define GAMESTATE_START_HOLE 0
#define GAMESTATE_READY_TOPLAY 1
#define GAMESTATE_HOLE_FINISHED 2
#define GAMESTATE_SCOREBOARD_SEGIN 3
#define GAMESTATE_SCOREBOARD_SEGMID 4
#define GAMESTATE_SCOREBOARD_SEGOUT 5
#define GAMESTATE_QUIT_PROMPT 6
#define GAMESTATE_COURSE_COMPLETED_1P 7
#define GAMESTATE_COURSE_COMPLETED_XP 8
#define GAMESTATE_COURSE_COMPLETED_1P_VICTORY_SEGIN 9
#define GAMESTATE_COURSE_COMPLETED_XP_VICTORY_SEGIN 10
#define GAMESTATE_COURSE_COMPLETED_1P_VICTORY_SEGMID 11
#define GAMESTATE_COURSE_COMPLETED_XP_VICTORY_SEGMID 12
#define GAMESTATE_COURSE_COMPLETED_1P_VICTORY_SEGOUT 13
#define GAMESTATE_COURSE_COMPLETED_XP_VICTORY_SEGOUT 14
#define GAMESTATE_COIN_COLLECT_FINISHED 15
#define GAMESTATE_COIN_COLLECT_FAILED_STROKES 16
#define GAMESTATE_COIN_COLLECT_FAILED_TIME 17
#define GAMESTATE_PLAYER_FINISHED_HOLE 18

#define TITLE_SONG_FILENAME "vgolf.xm"
#define CONFIG_FILE_FILENAME "vgolf.cfg"
#define MESSAGE_FILE_FILENAME "vgolf.msg"

//#define MAX_CLUB_POWER 10
#define MAX_CLUB_POWER 100

#define BALL_MODE_IDLE 0
#define BALL_MODE_HIT 1
#define BALL_MODE_SUNK 2
#define BALL_MODE_WATER_SINKING 3
#define BALL_MODE_WATER_SUNK 4
#define BALL_MODE_PIPE_ENTER 5
#define BALL_MODE_PIPE_EXIT 6
#define BALL_MODE_ON_INDENT 7
#define BALL_MODE_IN_POLYMORPH 8
#define BALL_MODE_DROP 9
#define BALL_MODE_IN_MOTION_AREA 10
#define BALL_MODE_COIN_FINISHED 12
#define BALL_MODE_LASER_ZAPPING 13
#define BALL_MODE_LASER_ZAPPED 14
#define BALL_MODE_ON_CONVEYOR 15
#define BALL_MODE_DOOR_SMASHED 16

#define BALL_STD_RADIUS 8.0

#define BALL_COLLISION_FACTOR 0.5

#define BALL_MAX_HOLEHIT_SPEED 4.95

#define CLUB_STD_LENGTH 40

#define ANIMAL_MOVE_FACTOR 0.15
#define ANIMAL_MOVE_TIME 75
#define ANIMAL_ANIM_TIME 8

#define CLOUD_MOVE_FACTOR 0.25

#define MAX_CONTROLLER_TYPES 5
#define CONTROLLER_KEYBOARD_A 0
#define CONTROLLER_KEYBOARD_B 1
#define CONTROLLER_KEYBOARD_C 2
#define CONTROLLER_KEYBOARD_D 3
#define CONTROLLER_KEYBOARD_X 5
#define CONTROLLER_MOUSE 4
#define CONTROLLER_JOYSTICK_1 6
#define CONTROLLER_JOYSTICK_2 7
#define CONTROLLER_JOYSTICK_3 8
#define CONTROLLER_JOYSTICK_4 9

#define POLY_TYPE_STD_WALL 0
#define POLY_TYPE_EMPTY_WALL 1
#define POLY_TYPE_LASER_WALL 2
#define POLY_TYPE_CONVEYOR_WALL 3
#define POLY_TYPE_MORPH_ROTATE 10
#define POLY_TYPE_MOTION_HORIZ 11
#define POLY_TYPE_MOTION_VERT 12
#define POLY_TYPE_WATER 13
#define POLY_TYPE_BUNKER 14
#define POLY_TYPE_DOOR_L 15
#define POLY_TYPE_DOOR_R 16
#define POLY_TYPE_DOOR_U 17
#define POLY_TYPE_DOOR_D 18

#define GAME_VMESSAGE_QUEUE_SIZE 4

#define FX_SHADOWS 1
#define FX_RESET_HUDS 2

#define MAX_PACKFILES 16

#define MAX_GAME_CHARS 24

#define MAX_SFX_SWING_SAMPLES 3
#define MAX_SFX_COLLISION_SAMPLES 3
#define MAX_SFX_HOLE_FINISH_SAMPLES 4
#define MAX_SFX_HOLE_AHHH_SAMPLES 2

#define MAX_CONVEYOR_SPEED 8

#define COIN_COMPLETE_BONUS 1000

#ifndef random
#define random() rand()
#endif

#ifndef srandom
#define srandom(int) srand(int)
#endif
