#include	<stdio.h>
#include	<allegro.h>

#ifndef ALLEGRO_DOS
	#include	<nl.h>
#endif

//#include	"zone.h"
//#include	"structs.h"
//#include	"common.h"
#include	"strings.h"
#include	"text.h"
#include	"network.h"
#include	"common.h"

inline int LoadFont0()
{
	FILE *f;
	
	f = fopen("font0.dat", "rb");
	fread(Font0, 4, 0x200, f);
	
	fclose(f);
	
	return 0;
}



void DrawCounter10(BITMAP *l, int i, int x, int y, char fillsize, char font){
	unsigned char char1 = i % 10;
	unsigned char char2 = (i / 10) % 10;
	unsigned char char3 = (i / 100) % 10;
	unsigned char char4 = (i / 1000) % 10;
	unsigned char char5 = (i / 10000) % 10;
	unsigned char char6 = (i / 100000) % 10;
	unsigned char char7 = (i / 1000000) % 10;
	unsigned char char8 = (i / 10000000) % 10;
	
	if(char8 == 0 && fillsize < 8)
		char8 = 0x80;
	if(char7 == 0 && fillsize < 7 && char8 == 0x80)
		char7 = 0x80;
	if(char6 == 0 && fillsize < 6 && char7 == 0x80)
		char6 = 0x80;
	if(char5 == 0 && fillsize < 5 && char6 == 0x80)
		char5 = 0x80;
	if(char4 == 0 && fillsize < 4 && char5 == 0x80)
		char4 = 0x80;
	if(char3 == 0 && fillsize < 3 && char4 == 0x80)
		char3 = 0x80;
	if(char2 == 0 && fillsize < 2 && char3 == 0x80)
		char2 = 0x80;
	if(char1 == 0 && fillsize < 1 && char2 == 0x80)
		char1 = 0x80;
	
	if(font == 0){
		char1 += 8;
		char2 += 8;
		char3 += 8;
		char4 += 8;
		char5 += 8;
		char6 += 8;
		char7 += 8;
		char8 += 8;
	}
	else{
		char1 += 0x12;
		char2 += 0x12;
		char3 += 0x12;
		char4 += 0x12;
		char5 += 0x12;
		char6 += 0x12;
		char7 += 0x12;
		char8 += 0x12;
	}
	
	if(char1 >= 0x80) char1 = 0;
	if(char2 >= 0x80) char2 = 0;
	if(char3 >= 0x80) char3 = 0;
	if(char4 >= 0x80) char4 = 0;
	if(char5 >= 0x80) char5 = 0;
	if(char6 >= 0x80) char6 = 0;
	if(char7 >= 0x80) char7 = 0;
	if(char8 >= 0x80) char8 = 0;
	
	DrawSprite(&z, LayerSH[frame-1], 0x105, char1, NORMAL, 0, x+16, y);
	DrawSprite(&z, LayerSH[frame-1], 0x105, char2, NORMAL, 0, x+16-0x08, y);
	DrawSprite(&z, LayerSH[frame-1], 0x105, char3, NORMAL, 0, x+16-0x10, y);
	DrawSprite(&z, LayerSH[frame-1], 0x105, char4, NORMAL, 0, x+16-0x18, y);
	DrawSprite(&z, LayerSH[frame-1], 0x105, char5, NORMAL, 0, x+16-0x20, y);
	DrawSprite(&z, LayerSH[frame-1], 0x105, char6, NORMAL, 0, x+16-0x28, y);
	DrawSprite(&z, LayerSH[frame-1], 0x105, char7, NORMAL, 0, x+16-0x30, y);
	DrawSprite(&z, LayerSH[frame-1], 0x105, char8, NORMAL, 0, x+16-0x38, y);
}



// This is a 16-bit counter
void DrawCounter16(BITMAP *l, int i, int x, int y){
	int char1 = (i & 0xF000) >> 12;
	int char2 = (i & 0xF00) >> 8;
	int char3 = (i & 0xF0) >> 4;
	int char4 = i & 0xF;

	int	a;
	
	if(!draw_frame)
		return;
	
	x += 16;
	x <<= 1;
	
	if(screen_scale_x >> screen_double_x) x = (x >> 1) + 8;
	if(screen_scale_y >> screen_double_y) y >>= 1;
	
	if(y + (8 >> (screen_scale_y >> screen_double_y)) <= screen_buffer_y >> (screen_scale_y >> screen_double_y) && x + (64 >> (screen_scale_x >> screen_double_x)) <= (screen_buffer_x << 1) >> (screen_scale_x >> screen_double_x) && y >= 0 && x >= 0)
	{
		for(a = 0; a < 8; a++)
		{
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x] = Font0[(char1 << 7) + (a << 4)];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(1 >> (screen_scale_x >> screen_double_x))] = Font0[(char1 << 7) + (a << 4) + 1];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(2 >> (screen_scale_x >> screen_double_x))] = Font0[(char1 << 7) + (a << 4) + 2];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(3 >> (screen_scale_x >> screen_double_x))] = Font0[(char1 << 7) + (a << 4) + 3];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(4 >> (screen_scale_x >> screen_double_x))] = Font0[(char1 << 7) + (a << 4) + 4];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(5 >> (screen_scale_x >> screen_double_x))] = Font0[(char1 << 7) + (a << 4) + 5];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(6 >> (screen_scale_x >> screen_double_x))] = Font0[(char1 << 7) + (a << 4) + 6];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(7 >> (screen_scale_x >> screen_double_x))] = Font0[(char1 << 7) + (a << 4) + 7];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(8 >> (screen_scale_x >> screen_double_x))] = Font0[(char1 << 7) + (a << 4) + 8];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(9 >> (screen_scale_x >> screen_double_x))] = Font0[(char1 << 7) + (a << 4) + 9];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(10 >> (screen_scale_x >> screen_double_x))] = Font0[(char1 << 7) + (a << 4) + 10];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(11 >> (screen_scale_x >> screen_double_x))] = Font0[(char1 << 7) + (a << 4) + 11];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(12 >> (screen_scale_x >> screen_double_x))] = Font0[(char1 << 7) + (a << 4) + 12];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(13 >> (screen_scale_x >> screen_double_x))] = Font0[(char1 << 7) + (a << 4) + 13];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(14 >> (screen_scale_x >> screen_double_x))] = Font0[(char1 << 7) + (a << 4) + 14];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(15 >> (screen_scale_x >> screen_double_x))] = Font0[(char1 << 7) + (a << 4) + 15];
		}
		for(a = 0; a < 8; a++)
		{
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(16 >> (screen_scale_x >> screen_double_x))] = Font0[(char2 << 7) + (a << 4)];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(17 >> (screen_scale_x >> screen_double_x))] = Font0[(char2 << 7) + (a << 4) + 1];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(18 >> (screen_scale_x >> screen_double_x))] = Font0[(char2 << 7) + (a << 4) + 2];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(19 >> (screen_scale_x >> screen_double_x))] = Font0[(char2 << 7) + (a << 4) + 3];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(20 >> (screen_scale_x >> screen_double_x))] = Font0[(char2 << 7) + (a << 4) + 4];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(21 >> (screen_scale_x >> screen_double_x))] = Font0[(char2 << 7) + (a << 4) + 5];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(22 >> (screen_scale_x >> screen_double_x))] = Font0[(char2 << 7) + (a << 4) + 6];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(23 >> (screen_scale_x >> screen_double_x))] = Font0[(char2 << 7) + (a << 4) + 7];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(24 >> (screen_scale_x >> screen_double_x))] = Font0[(char2 << 7) + (a << 4) + 8];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(25 >> (screen_scale_x >> screen_double_x))] = Font0[(char2 << 7) + (a << 4) + 9];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(26 >> (screen_scale_x >> screen_double_x))] = Font0[(char2 << 7) + (a << 4) + 10];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(27 >> (screen_scale_x >> screen_double_x))] = Font0[(char2 << 7) + (a << 4) + 11];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(28 >> (screen_scale_x >> screen_double_x))] = Font0[(char2 << 7) + (a << 4) + 12];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(29 >> (screen_scale_x >> screen_double_x))] = Font0[(char2 << 7) + (a << 4) + 13];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(30 >> (screen_scale_x >> screen_double_x))] = Font0[(char2 << 7) + (a << 4) + 14];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(31 >> (screen_scale_x >> screen_double_x))] = Font0[(char2 << 7) + (a << 4) + 15];
		}
		for(a = 0; a < 8; a++)
		{
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(32 >> (screen_scale_x >> screen_double_x))] = Font0[(char3 << 7) + (a << 4)];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(33 >> (screen_scale_x >> screen_double_x))] = Font0[(char3 << 7) + (a << 4) + 1];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(34 >> (screen_scale_x >> screen_double_x))] = Font0[(char3 << 7) + (a << 4) + 2];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(35 >> (screen_scale_x >> screen_double_x))] = Font0[(char3 << 7) + (a << 4) + 3];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(36 >> (screen_scale_x >> screen_double_x))] = Font0[(char3 << 7) + (a << 4) + 4];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(37 >> (screen_scale_x >> screen_double_x))] = Font0[(char3 << 7) + (a << 4) + 5];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(38 >> (screen_scale_x >> screen_double_x))] = Font0[(char3 << 7) + (a << 4) + 6];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(39 >> (screen_scale_x >> screen_double_x))] = Font0[(char3 << 7) + (a << 4) + 7];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(40 >> (screen_scale_x >> screen_double_x))] = Font0[(char3 << 7) + (a << 4) + 8];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(41 >> (screen_scale_x >> screen_double_x))] = Font0[(char3 << 7) + (a << 4) + 9];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(42 >> (screen_scale_x >> screen_double_x))] = Font0[(char3 << 7) + (a << 4) + 10];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(43 >> (screen_scale_x >> screen_double_x))] = Font0[(char3 << 7) + (a << 4) + 11];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(44 >> (screen_scale_x >> screen_double_x))] = Font0[(char3 << 7) + (a << 4) + 12];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(45 >> (screen_scale_x >> screen_double_x))] = Font0[(char3 << 7) + (a << 4) + 13];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(46 >> (screen_scale_x >> screen_double_x))] = Font0[(char3 << 7) + (a << 4) + 14];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(47 >> (screen_scale_x >> screen_double_x))] = Font0[(char3 << 7) + (a << 4) + 15];
		}
		for(a = 0; a < 8; a++)
		{
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(48 >> (screen_scale_x >> screen_double_x))] = Font0[(char4 << 7) + (a << 4)];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(49 >> (screen_scale_x >> screen_double_x))] = Font0[(char4 << 7) + (a << 4) + 1];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(50 >> (screen_scale_x >> screen_double_x))] = Font0[(char4 << 7) + (a << 4) + 2];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(51 >> (screen_scale_x >> screen_double_x))] = Font0[(char4 << 7) + (a << 4) + 3];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(52 >> (screen_scale_x >> screen_double_x))] = Font0[(char4 << 7) + (a << 4) + 4];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(53 >> (screen_scale_x >> screen_double_x))] = Font0[(char4 << 7) + (a << 4) + 5];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(54 >> (screen_scale_x >> screen_double_x))] = Font0[(char4 << 7) + (a << 4) + 6];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(55 >> (screen_scale_x >> screen_double_x))] = Font0[(char4 << 7) + (a << 4) + 7];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(56 >> (screen_scale_x >> screen_double_x))] = Font0[(char4 << 7) + (a << 4) + 8];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(57 >> (screen_scale_x >> screen_double_x))] = Font0[(char4 << 7) + (a << 4) + 9];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(58 >> (screen_scale_x >> screen_double_x))] = Font0[(char4 << 7) + (a << 4) + 10];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(59 >> (screen_scale_x >> screen_double_x))] = Font0[(char4 << 7) + (a << 4) + 11];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(60 >> (screen_scale_x >> screen_double_x))] = Font0[(char4 << 7) + (a << 4) + 12];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(61 >> (screen_scale_x >> screen_double_x))] = Font0[(char4 << 7) + (a << 4) + 13];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(62 >> (screen_scale_x >> screen_double_x))] = Font0[(char4 << 7) + (a << 4) + 14];
			l->line[y + (a >> (screen_scale_y >> screen_double_y))][x+(63 >> (screen_scale_x >> screen_double_x))] = Font0[(char4 << 7) + (a << 4) + 15];
		}
	}
}



#ifndef ALLEGRO_DOS
void Talk(){
	int i;
	int n;
	
	if(typing){
		if(keypressed())
			keyinput = readkey();
		clear_keybuf();
		ascii = keyinput;
		scancode = keyinput >> 8;
		
		if(scancode == KEY_ENTER){
			typing = 0;
			if(typing_pos > 0){
				message_out[typing_pos] = '\0';
				
				if(net_type){	// if connected to the network
					i = 1;
					nlWrite(prosonicnet, &i, 1);				// 0x01 = "message"
					nlWrite(prosonicnet, &net_id[0], 1);		// who sent it
					nlWrite(prosonicnet, message_out, 64);		// send message
				}
				
				for(i=0; i <= num_of_messages; i++){
					if(message_time[i] == 0){
						strcpy(&message[i * 64], message_out);
						message_out[0] = '\0';
						message_time[i] = message_time_limit;
						if(i == num_of_messages)
							message_time[0] = 0;	// make room for new message
						i = num_of_messages;
					}
				}
			}
			Game_paused ^= 1;	// this prevents the game from pausing/unpausing
		}
		else if(scancode == KEY_BACKSPACE){
			if(typing_pos > 0){
				typing_pos--;
				message_out[typing_pos] = '\0';
			}
		}
		else if(keyinput != 0 && typing_pos < 63){
			if(ascii != 0){
				message_out[typing_pos] = ascii;
				typing_pos++;
			}
		}
		keyinput = 0;
	}
	else if(key[KEY_T]){
		typing = 1;
		for(typing_pos=0; typing_pos < 64; typing_pos++)
			message_out[typing_pos] = '\0';
		typing_pos = 0;
		clear_keybuf();
	}
	
	for(i=0; i <= num_of_messages; i++){
		if(message_time[i])
			message_time[i]--;
	}
	for(i=0; i <= num_of_messages; i++){
		if(message_time[0] == 0){
			for(n=0; n < num_of_messages; n++){
				strcpy(&message[n*64], &message[(n+1)*64]);
				message_time[n] = message_time[n+1];
			}
			for(n=0; n < 64; n++)
				message[(num_of_messages * 64) + n] = '\0';
			message_time[num_of_messages] = 0;
		}
	}
	for(i=0; i < num_of_messages; i++)
		DrawText(0, 180-(i<<3), 0, &message[i*64]);
	DrawText(0, 192, 1, message_out);
}
#endif



void InputText(int x, int y, unsigned char s, const char *string, ...){
	for(buffer_count=0; buffer_count < 256; buffer_count++)
		TextBuffer[buffer_count] = '\0';
	buffer_count=0;
	keyinput = 0;
	
	clear_keybuf();
	
	while(!key[KEY_ENTER]){
		while(ticUpdated == 0);	// wait until 'ticUpdated' is 1
		ticUpdated = 0;
		clear(LayerH[frame-1]);
		DrawText(x, y, s, string);
		DrawText(x, y+8, s, &TextBuffer[0]);
		blit(LayerH[frame-1], screen, 16, 0, 0, 0, screen_buffer_x, screen_buffer_y);
		
		if(keypressed())
			keyinput = readkey();
		clear_keybuf();
		ascii = keyinput;
		scancode = keyinput >> 8;
		if(scancode == KEY_ENTER)
			TextBuffer[buffer_count] = '\0';
		else if(scancode == KEY_BACKSPACE){
			if(buffer_count > 0){
				buffer_count--;
				TextBuffer[buffer_count] = '\0';
			}
		}
		else if(buffer_count < 255 && keyinput != 0){
			#ifdef ALLEGRO_WINDOWS
			if(ascii != 0
			 && ascii != '/'
			 && ascii != '*'
			 && ascii != '?'
			 && ascii != '<'
			 && ascii != '>'
			 && ascii != '!'){
				TextBuffer[buffer_count] = ascii;
				buffer_count++;
			}
			#else
			if(ascii != 0
			 && ascii != '\\'
			 && ascii != '*'
			 && ascii != '?'
			 && ascii != '<'
			 && ascii != '>'
			 && ascii != '!'){
				TextBuffer[buffer_count] = ascii;
				buffer_count++;
			}
			#endif
		}
		keyinput = 0;
	}
	key[KEY_ENTER] = 0;
	buffer_count=0;
	Game_paused = 0;
}



void DrawText(int x, int y, unsigned char s, const char *string, ...){
	unsigned char			tpos;
	
	if(!draw_frame)
		return;
	
	s <<= 7;

	for(tpos = 0; string[tpos] != '\0'; tpos++)
		DrawSprite(&z, LayerH[frame-1], 0x104, (string[tpos]-0x2A)+s, NORMAL, 0, x + (tpos << 3) + 16, y);
}
