#include	<stdio.h>							// Standard input/output
#include	<allegro.h>							// Allegro game library

#include	"error.h"
//#include	"draw.h"
//#include	"text.h"
#include	"m68k.h"
#include	"obj01.h"
#include	"objects.h"
#include	"sprites.h"
#include	"script.h"

void procode_process_number(long *store_type, long *store_value, long *store_size, char size){
	// purposely excluded "inline" for this function
	*store_type = obj_script[script_pos];
	script_pos++;
	if(*store_type == 0){		// immediate
		switch(size){
			case 1:
				*store_value = *(char *)(&obj_script[script_pos]);
				break;
			case 2:
				*store_value = *(short *)(&obj_script[script_pos]);
				break;
			case 4:
				*store_value = *(int *)(&obj_script[script_pos]);
				break;
		}
		*store_size = 0;
		script_pos += size;
	}
	else{				// variable
		i = *(short *)(&obj_script[script_pos]);
		script_pos += 2;
		if(i >= 0x800){	// GVAR
			i -= 0x800;
			*store_value = (int)internal_gvar_ptrs[i];
			*store_size = internal_gvar_size[i];
		}
		else if(i >= 0x100){	// OVAR
			i -= 0x100;
			*store_value = (int)internal_ovar_ptrs[i];
			*store_size = internal_ovar_size[i];
		}
		else{			// PVAR
			*store_value = (int)internal_pvar_ptrs[frame-1][i];
			*store_size = internal_pvar_size[i];
		}
	}
}







inline void procode_set(char size1, long dest, char op, char size2, long src){
	switch(op){
		case 0:		// ~
			switch(size1){
				case 4:
					*(int *)dest ^= 0xFFFFFFFF;
					break;
				case 2:
					*(short *)dest ^= 0xFFFF;
					break;
				case 1:
					*(char *)dest ^= 0xFF;
			}
			break;
		case 1:		// ++
			switch(size1){
				case 4:
					(*(int *)dest)++;
					break;
				case 2:
					(*(short *)dest)++;
					break;
				case 1:
					(*(char *)dest)++;
					break;
			}
			break;
		case 2:		// --
			switch(size1){
				case 4:
					(*(int *)dest)--;
					break;
				case 2:
					(*(short *)dest)--;
					break;
				case 1:
					(*(char *)dest)--;
					break;
			}
			break;
		case 3:		// =
			switch(size1){
				case 4:
					switch(size2){
						case 4:
							*(int *)dest = *(int *)src;
							break;
						case 2:
							*(int *)dest = *(short *)src;
							break;
						case 1:
							*(int *)dest = *(char *)src;
							break;
						case 0:
							*(int *)dest = src;
							break;
					}
					break;
				case 2:
					switch(size2){
						case 4:
						case 2:
							*(short *)dest = *(short *)src;
							break;
						case 1:
							*(short *)dest = *(char *)src;
							break;
						case 0:
							*(short *)dest = src;
							break;
					}
					break;
				case 1:
					switch(size2){
						case 4:
						case 2:
						case 1:
							*(char *)dest = *(char *)src;
							break;
						case 0:
							*(char *)dest = src;
							break;
					}
					break;
			}
			break;
		case 4:		// +
			switch(size1){
				case 4:
					switch(size2){
						case 4:
							*(int *)dest += *(int *)src;
							break;
						case 2:
							*(int *)dest += *(short *)src;
							break;
						case 1:
							*(int *)dest += *(char *)src;
							break;
						case 0:
							*(int *)dest += src;
							break;
					}
					break;
				case 2:
					switch(size2){
						case 4:
						case 2:
							*(short *)dest += *(short *)src;
							break;
						case 1:
							*(short *)dest += *(char *)src;
							break;
						case 0:
							*(short *)dest += src;
							break;
					}
					break;
				case 1:
					switch(size2){
						case 4:
						case 2:
						case 1:
							*(char *)dest += *(char *)src;
							break;
						case 0:
							*(char *)dest += src;
							break;
					}
					break;
			}
			break;
		case 5:		// -
			switch(size1){
				case 4:
					switch(size2){
						case 4:
							*(int *)dest -= *(int *)src;
							break;
						case 2:
							*(int *)dest -= *(short *)src;
							break;
						case 1:
							*(int *)dest -= *(char *)src;
							break;
						case 0:
							*(int *)dest -= src;
							break;
					}
					break;
				case 2:
					switch(size2){
						case 4:
						case 2:
							*(short *)dest -= *(short *)src;
							break;
						case 1:
							*(short *)dest -= *(char *)src;
							break;
						case 0:
							*(short *)dest -= src;
							break;
					}
					break;
				case 1:
					switch(size2){
						case 4:
						case 2:
						case 1:
							*(char *)dest -= *(char *)src;
							break;
						case 0:
							*(char *)dest -= src;
							break;
					}
					break;
			}
			break;
		case 6:		// *
			switch(size1){
				case 4:
					switch(size2){
						case 4:
							*(int *)dest *= *(int *)src;
							break;
						case 2:
							*(int *)dest *= *(short *)src;
							break;
						case 1:
							*(int *)dest *= *(char *)src;
							break;
						case 0:
							*(int *)dest *= src;
							break;
					}
					break;
				case 2:
					switch(size2){
						case 4:
						case 2:
							*(short *)dest *= *(short *)src;
							break;
						case 1:
							*(short *)dest *= *(char *)src;
							break;
						case 0:
							*(short *)dest *= src;
							break;
					}
					break;
				case 1:
					switch(size2){
						case 4:
						case 2:
						case 1:
							*(char *)dest *= *(char *)src;
							break;
						case 0:
							*(char *)dest *= src;
							break;
					}
					break;
			}
			break;
		case 7:		// /
			switch(size1){
				case 4:
					switch(size2){
						case 4:
							*(int *)dest /= *(int *)src;
							break;
						case 2:
							*(int *)dest /= *(short *)src;
							break;
						case 1:
							*(int *)dest /= *(char *)src;
							break;
						case 0:
							*(int *)dest /= src;
							break;
					}
					break;
				case 2:
					switch(size2){
						case 4:
						case 2:
							*(short *)dest /= *(short *)src;
							break;
						case 1:
							*(short *)dest /= *(char *)src;
							break;
						case 0:
							*(short *)dest /= src;
							break;
					}
					break;
				case 1:
					switch(size2){
						case 4:
						case 2:
						case 1:
							*(char *)dest /= *(char *)src;
							break;
						case 0:
							*(char *)dest /= src;
							break;
					}
					break;
			}
			break;
		case 8:		// %
			switch(size1){
				case 4:
					switch(size2){
						case 4:
							*(int *)dest %= *(int *)src;
							break;
						case 2:
							*(int *)dest %= *(short *)src;
							break;
						case 1:
							*(int *)dest %= *(char *)src;
							break;
						case 0:
							*(int *)dest %= src;
							break;
					}
					break;
				case 2:
					switch(size2){
						case 4:
						case 2:
							*(short *)dest %= *(short *)src;
							break;
						case 1:
							*(short *)dest %= *(char *)src;
							break;
						case 0:
							*(short *)dest %= src;
							break;
					}
					break;
				case 1:
					switch(size2){
						case 4:
						case 2:
						case 1:
							*(char *)dest %= *(char *)src;
							break;
						case 0:
							*(char *)dest %= src;
							break;
					}
					break;
			}
			break;
		case 9:		// <<
			switch(size1){
				case 4:
					switch(size2){
						case 4:
							*(int *)dest <<= *(int *)src;
							break;
						case 2:
							*(int *)dest <<= *(short *)src;
							break;
						case 1:
							*(int *)dest <<= *(char *)src;
							break;
						case 0:
							*(int *)dest <<= src;
							break;
					}
					break;
				case 2:
					switch(size2){
						case 4:
						case 2:
							*(short *)dest <<= *(short *)src;
							break;
						case 1:
							*(short *)dest <<= *(char *)src;
							break;
						case 0:
							*(short *)dest <<= src;
							break;
					}
					break;
				case 1:
					switch(size2){
						case 4:
						case 2:
						case 1:
							*(char *)dest <<= *(char *)src;
							break;
						case 0:
							*(char *)dest <<= src;
							break;
					}
					break;
			}
			break;
		case 10:	// >>
			switch(size1){
				case 4:
					switch(size2){
						case 4:
							*(int *)dest >>= *(int *)src;
							break;
						case 2:
							*(int *)dest >>= *(short *)src;
							break;
						case 1:
							*(int *)dest >>= *(char *)src;
							break;
						case 0:
							*(int *)dest >>= src;
							break;
					}
					break;
				case 2:
					switch(size2){
						case 4:
						case 2:
							*(short *)dest >>= *(short *)src;
							break;
						case 1:
							*(short *)dest >>= *(char *)src;
							break;
						case 0:
							*(short *)dest >>= src;
							break;
					}
					break;
				case 1:
					switch(size2){
						case 4:
						case 2:
						case 1:
							*(char *)dest >>= *(char *)src;
							break;
						case 0:
							*(char *)dest >>= src;
							break;
					}
					break;
			}
			break;
		case 11:	// &
			switch(size1){
				case 4:
					switch(size2){
						case 4:
							*(int *)dest &= *(int *)src;
							break;
						case 2:
							*(int *)dest &= *(short *)src;
							break;
						case 1:
							*(int *)dest &= *(char *)src;
							break;
						case 0:
							*(int *)dest &= src;
							break;
					}
					break;
				case 2:
					switch(size2){
						case 4:
						case 2:
							*(short *)dest &= *(short *)src;
							break;
						case 1:
							*(short *)dest &= *(char *)src;
							break;
						case 0:
							*(short *)dest &= src;
							break;
					}
					break;
				case 1:
					switch(size2){
						case 4:
						case 2:
						case 1:
							*(char *)dest &= *(char *)src;
							break;
						case 0:
							*(char *)dest &= src;
							break;
					}
					break;
			}
			break;
		case 12:	// |
			switch(size1){
				case 4:
					switch(size2){
						case 4:
							*(int *)dest |= *(int *)src;
							break;
						case 2:
							*(int *)dest |= *(short *)src;
							break;
						case 1:
							*(int *)dest |= *(char *)src;
							break;
						case 0:
							*(int *)dest |= src;
							break;
					}
					break;
				case 2:
					switch(size2){
						case 4:
						case 2:
							*(short *)dest |= *(short *)src;
							break;
						case 1:
							*(short *)dest |= *(char *)src;
							break;
						case 0:
							*(short *)dest |= src;
							break;
					}
					break;
				case 1:
					switch(size2){
						case 4:
						case 2:
						case 1:
							*(char *)dest |= *(char *)src;
							break;
						case 0:
							*(char *)dest |= src;
							break;
					}
					break;
			}
			break;
		case 13:	// ^
			switch(size1){
				case 4:
					switch(size2){
						case 4:
							*(int *)dest ^= *(int *)src;
							break;
						case 2:
							*(int *)dest ^= *(short *)src;
							break;
						case 1:
							*(int *)dest ^= *(char *)src;
							break;
						case 0:
							*(int *)dest ^= src;
							break;
					}
					break;
				case 2:
					switch(size2){
						case 4:
						case 2:
							*(short *)dest ^= *(short *)src;
							break;
						case 1:
							*(short *)dest ^= *(char *)src;
							break;
						case 0:
							*(short *)dest ^= src;
							break;
					}
					break;
				case 1:
					switch(size2){
						case 4:
						case 2:
						case 1:
							*(char *)dest ^= *(char *)src;
							break;
						case 0:
							*(char *)dest ^= src;
							break;
					}
					break;
			}
			break;
	}
}







char procode_if(char size1, long dest, char op, char size2, long src){
	// purposely excluded "inline" for this function	
	char r;
	
	switch(op){
		case 0:		// ==
			switch(size1){
				case 4:
					switch(size2){
						case 4:
							r = (*(int *)dest == *(int *)src);
							break;
						case 2:
							r = (*(int *)dest == *(short *)src);
							break;
						case 1:
							r = (*(int *)dest == *(char *)src);
							break;
						case 0:
							r = (*(int *)dest == src);
							break;
					}
					break;
				case 2:
					switch(size2){
						case 4:
						case 2:
							r = (*(short *)dest == *(short *)src);
							break;
						case 1:
							r = (*(short *)dest == *(char *)src);
							break;
						case 0:
							r = (*(short *)dest == src);
							break;
					}
					break;
				case 1:
					switch(size2){
						case 4:
						case 2:
						case 1:
							r = (*(char *)dest == *(char *)src);
							break;
						case 0:
							r = (*(char *)dest == src);
							break;
					}
					break;
				case 0:
					switch(size2){
						case 4:
							r = (dest == *(int *)src);
							break;
						case 2:
							r = (dest == *(short *)src);
							break;
						case 1:
							r = (dest == *(char *)src);
							break;
						case 0:
							r = (dest == src);
							break;
					}
					break;
			}
			break;
		case 1:		// >
			switch(size1){
				case 4:
					switch(size2){
						case 4:
							r = (*(int *)dest > *(int *)src);
							break;
						case 2:
							r = (*(int *)dest > *(short *)src);
							break;
						case 1:
							r = (*(int *)dest > *(char *)src);
							break;
						case 0:
							r = (*(int *)dest > src);
							break;
					}
					break;
				case 2:
					switch(size2){
						case 4:
						case 2:
							r = (*(short *)dest > *(short *)src);
							break;
						case 1:
							r = (*(short *)dest > *(char *)src);
							break;
						case 0:
							r = (*(short *)dest > src);
							break;
					}
					break;
				case 1:
					switch(size2){
						case 4:
						case 2:
						case 1:
							r = (*(char *)dest > *(char *)src);
							break;
						case 0:
							r = (*(char *)dest > src);
							break;
					}
					break;
				case 0:
					switch(size2){
						case 4:
							r = (dest > *(int *)src);
							break;
						case 2:
							r = (dest > *(short *)src);
							break;
						case 1:
							r = (dest > *(char *)src);
							break;
						case 0:
							r = (dest > src);
							break;
					}
					break;
			}
			break;
		case 2:		// <
			switch(size1){
				case 4:
					switch(size2){
						case 4:
							r = (*(int *)dest < *(int *)src);
							break;
						case 2:
							r = (*(int *)dest < *(short *)src);
							break;
						case 1:
							r = (*(int *)dest < *(char *)src);
							break;
						case 0:
							r = (*(int *)dest < src);
							break;
					}
					break;
				case 2:
					switch(size2){
						case 4:
						case 2:
							r = (*(short *)dest < *(short *)src);
							break;
						case 1:
							r = (*(short *)dest < *(char *)src);
							break;
						case 0:
							r = (*(short *)dest < src);
							break;
					}
					break;
				case 1:
					switch(size2){
						case 4:
						case 2:
						case 1:
							r = (*(char *)dest < *(char *)src);
							break;
						case 0:
							r = (*(char *)dest < src);
							break;
					}
					break;
				case 0:
					switch(size2){
						case 4:
							r = (dest < *(int *)src);
							break;
						case 2:
							r = (dest < *(short *)src);
							break;
						case 1:
							r = (dest < *(char *)src);
							break;
						case 0:
							r = (dest < src);
							break;
					}
					break;
			}
			break;
		case 3:		// >=
			switch(size1){
				case 4:
					switch(size2){
						case 4:
							r = (*(int *)dest >= *(int *)src);
							break;
						case 2:
							r = (*(int *)dest >= *(short *)src);
							break;
						case 1:
							r = (*(int *)dest >= *(char *)src);
							break;
						case 0:
							r = (*(int *)dest >= src);
							break;
					}
					break;
				case 2:
					switch(size2){
						case 4:
						case 2:
							r = (*(short *)dest >= *(short *)src);
							break;
						case 1:
							r = (*(short *)dest >= *(char *)src);
							break;
						case 0:
							r = (*(short *)dest >= src);
							break;
					}
					break;
				case 1:
					switch(size2){
						case 4:
						case 2:
						case 1:
							r = (*(char *)dest >= *(char *)src);
							break;
						case 0:
							r = (*(char *)dest >= src);
							break;
					}
					break;
				case 0:
					switch(size2){
						case 4:
							r = (dest >= *(int *)src);
							break;
						case 2:
							r = (dest >= *(short *)src);
							break;
						case 1:
							r = (dest >= *(char *)src);
							break;
						case 0:
							r = (dest >= src);
							break;
					}
					break;
			}
			break;
		case 4:		// <=
			switch(size1){
				case 4:
					switch(size2){
						case 4:
							r = (*(int *)dest <= *(int *)src);
							break;
						case 2:
							r = (*(int *)dest <= *(short *)src);
							break;
						case 1:
							r = (*(int *)dest <= *(char *)src);
							break;
						case 0:
							r = (*(int *)dest <= src);
							break;
					}
					break;
				case 2:
					switch(size2){
						case 4:
						case 2:
							r = (*(short *)dest <= *(short *)src);
							break;
						case 1:
							r = (*(short *)dest <= *(char *)src);
							break;
						case 0:
							r = (*(short *)dest <= src);
							break;
					}
					break;
				case 1:
					switch(size2){
						case 4:
						case 2:
						case 1:
							r = (*(char *)dest <= *(char *)src);
							break;
						case 0:
							r = (*(char *)dest <= src);
							break;
					}
					break;
				case 0:
					switch(size2){
						case 4:
							r = (dest <= *(int *)src);
							break;
						case 2:
							r = (dest <= *(short *)src);
							break;
						case 1:
							r = (dest <= *(char *)src);
							break;
						case 0:
							r = (dest <= src);
							break;
					}
					break;
			}
			break;
		case 5:		// !=
			switch(size1){
				case 4:
					switch(size2){
						case 4:
							r = (*(int *)dest != *(int *)src);
							break;
						case 2:
							r = (*(int *)dest != *(short *)src);
							break;
						case 1:
							r = (*(int *)dest != *(char *)src);
							break;
						case 0:
							r = (*(int *)dest != src);
							break;
					}
					break;
				case 2:
					switch(size2){
						case 4:
						case 2:
							r = (*(short *)dest != *(short *)src);
							break;
						case 1:
							r = (*(short *)dest != *(char *)src);
							break;
						case 0:
							r = (*(short *)dest != src);
							break;
					}
					break;
				case 1:
					switch(size2){
						case 4:
						case 2:
						case 1:
							r = (*(char *)dest != *(char *)src);
							break;
						case 0:
							r = (*(char *)dest != src);
							break;
					}
					break;
				case 0:
					switch(size2){
						case 4:
							r = (dest != *(int *)src);
							break;
						case 2:
							r = (dest != *(short *)src);
							break;
						case 1:
							r = (dest != *(char *)src);
							break;
						case 0:
							r = (dest != src);
							break;
					}
					break;
			}
			break;
	}
	
	return r;
}







inline void procode_playfm(char size1, long src, char size2, long dest, char size3, long op){
	short number;
	char buffer;
	char mix;
	
	switch(size1){
		case 4:
		case 2:
			number = *(short *)src;
			break;
		case 1:
			number = *(char *)src;
			break;
		case 0:
			number = src;
	}
	switch(size2){
		case 4:
		case 2:
		case 1:
			buffer = *(char *)dest;
			break;
		case 0:
			buffer = dest;
	}
	switch(size3){
		case 4:
		case 2:
		case 1:
			mix = *(char *)op;
			break;
		case 0:
			mix = op;
	}
	PlayFM(number, buffer, mix);
}

inline void procode_playpcm(char size1, long src, char size2, long dest, char size3, long op){
	short number;
	char buffer;
	char mix;
	
	switch(size1){
		case 4:
		case 2:
			number = *(short *)src;
			break;
		case 1:
			number = *(char *)src;
			break;
		case 0:
			number = src;
	}
	switch(size2){
		case 4:
		case 2:
		case 1:
			buffer = *(char *)dest;
			break;
		case 0:
			buffer = dest;
	}
	switch(size3){
		case 4:
		case 2:
		case 1:
			mix = *(char *)op;
			break;
		case 0:
			mix = op;
	}
	
	PlayPCM(number, buffer, mix);
}







inline void procode_textout(char size1, long num1, char size2, long num2, char size3, long num3, const char *string, ...){
	short x;
	short y;
	char color;
	
	switch(size1){
		case 4:
		case 2:
			x = *(short *)num1;
			break;
		case 1:
			x = *(char *)num1;
			break;
		case 0:
			x = num1;
	}
	switch(size2){
		case 4:
		case 2:
			y = *(short *)num2;
			break;
		case 1:
			y = *(char *)num2;
			break;
		case 0:
			y = num2;
	}
	switch(size3){
		case 4:
		case 2:
		case 1:
			color = *(char *)num3;
			break;
		case 0:
			color = num3;
	}
	
	DrawText(x, y, color, string);
}







inline void procode_drawsprite(unsigned short NodeNumber, char size1, long num1,
						char size2, long num2, char size3, long num3,
						char size4, long num4, char size5, long num5){
	char layer;
	char flags;
	char trans;
	short x;
	short y;
	
	OBJECT *o = &objObject[NodeNumber];
	
	switch(size1){
		case 4:
		case 2:
		case 1:
			layer = *(char *)num1;
			break;
		case 0:
			layer = num1;
	}
	switch(size2){
		case 4:
		case 2:
		case 1:
			flags = *(char *)num2;
			break;
		case 0:
			flags = num2;
	}
	switch(size3){
		case 4:
		case 2:
		case 1:
			trans = *(char *)num3;
			break;
		case 0:
			trans = num3;
	}
	switch(size4){
		case 4:
		case 2:
			x = *(short *)num4;
			break;
		case 1:
			x = *(char *)num4;
			break;
		case 0:
			x = num4;
	}
	switch(size5){
		case 4:
		case 2:
			y = *(short *)num5;
			break;
		case 1:
			y = *(char *)num5;
			break;
		case 0:
			y = num5;
	}
	
	switch(layer){
		case 0:
			DrawSprite(&z, LayerSH[frame-1], o->type, o->anim_frame, flags, trans, x+16, y);
			break;
		case 1:
			DrawSprite(&z, LayerH[frame-1], o->type, o->anim_frame, flags, trans, x+16, y);
			break;
		case 2:
			DrawSprite(&z, LayerL[frame-1], o->type, o->anim_frame, flags, trans, x+16, y);
			break;
		case 3:
			DrawSprite(&z, LayerB[frame-1], o->type, o->anim_frame, flags, trans, x+16, y);
			break;
	}
}



inline void procode_animate(unsigned short NodeNumber, char size1, long num1,
					char size2, long num2, char size3, long num3,
					char size4, long num4, char size5, long num5){
	char layer;
	char flags;
	char trans;
	short x;
	short y;
	
	unsigned char speed;
	
	OBJECT *o = &objObject[NodeNumber];
	
	switch(size1){
		case 4:
		case 2:
		case 1:
			layer = *(char *)num1;
			break;
		case 0:
			layer = num1;
	}
	switch(size2){
		case 4:
		case 2:
		case 1:
			flags = *(char *)num2;
			break;
		case 0:
			flags = num2;
	}
	switch(size3){
		case 4:
		case 2:
		case 1:
			trans = *(char *)num3;
			break;
		case 0:
			trans = num3;
	}
	switch(size4){
		case 4:
		case 2:
			x = *(short *)num4;
			break;
		case 1:
			x = *(char *)num4;
			break;
		case 0:
			x = num4;
	}
	switch(size5){
		case 4:
		case 2:
			y = *(short *)num5;
			break;
		case 1:
			y = *(char *)num5;
			break;
		case 0:
			y = num5;
	}
	
	speed = GetAnimationSpeed(o->type, (unsigned char *)&o->anim);
	ReadAnimation(o->type, (unsigned char *)&o->anim, (unsigned short *)&o->anim_frame, &o->anim_frame_duration, &speed);
	
	switch(layer){
		case 0:
			DrawAnimation(&z, LayerSH[frame-1], o->type, o->anim, o->anim_frame, flags, trans, &o->anim_frame_duration, speed, x+16, y);
			break;
		case 1:
			DrawAnimation(&z, LayerH[frame-1], o->type, o->anim, o->anim_frame, flags, trans, &o->anim_frame_duration, speed, x+16, y);
			break;
		case 2:
			DrawAnimation(&z, LayerL[frame-1], o->type, o->anim, o->anim_frame, flags, trans, &o->anim_frame_duration, speed, x+16, y);
			break;
		case 3:
			DrawAnimation(&z, LayerB[frame-1], o->type, o->anim, o->anim_frame, flags, trans, &o->anim_frame_duration, speed, x+16, y);
			break;
	}
}



inline void procode_counterout(char size1, long num1, char size2, long num2,
						char size3, long num3, char size4, long num4,
						char size5, long num5){
	char type;
	char fill;
	int number;
	short x;
	short y;
	
	switch(size1){
		case 4:
		case 2:
		case 1:
			type = *(char *)num1;
			break;
		case 0:
			type = num1;
	}
	switch(size2){
		case 4:
		case 2:
		case 1:
			fill = *(char *)num2;
			break;
		case 0:
			fill = num2;
	}
	switch(size3){
		case 4:
			number = *(int *)num3;
			break;
		case 2:
			number = *(short *)num3;
			break;
		case 1:
			number = *(char *)num3;
			break;
		case 0:
			number = num3;
	}
	switch(size4){
		case 4:
		case 2:
			x = *(short *)num4;
			break;
		case 1:
			x = *(char *)num4;
			break;
		case 0:
			x = num4;
	}
	switch(size5){
		case 4:
		case 2:
			y = *(short *)num5;
			break;
		case 1:
			y = *(char *)num5;
			break;
		case 0:
			y = num5;
	}
	
	switch(type){
		case 0:
		case 1:
			DrawCounter10(LayerSH[frame-1], number, x, y, fill, type);
			break;
		case 2:
			DrawCounter16(LayerSH[frame-1], number, x, y);
			break;
	}
}



inline void procode_fadeoutfm(char size1, long num1){
	char buffer;
	
	switch(size1){
		case 4:
		case 2:
		case 1:
			buffer = *(char *)num1;
			break;
		case 0:
			buffer = num1;
	}
	
	FadeOutFM(buffer);
}



inline void procode_move(unsigned short NodeNumber){
	OBJECT *o = &objObject[NodeNumber];
	
	int x_pos = (o->x_pos << 16) | (unsigned short)(o->x_pos_pre);
	int y_pos = (o->y_pos << 16) | (unsigned short)(o->y_pos_pre);
	
	x_pos += (o->x_vel << 8);
	y_pos += (o->y_vel << 8);
	
	o->x_pos = x_pos >> 16;
	o->x_pos_pre = x_pos;
	o->y_pos = y_pos >> 16;
	o->y_pos_pre = y_pos;
}



inline void procode_spawn(char size1, long num1, char size2, long num2,
					char size3, long num3, char size4, long num4,
					char size5, long num5, char size6, long num6){
	char type;
	char subtype;
	char htag;
	char ltag;
	short x;
	short y;
	
	switch(size1){
		case 4:
		case 2:
		case 1:
			type = *(char *)num1;
			break;
		case 0:
			type = num1;
	}
	switch(size2){
		case 4:
		case 2:
		case 1:
			subtype = *(char *)num2;
			break;
		case 0:
			subtype = num2;
	}
	switch(size3){
		case 4:
		case 2:
		case 1:
			htag = *(char *)num3;
			break;
		case 0:
			htag = num3;
	}
	switch(size4){
		case 4:
		case 2:
		case 1:
			ltag = *(char *)num4;
			break;
		case 0:
			ltag = num4;
	}
	switch(size5){
		case 4:
		case 2:
			x = *(short *)num5;
			break;
		case 1:
			x = *(char *)num5;
			break;
		case 0:
			x = num5;
	}
	switch(size6){
		case 4:
		case 2:
			y = *(short *)num6;
			break;
		case 1:
			y = *(char *)num6;
			break;
		case 0:
			y = num6;
	}
	
	CreateObject(type, subtype, htag, ltag, x, y);
}



inline void procode_rest(char size1, long num1){
	short ms;
	
	switch(size1){
		case 4:
		case 2:
			ms = *(short *)num1;
			break;
		case 1:
			ms = *(char *)num1;
			break;
		case 0:
			ms = num1;
	}
	
	rest(ms);
}



inline void procode_setgfxmode(char size1, long num1, char size2, long num2,
						char size3, long num3, char size4, long num4,
						char size5, long num5, char size6, long num6,
						char size7, long num7){
	unsigned short res_x, res_y;
	unsigned short pad_x, pad_y;
	unsigned short dbl_x, dbl_y;
	unsigned char full;
	
	switch(size1){
		case 4:
		case 2:
			res_x = *(short *)num1;
			break;
		case 1:
			res_x = *(char *)num1;
			break;
		case 0:
			res_x = num1;
	}
	switch(size2){
		case 4:
		case 2:
			res_y = *(short *)num2;
			break;
		case 1:
			res_y = *(char *)num2;
			break;
		case 0:
			res_y = num2;
	}
	switch(size3){
		case 4:
		case 2:
			pad_x = *(short *)num3;
			break;
		case 1:
			pad_x = *(char *)num3;
			break;
		case 0:
			pad_x = num3;
	}
	switch(size4){
		case 4:
		case 2:
			pad_y = *(short *)num4;
			break;
		case 1:
			pad_y = *(char *)num4;
			break;
		case 0:
			pad_y = num4;
	}
	switch(size5){
		case 4:
		case 2:
			dbl_x = *(short *)num5;
			break;
		case 1:
			dbl_x = *(char *)num5;
			break;
		case 0:
			dbl_x = num5;
	}
	switch(size6){
		case 4:
		case 2:
			dbl_y = *(short *)num6;
			break;
		case 1:
			dbl_y = *(char *)num6;
			break;
		case 0:
			dbl_y = num6;
	}
	switch(size7){
		case 4:
		case 2:
		case 1:
			full = *(char *)num7;
			break;
		case 0:
			full = num7;
	}
	
	SetGfxMode(res_x, res_y, pad_x, pad_y, dbl_x, dbl_y, full);
}



inline void procode_startzone(char size1, long num1, char size2, long num2,
					char size3, long num3){
	char z;
	char a;
	char s;
	
	switch(size1){
		case 4:
		case 2:
		case 1:
			z = *(char *)num1;
			break;
		case 0:
			z = num1;
	}
	switch(size2){
		case 4:
		case 2:
		case 1:
			a = *(char *)num2;
			break;
		case 0:
			a = num2;
	}
	switch(size3){
		case 4:
		case 2:
		case 1:
			s = *(char *)num3;
			break;
		case 0:
			s = num3;
	}
	
	zone = z;
	act = a;
	stage = s;
	Level_Inactive_flag = 1;
}
