/*****************************************************************************
 *	      ______
 *	    /   _   \   _   __    ______
 *	   /  /_ /  / /  //__ / /   _   \
 *	  /   ____ / /   /     /  /  /  /
 *	 /  /       /  /      /  /_ /  /
 *	/_ /       /_ /       \ _____ /
 *	           ______
 *	         /  ____ /  ______     _   __     _    ______
 *	        /  /___   /   _   \  /  //_  \  /_ / /   _   \
 *	       _\___   \ /  /  /  / /   / /  / /  / /  /  /_ /
 *	     /  /_ /  / /  /_ /  / /  /  /  / /  / /  /____ 
 *	     \______ /  \ _____ / /_ /  /_ / /_ /  \ ______/
 *	
 *	
 *	ProSonic Engine
 *	Created by Damian Grove
 *	
 *	Compiled with DJGPP - GCC 2.952 (DOS) / Dev-C++ 4.9.9.2 (Windows)
 *	Libraries used:
 *		- Allegro - 3.9.34		http://www.talula.demon.co.uk/allegro/
 *		- DUMB - 0.9.3			http://dumb.sourceforge.net/
 *		- AllegroOgg - 1.0.3	http://nekros.freeshell.org/delirium/
 *
 ******************************************************************************
 *
 *	NAME:	ProSonic - Objects functionality header
 *
 *	FILE:	objects.h
 *	
 *	DESCRIPTION:
 *		This file is for anything related specifically to objects and how they
 *	are handled.
 *	
 *****************************************************************************/



#ifndef OBJECTS_H
	#define OBJECTS_H
	
	//#include	"zone.h"
	#include	"structs.h"
	#include	"common.h"
	
	#ifdef __cplusplus
	extern "C"{
	#endif
	
	
	
	#define		MAX_LEVEL_OBJECTS		2048	// More than you'll ever need (MUST BE A POWER OF 2!)
	#define		MAX_BUFFER_OBJECTS		128		// If you exceed this, you need to work on your levels
	#define		OBJECT_BUFFER_SCOPE		0x60	// Limit buffer to 0x60 X distance outside screen
	
	void 		fncProcode(unsigned short);
	void		fncM68K(ZONE *z, unsigned short);
	inline void		fncRing(ZONE *z, unsigned short);
	inline void		fncSideSwapper(ZONE *z, unsigned short);
	
	inline void		ManageObjectNodes(ZONE *z);
	inline void		PollObject(unsigned short);
	void		PollObjectFrame(unsigned short);
	void		CreateObject(char, char, char, char, short, short);
	void		DestroyObject(unsigned short);
	
	void		AllocateObjects(ZONE *z);
	
	unsigned short	ObjectCount;							// Important for managing object nodes (1024)
	unsigned short	BufferObjectCount;						// For statistical analysis (128)
	unsigned short	ObjectNodes[MAX_BUFFER_OBJECTS];		// Each node is 16-bits, and 128 objects allowed
	unsigned char	ObjectStates[MAX_LEVEL_OBJECTS];		// Save certain data from objects, regardless of scope
	unsigned char	ObjectScopePoll[MAX_BUFFER_OBJECTS];	// Polls to see how many players are within range
	OBJECT_PLOT		*Objects;								// ZxxOBJ.DAT - Object layout (1023 supported)
	OBJECT			objObject[MAX_BUFFER_OBJECTS];
	
	#ifdef __cplusplus
	}
	#endif
#endif
