#define BYTE	1
#define WORD	2
#define LONG	4

//#define MOTOROLA_STACK_SIZE		32	// measured in long words

// ====================================================
// REPLACE THESE EVENTUALLY WITH REG_A AND REG_D ARRAYS
// ====================================================
// Motorola 68000 address registers
volatile int a0, a1, a2, a3, a4, a5, a6, a7;
// Motorola 68000 data registers
volatile int d0, d1, d2, d3, d4, d5, d6, d7;
// ====================================================

// Address and data registers
unsigned int reg_a[8];
unsigned int reg_d[8];
unsigned int imm;

unsigned int ea;

enum script_type{
	NEW,
	MOTOROLA
};

unsigned char ram_68k[0x10000];
//int stack_68k[MOTOROLA_STACK_SIZE];

int swap_endian(char s, unsigned int v);
int calc_effective_address(char size, char mode, char r);
int read_script(char size, char type);

//volatile char increment;

// Misc registers
int pc;
short sr;	// lower byte is CCR register
char cc_x;
char cc_n;
char cc_z;
char cc_v;
char cc_c;
//char ccr;

#define CCR_C	0x01
#define CCR_V	0x02
#define CCR_Z	0x04
#define CCR_N	0x08
#define CCR_X	0x10

// Motorola 68000 flags
//char flag_c;
//char flag_z;

void op_add(short data);
void op_addi(short data);
void op_addq(short data);
void op_and(short data);
void op_andi(short data);
void op_bcc(short data);
void op_bchg(short data);
void op_bclr(short data);
void op_bset(short data);
void op_btst(short data);
void op_clr(short data);
void op_cmp(short data);
void op_cmpi(short data);
void op_eor(short data);
void op_eori(short data);
void op_jmp(short data);
void op_lea(short data);
void op_lsd(short data);
void op_move(short data);
void op_movem(short data);
void op_moveq(short data);
void op_neg(short data);
