/*****************************************************************************
	SONIC PZF LIBRARY
	Copyright(c) Damian Grove, 2006
	
	"zone.h"
	
	------------------------------------------------------------------------
	
	The ProSonic hierarchy works like this:
		
	ZONE (e.g. Palmtree Panic Zone)
	\
	 \__
		ACT (e.g. Act 1)
		\
	     \__
			STAGE (e.g. Present)
	
	MAXIMUM NUMBER OF ZONES		256
	MAXIMUM NUMBER OF ACTS		8
	MAXIMUM NUMBER OF STAGES	4
	
	------------------------------------------------------------------------
	
	The PZF format is designed to support 256 zones so game designers will
	never run out of room to add levels to their games.
	
	Although 8 acts seems high, it was picked over a 4 act limit since
	Knuckles' Chaotix makes use of 5. To ensure better compatibility, the 4
	act limit was dropped in favor of the 8 act limit.
	
	Stages are different in that the game designer doesn't actually tell
	ProSonic how many there are. Instead there are a total of 4 stage 'slots'
	that allow the player to choose which slots to use. The 4 slots are A, B,
	C, and D. This was done to ensure better compatibility with Sonic CD.
	Since the third act of every zone in Sonic CD only has 2 future stages
	(which are C and D), it would only make sense to allow ProSonic to do the
	same thing.
	
	------------------------------------------------------------------------
	
	FILE DATA FORMAT:
	All sizes and addresses are stored in little-endian format.
	
	z->TYPE_FileCount = 1;
	z->TYPE
	[
		INT_0	Address to file 0 (from TYPE[0])
		INT_1	Size of file 0 (in bytes)
		FILE_0[INT_1]
	]
	
	z->TYPE_FileCount = 2;
	z->TYPE
	[
		INT_0	Address to file 0 (from TYPE[0])
		INT_1	Address to file 1 (from TYPE[0])
		INT_2	Size of file 0 (in bytes)
		INT_3	Size of file 1 (in bytes)
		FILE_0[INT_2]
		FILE_1[INT_3]
	]
	
	z->TYPE_FileCount = 3;
	z->TYPE
	[
		INT_0	Address to file 0 (from TYPE[0])
		INT_1	Address to file 1 (from TYPE[0])
		INT_2	Address to file 2 (from TYPE[0])
		INT_3	Size of file 0 (in bytes)
		INT_4	Size of file 1 (in bytes)
		INT_5	Size of file 2 (in bytes)
		FILE_0[INT_3]
		FILE_1[INT_4]
		FILE_2[INT_5]
	]
	
	...
*****************************************************************************/



char	item[24];
int		a;
int		b;
int		c;
int		d;
float	f;
int		a1;
int		c1;
int		endoffile;
long	filesize_zone;
long	filesize_stagea;
long	filesize_stageb;
long	filesize_stagec;
long	filesize_staged;
int		filesize_data;
char	filename[256];
char	path[256];
FILE	*txt_file;
FILE	*txt_data;



///////////
// STAGE //
///////////
typedef struct	// Previously called a "TIMEZONE"
{
	char	Name;
	char	ActNumber;
	char	MusicRegular;
	char	MusicAlternate;
	char	OpeningScript;
	char	ClosingScript;
	char	ActiveScript;
	char	WaterEnable;
	short	WrapPoint;
	char	AboveWaterFilterL;
	char	BelowWaterFilterL;
	float	AboveWaterFilterSpeed;
	float	BelowWaterFilterSpeed;
	char	ClearBackground;
	//char	BelowWaterFilterB;
	char	Palette;
	char	ColorCycle;
	char	WaterMap;
	char	BlockMap;
	char	BlockArt;
	char	BlockData;
	char	BlockAttributes;
	char	BlockSolidity;
	char	TileMap;
	char	ObjectLayout;
	short	WaterHeight;
	short	LevelXL;
	short	LevelXR;
	short	LevelYT;
	short	LevelYB;
	short	StartX[16];
	short	StartY[16];
} STAGE;



/////////
// ACT //
/////////
typedef struct
{
	char			IncludedStages;		// (bits: 0000DCBA)
	STAGE			Stage[4];
} ACT;



//////////
// ZONE //
//////////
typedef struct
{	
	char			Act_FileCount;
	ACT				*Act;
	
	char 			LevelName1[20];
	char 			LevelName2[20];
	
	unsigned char	OSC_FileCount;
	unsigned char	BATT_FileCount;
	unsigned char	BDAT_FileCount;
	unsigned char	BLOCK_FileCount;
	unsigned char	BMAP_FileCount;
	unsigned char	BSOL_FileCount;
	unsigned char	OBJ_FileCount;
	unsigned char	PAL_FileCount;
	unsigned char	TMAP_FileCount;
	unsigned char	WMAP_FileCount;
	unsigned char	CCYC_FileCount;
	unsigned char	FILTERDISTORTION_FileCount;
	unsigned char	FILTERCOMPOSITE_FileCount;
	
	unsigned int	*OSC_SizeTable;
	unsigned int	*BATT_SizeTable;
	unsigned int	*BDAT_SizeTable;
	unsigned int	*BLOCK_SizeTable;
	unsigned int	*BMAP_SizeTable;
	unsigned int	*BSOL_SizeTable;
	unsigned int	*OBJ_SizeTable;
	unsigned int	*PAL_SizeTable;
	unsigned int	*TMAP_SizeTable;
	unsigned int	*WMAP_SizeTable;
	unsigned int	*CCYC_SizeTable;
	unsigned int	*FILTERDISTORTION_SizeTable;
	unsigned int	*FILTERCOMPOSITE_SizeTable;
	
	unsigned int	*OSC_AddressTable;
	unsigned int	*BATT_AddressTable;
	unsigned int	*BDAT_AddressTable;
	unsigned int	*BLOCK_AddressTable;
	unsigned int	*BMAP_AddressTable;
	unsigned int	*BSOL_AddressTable;
	unsigned int	*OBJ_AddressTable;
	unsigned int	*PAL_AddressTable;
	unsigned int	*TMAP_AddressTable;
	unsigned int	*WMAP_AddressTable;
	unsigned int	*CCYC_AddressTable;
	unsigned int	*FILTERDISTORTION_AddressTable;
	unsigned int	*FILTERCOMPOSITE_AddressTable;
	
	unsigned char	*OSC;
	unsigned char	*BATT;
	unsigned char	*BDAT;
	unsigned char	*BLOCK;
	unsigned char	*BMAP;
	unsigned char	*BSOL;
	unsigned char	*OBJ;
	unsigned char	*PAL;
	unsigned char	*TMAP;
	unsigned char	*WMAP;
	unsigned char	*CCYC;
	unsigned char	*FILTERDISTORTION;
	unsigned char	*FILTERCOMPOSITE;
} ZONE;







// Needed by CompileZone()
int ReadWord(ZONE *z, const char *string, ...);
int ReadText(ZONE *z, const char *string, ...);
int ReadVar(ZONE *z, const char *string, ...);
int ReadFloatVar(ZONE *z, const char *string, ...);

void ClearZone(ZONE *z);
void DeleteZone(ZONE *z);
int CreateZone(ZONE *z);
int CompileZone(ZONE *z, const char *string, ...);
int LoadZone(ZONE *z, const char *string, ...);
int SaveZone(ZONE *z, const char *string, ...);
