/*****************************************************************************
 *	      ______
 *	    /   _   \   _   __    ______
 *	   /  /_ /  / /  //__ / /   _   \
 *	  /   ____ / /   /     /  /  /  /
 *	 /  /       /  /      /  /_ /  /
 *	/_ /       /_ /       \ _____ /
 *	           ______
 *	         /  ____ /  ______     _   __     _    ______
 *	        /  /___   /   _   \  /  //_  \  /_ / /   _   \
 *	       _\___   \ /  /  /  / /   / /  / /  / /  /  /_ /
 *	     /  /_ /  / /  /_ /  / /  /  /  / /  / /  /____ 
 *	     \______ /  \ _____ / /_ /  /_ / /_ /  \ ______/
 *	
 *	
 *	ProSonic Engine
 *	Created by Damian Grove
 *	
 *	Compiled with DJGPP - GCC 2.952 (DOS) / Dev-C++ 4.9.9.2 (Windows)
 *	Libraries used:
 *		- Allegro - 3.9.34		http://www.talula.demon.co.uk/allegro/
 *		- DUMB - 0.9.3			http://dumb.sourceforge.net/
 *		- AllegroOgg - 1.0.3	http://nekros.freeshell.org/delirium/
 *
 ******************************************************************************
 *
 *	NAME:	ProSonic - Structures header
 *
 *	FILE:	structs.h
 *	
 *	DESCRIPTION:
 *		All structures to be used through-out the engine go here.
 *	
 *****************************************************************************/



#ifndef STRUCTS_H
	#define STRUCTS_H
	
	#ifdef __cplusplus
	extern "C"{
	#endif
	
	typedef struct{
		short	src_x_left;
		short	src_x_right;
		short	src_y_top;
		short	src_y_bottom;
		short	dest_x;
		short	dest_y;
		short	show_if_x_higher;
		short	show_if_x_lower;
		short	show_if_y_higher;
		short	show_if_y_lower;
		short	scroll_wrap_x;
		short	scroll_wrap_y;
		short	scroll_speed_x;
		short	scroll_speed_y;
		char	auto_speed_x;
		char	auto_speed_y;
		char	filter_c;		// above water
		char	filter_d;		// under water
		char	filter_c_speed;
		char	filter_d_speed;
		char	transparent;
		char	RESERVED_CHAR;
	} CELL;
	
	
	
	////////////
	// OBJECT //
	////////////
	typedef struct	// For any object other than the player
	{
		int user[16];		// user defined variables
		
		char static_node;
		char h_tag;
		char l_tag;
		unsigned char type;	// it's important that we make this unsigned
		char routine;
		char status;
		short x_pos;
		short y_pos;
		char render_flags;
		char width_pixels;
		char priority;
		char subtype;
		char objoff_32;
		char objoff_34;
		char anim_frame_duration;
		short anim_frame;
		char anim;
		short x_pos_pre;
		short y_pos_pre;
		short x_vel;
		short y_vel;
		char x_radius;
		char y_radius;
		//unsigned int anim_counter;
		//unsigned char anim_speed;
	
		// Right now, 255 objects are supported by the engine. If needed, there
		// could be changes to support more than this in the future. Of course,
		// the Member could be split to have two or more objects stored into a
		// single object class, but that would be sorta sloppy if the objects
		// are completely unrelated.
		
		char	ram[0x1300];
	} OBJECT;
	
	
	
	////////////
	// PLAYER //
	////////////
	
	typedef struct {
		char player_name[16];
		//char network_id;
		char character;
		char sidekick;
		
		unsigned char CtrlInput;
		
		char render_flags;
		short art_tile;
		int mappings;
		short x_pos;
		unsigned short x_pos_pre;
		short y_pos;
		unsigned short y_pos_pre;
		short x_vel;
		short y_vel;
		short inertia;
		char x_radius;
		char y_radius;
		char priority;
		char anim_frame_duration;
		short anim_frame;
		char anim;
		char next_anim;
		//char anim_frame_duration;
		char status;
		char routine;
		char routine_secondary;
		char angle;
		char flip_angle;
		char air_left;
		char flip_turned;
		char obj_control;
		char status_secondary;
		char flips_remaining;
		char flip_speed;
		short move_lock;
		short invulnerable_time;
		short invincibility_time;
		short speedshoes_time;
		char next_tilt;
		char tilt;
		char stick_to_convex;
		char spindash_flag;
		short spindash_counter;
		char jumping;
		char interact;
		char layer;
		char layer_plus;
		
		short Sonic_top_speed;
		short Sonic_acceleration;
		short Sonic_deceleration;
		
		char Ctrl_Held;
		char Ctrl_Press;
		char Ctrl_Held_Logical;
		char Ctrl_Press_Logical;
		
		char width_pixels;
		char mapping_frame;
		
		short Sonic_Look_delay_counter;
		short Sonic_Stat_Record_Buf[128];
		short Sonic_Pos_Record_Buf[128];
		short Camera_X_pos;
		short Camera_Y_pos;
		short Camera_Z_pos;/////////////////
		short Camera_Max_Y_pos;
		short Camera_Min_X_pos;
		short Camera_Max_X_pos;
		short Camera_Min_Y_pos;
		short Camera_Max_Y_pos_now;
		short Camera_X_pos_coarse;
		char Sonic_Pos_Record_Index;
		short Camera_Y_pos_bias;
		
		short Ring_count;
		unsigned int Score;
		unsigned char Life_count;
		char Extra_life_flags;
		char Last_star_pole_hit;
		char Saved_Last_star_pole_hit;
		short Saved_x_pos;
		short Saved_y_pos;
		short Saved_Ring_count;
		int	 Saved_Timer;
		short Saved_art_tile;
		short Saved_layer;
		short Saved_Camera_X_pos;
		short Saved_Camera_Y_pos;
		short Saved_Water_Level;
		char Saved_Extra_life_flags;
		char Saved_Extra_life_flags_2P;
		short Saved_Camera_Max_Y_pos;
		
		int Collision_addr;
		
		short ram_EEB0;
		short ram_EEB2;
		short ram_EEBE;
		short ram_EED0;
		short ram_F65C;
		char ram_F768;
		char ram_F76A;
		char ram_F7C7;
	} PLAYER;
	
	
	
	typedef struct {
		unsigned char bind_up;
		unsigned char bind_down;
		unsigned char bind_left;
		unsigned char bind_right;
		unsigned char bind_b;
		unsigned char bind_c;
		unsigned char bind_a;
		unsigned char bind_start;
	} BINDING;
	
	
	
	struct fmtObj{
		short			x_pos;
		short			y_pos;
		unsigned char	type;
		unsigned char	subtype;
		unsigned char	h_tag;
		unsigned char	l_tag;
	};
	typedef struct fmtObj OBJECT_PLOT;
	
	
	#ifdef __cplusplus
	}
	#endif
#endif
