#define SCRIPT_TYPE_PROCODE		0
#define SCRIPT_TYPE_MOTOROLA	1

char addr_literal;	// When this is TRUE, calc_effective_address() will copy
					// address values without conversions. This value will be
					// set to zero once calc_effective_address() has finished.
char ea_big_endian;

//void pro_call(int target);
void pro_call(short data, unsigned short NodeNumber);
void pro_jump(short data, unsigned short NodeNumber);

void DataIn();
void DataOut();
//void SlopeObject(int target);

unsigned char *script;			// collection of all scripts
unsigned int script_size;
unsigned char *obj_script;		// individual script (object OR function)
signed int script_pos;			// used to track in 'obj_script'

unsigned char obj_script_type[256];		// 0 = Procode;  1 = Motorola
unsigned int obj_script_start[256];
unsigned int obj_script_size[256];

// These are for generic game functions
unsigned int game_script_start[8];
unsigned int game_script_size[8];

void RunScript(unsigned short NodeNumber);
void RunFunction(unsigned char function);

void LoadBinary(unsigned char o, const char *filename);





#define NUM_INTERNAL_GVARS		91		// generic variables
#define NUM_INTERNAL_OVARS		24		// object variables
#define NUM_INTERNAL_PVARS		90		// player variables
//	#define NUM_KEYWORDS			11
//	#define NUM_OPERATORS			14
//	#define NUM_CONDITIONS			6

int *internal_gvar_ptrs[NUM_INTERNAL_GVARS];
int *internal_ovar_ptrs[NUM_INTERNAL_OVARS];
int *internal_pvar_ptrs[4][NUM_INTERNAL_PVARS];

char internal_gvar_size[NUM_INTERNAL_GVARS];
char internal_ovar_size[NUM_INTERNAL_OVARS];
char internal_pvar_size[NUM_INTERNAL_PVARS];

int break_ptr[256];
unsigned char if_scope;
