#ifndef MENUS_H
	#define MENUS_H
	
	#include	"structs.h"
	#include	"text.h"
	
	#ifdef __cplusplus
	extern "C"{
	#endif
	
	char menu_column_size;
	char menu_column_count;
	signed char menu_selection;			// item (zone)
	signed char menu_sub_selection;		// row (act)
	char menu_timer1;					// repeat delay (UP)
	char menu_timer2;					// repeat delay (DOWN)
	char menu_timer3;					// repeat stop (LEFT)
	char menu_timer4;					// repeat stop (RIGHT)
	char show_menu;
	
	typedef struct{
		char type;			// 0 for acts, 1 for sound test
		char var_size;		// used for "TYPE 1"	0 for char, 1 for short, 3 for float
		char *var_ptr8;		// used for "TYPE 1"
		short *var_ptr16;	// used for "TYPE 1"
		int *var_ptr32;		// NOT USED AT ALL!!
		float *var_ptr32f;	// used for "TYPE 1"
		float min_value;	// used for "TYPE 1"
		float max_value;	// used for "TYPE 1"
		char value_digits;	// used for "TYPE 1"
		short offset_x;
		short offset_y;
		char columns;
		char string[8][8];	// [column][character]		e.g. "STAGE 1"
		// CURRENTLY, ONLY [0][x] WORKS!!
	} MENU_ITEM_SUB;
	
	typedef struct{
		short offset_x;
		short offset_y;
		char show;
		char rows;
		char string[20];	// e.g. "EMERALD HILL"
		MENU_ITEM_SUB row[8];
	} MENU_ITEM;
	
	MENU_ITEM	selection_menu[14];
	
	void Menu();
	void InitLevelSelect();
	
	#ifdef __cplusplus
	}
	#endif
#endif
