#include "includes.h"
#include "c_automaton.h"

#define VERSION 0.2

bool quit = 0;

void load_settings();
void init_allegro();

int main()
{
    srand( time(NULL) );

    load_settings();
    init_allegro();

    c_automaton automaton;

    {
        char path[80];
        strcpy( path, ".\\" );
        if( file_select_ex("Please select a rules file to load.", path, "XML;/-d", 560, 0, 0)!=0 )
        {
            automaton.load_rules( path );
            automaton.save_rules( "debug.txt" );
        }
        else
        {
            exit( 0 );
        }
    }

    BITMAP* buffer = create_bitmap( SCREEN_WIDTH, SCREEN_HEIGHT );

    while( !quit )
    {
        clear_to_color( buffer, makecol(255, 255, 255) );
        automaton.draw( buffer, 0,0 );

        acquire_screen();
        blit( buffer, screen, 0,0, 0,0, SCREEN_WIDTH,SCREEN_HEIGHT );
        release_screen();

        //readkey();

        while( ticks==0 )
        {
            rest(100 / updates_per_second);
        }

        while( ticks>0 )
        {
            int old_ticks = ticks;

            if( mouse_z > 0 )
            {
                position_mouse_z( 0 );
                current_type++;
            }
            else if( mouse_z < 0 )
            {
                position_mouse_z( 0 );
                current_type--;
            }

            if( mouse_b & 1 )
            {
                int x=mouse_x;
                int y=mouse_y;

                automaton.set_tile_pixel( x,y, current_type );
            }
            if( mouse_b & 2 )
            {
                int x=mouse_x;
                int y=mouse_y;

                automaton.set_tile_pixel( x,y, -1 );
            }

            if( key[KEY_SPACE] and step_time==0 )
            {
                automaton.step();
                step_time = 5;
            }
            else if( key[KEY_L] )
            {
                char path[80];
                strcpy( path, ".\\" );
                if( file_select_ex("Please select a grid file to load.", path, "TXT;BMP;/-d", 560, 0, 0)!=0 )
                {
                    automaton.load_grid( path );
                }
            }
            else if( key[KEY_R] )
            {
                char path[80];
                strcpy( path, ".\\" );
                if( file_select_ex("Please select a rules file to load.", path, "XML;/-d", 560, 0, 0)!=0 )
                {
                    automaton.load_rules( path );
                    automaton.save_rules( "debug.txt" );
                }
            }
            else if( key[KEY_S] )
            {
                automaton.save_grid( "savefile.bmp" );
                allegro_message( "File saved as 'savefile.bmp'.  Rename or move the file, to avoid overwriting." );
            }
            else if( key[KEY_ESC] )
            {
                quit = true;
            }

            ticks--;
            if(old_ticks<=ticks)
            {
                break;
            }
        }
    }

    return 0;
}

END_OF_MAIN()


void load_settings()
{
    c_ini_reader file( ".\\settings.ini" );

    SCREEN_WIDTH = file.ReadInteger( "Resolution", "width", 640 );
    SCREEN_HEIGHT = file.ReadInteger( "Resolution", "height", 480 );
}


void init_allegro()
{
    /* you should always do this at the start of Allegro programs */
    if (allegro_init() != 0)
    {
        exit(1);
    }

    /* set up the keyboard handler */
    install_keyboard();

    /* set up the mouse handler */
    install_mouse();

    install_timer();
    install_int_ex(ticker, BPS_TO_TIMER(updates_per_second));

    /* toggle the display of the mouse on */
    show_os_cursor(MOUSE_CURSOR_ARROW);

    /* set a graphics mode */
    if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, SCREEN_WIDTH, SCREEN_HEIGHT, 0, 0) != 0)
    {
        if (set_gfx_mode(GFX_SAFE, SCREEN_WIDTH, SCREEN_HEIGHT, 0, 0) != 0)
        {
            set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
            allegro_message("Unable to set any graphic mode\n%s\n", allegro_error);
            exit(1);
        }
    }

    /* set the color palette */
    set_palette(default_palette);
}
