#ifndef C_GRID_H_INCLUDED
#define C_GRID_H_INCLUDED

#include "includes.h"

class c_grid
{
    private:
        vector< vector<char> > m_data;

    public:
        c_grid(int width=SCREEN_WIDTH, int height=SCREEN_HEIGHT, char fillvalue=0)
        {
            resize( width, height, fillvalue );
        }

        void set(int x, int y, char value)
        {
            if( int(m_data.size())>x and x>0 )
            {
                if( int(m_data.at(x).size())>y and y>=0 )
                {
                    m_data.at(x).at(y) = value;
                }
            }
        }
        char get(int x, int y)
        {
            if( int(m_data.size())>x and x>0 )
            {
                if( int(m_data.at(x).size())>y and y>=0 )
                {
                    return m_data.at(x).at(y);
                }
            }
            return 0;
        }

        void resize(int width, int height, char fillvalue)
        {
            m_data.resize( width, vector<char>(height, fillvalue) );
        }
};

#endif // C_GRID_H_INCLUDED
