#include "mymath.h"

#ifndef GAME_WEATHER_H_INCLUDED
#define GAME_WEATHER_H_INCLUDED


#define WEATHER_PARTICLE_TYPE_SNOW         0


#define WEATHER_TYPE_SNOWY                 0


class WeatherParticle {
  protected:
    Vec2D pos;
    float length;
    int type, life;
    float factor;
    float dir;
    bool d, ripple;
    int frame;
    int delay;
  public:
    WeatherParticle() {type=life=dir=d=frame=0;ripple=false;delay=0;}
    void SetTo(float tx, float ty, float l) {pos.x=tx;pos.y=ty;length=l;life=0;}
    void SetType(int t){type=t;}
    void SetLife(int l){life=l;}
    void SetFactor(float f){factor=f;}
    void Update();
    void Draw();
    int GetLife() {return life;}
};


class GameWeatherClass {
  protected:
    std::vector<WeatherParticle> particles;
    int type;
  public:
    GameWeatherClass(){particles.clear();type=WEATHER_TYPE_SNOWY;}
    void SetType(int t) {
      type = t;
    }
    void CreateParticles(int size) {
      particles.clear();
      int i;
      for (i=0;i!=size;i+=1) {
        particles.push_back(WeatherParticle());
      }
    }
    void Update();
    void SetParticle(WeatherParticle *p);
    void Draw() {
      std::vector<WeatherParticle>::iterator it;
      for (it=particles.begin(); it!=particles.end(); it+=1) {
        (*it).Draw();
      }
    }
    int GetType(){return type;}
};

extern GameWeatherClass *GameWeather;



#endif
