

#include "mymath.h"
#include "camera.h"
#include "cache.h"
#include "globals.h"

void play_3d_sample(ALLEGRO_SAMPLE *s, float vol, float freq, float loop, float x, float y) {
  float cvol;
  cvol = distance_between_points(x, y, RSW(Camera_X)+SCREEN_W/2, RSH(Camera_Y)+SCREEN_H/2);
  cvol = cvol / SCREEN_W;
  cvol = 1.0 - cvol;

  if (cvol < 0) cvol = 0;

  vol = (float)vol * cvol;

  float d;
  d = x - (RSW(Camera_X) + SCREEN_W/2);
  d = d / (SCREEN_W/2);

  int pan;

  pan = 0.5 + (0.5 * d);

  if (pan < 0) pan = 0;
  if (pan > 1) pan = 1;

  al_play_sample(s, vol, pan, 1.0, ALLEGRO_PLAYMODE_ONCE, NULL);
}

