#include "object.h"
#include "mymath.h"

#ifndef PARTICLE_H_INCLUDED
#define PARTICLE_H_INCLUDED


const int PARTICLE_SNOWBALL_01 = 0;
const int PARTICLE_SNOWBALL_02 = 1;
const int PARTICLE_SNOWBALL_03 = 2;
const int PARTICLE_SNOWBALL_04 = 3;
const int PARTICLE_SNOWBALL_05 = 4;
const int PARTICLE_SNOWBALL_06 = 5;
const int PARTICLE_HIT_01      = 6;
const int PARTICLE_SPARKLE_01  = 7;
const int PARTICLE_SPARKLE_02  = 8;
const int PARTICLE_SPARKLE_03  = 9;
const int PARTICLE_SPARKLE_04  = 10;
const int PARTICLE_SPARKLE_05  = 11;
const int PARTICLE_GIFT_01     = 12;
const int PARTICLE_GIFT_02     = 13;
const int PARTICLE_GIFT_03     = 14;
const int PARTICLE_GIFT_04     = 15;
const int PARTICLE_GIFT_05     = 16;
const int PARTICLE_GIFT_06     = 17;
const int PARTICLE_TORCH_01    = 18;


class Particle : public Object {
  protected:
    float opacity, life;
    int type;
    bool erasing, erased;
    Vec2D direction;
    float speed;
  public:
    Particle(float x, float y, std::string path, float lf);
    Particle(float x, float y, Particle *p, float lf, Vec2D dir, float sp);
    void SetType(int v){type=v;}
    virtual void Reset();
    virtual void UpdateGeneral();
    bool Erase() {return erased;}
    void Kill(){life=0;}
    void Draw();
    ~Particle();
};

void DeleteParticleList();

void LoadParticles();

void AddParticle(int i, float x, float y, float sp, Vec2D dir, float lf);
void UpdateParticles();
void DrawParticles();

extern std::vector<Particle *> particles;

void CleanParticlesList();


#endif
