#include "ansprite.h"
#include <deque>

#ifndef OBJECT_H_INCLUDED
#define OBJECT_H_INCLUDED


class Object {
  protected:
    float x, y, rx, ry, w, h, rw, rh, z, angle;
    float original_x, original_y;
    AnimatedSprite sprite;
    CacheBitmap *actual;

    Object *next_z;
    Object *prev_z;

  public:
    Object() {
      Reset();
    }
    void Reset() {
      x=y=rx=ry=w=h=rw=rh=angle=z=0;
      actual = NULL;
      sprite.Reset();
    }
    void Update();
    virtual void UpdateGeneral(){}
    virtual void Draw();
    virtual void DrawGeneral(){}
    void SetX(float v) {x = v;}
    void SetY(float v) {y = v;}
    void SetZ(float v) {z = v;}
    float GetX() {return x;}
    float GetY() {return y;}
    float GetZ() {return z;}

    float GetW() {return w;}
    float GetH() {return h;}

    float GetRX() {return rx;}
    float GetRY() {return ry;}

    void SetWidth(float v) {w = v;}
    void SetHeight(float v) {h = v;}
    void SetSize(float tw, float th) {w=tw; h=th;}

    void SetPosition(float tx, float ty) {x=tx; y=ty;original_x=x;original_y=y;}

    virtual void LoadGraphics(std::string filename) {
      sprite.Load(filename);
    }

    void set_z_prev(Object *ob) {prev_z = ob;}
    void set_z_next(Object *ob) {next_z = ob;}

    bool InsideScreen();

    AnimatedSprite *GetSprite() {return &sprite;}

    Object *get_z_prev() {return prev_z;}
    Object *get_z_next() {return next_z;}

    virtual void DeleteGeneral() {}
    ~Object() {DeleteGeneral();}
};


extern std::deque<Object *> GameObjects;

extern Object *ObjectZOrder_list;

void UpdateObjectZSorting();
void DrawObjectsZOrder();
void AddObjectZOrder(Object *v);

void DeleteFromGameObjects(Object *o);


#endif
