#include "cache.h"
#include "scenes.h"
#include "globals.h"
#include "mymath.h"
#include "mykeyboard.h"
#include "frames.h"
#include "drawfx.h"
#include "gui.h"


ALLEGRO_BITMAP *endgame_background;


float CreditRollY=0;

const int CREDITS_SIZE=108;

std::string credits[CREDITS_SIZE] = {
  "--- Credits ----",
  "",
  "",
  "",
  " Game made by Dario ff",
  "",
  "",
  "",
  " Resource Investigation by Luciana"
  "",
  " Music suggested by Marcos",
  "",
  "",
  "",
  " = Allegro.cc Helpers =",
  "",
  "",
  "Siege Lord",
  "Trent Gamblin",
  "Neil Walker",
  "Ron Novy",
  "",
  "",
  "",
  "",
  " = Winner of the Credits Idea =",
  " Everyone won!   :)",
  "",
  " -- Quotes --",
  "",
  " ixilom - A trojan that makes all computers in the world",
  " into Cybernet, which rather than trying to end humanity,",
  " would fight snow with flamethrowing weapons."
  "",
  "",
  "",
  " Trent Gamblin - I can send you a photo of me with",
  " my shirt off."
  "",
  "",
  " Slartibartfast - Make the credits some mini-game whose",
  " purpose is to reveal the credits. Make it a volfied",
  " clone, but when you cover territory you reveal the image",
  " for the credits."
  "",
  "",
  " Mokkan - You could show off all of your concept art and",
  "  diagrams and such while the credits roll.",
  "",
  "",
  " Bob Keane - Post a big red 'PSYCHE!' message and make",
  " the player think the game he/she just finished was just a",
  " demo for the real game and have them start over but at",
  " a harder level?",
  "",
  "",
  " Mark Oates - Written and Directed by dario ff",
  "              Story by dario ff",
  "              Cinematography by dario ff",
  "              Original Motion Picture Score by dario ff",
  "              Craft Services by dario ff",
  "              [etc]",
  "",
  "",
  " Dizzy Egg - I'd like to see all of the yolk-folk enjoying",
  " a well basted turkey, or a well basted turkey laying a",
  " yolk-folk. Only folking yolking."
  "",
  "",
  " le_y_mistar - post pics of yourself and your buddies",
  "  having fun coding the game.",
  "",
  "",
  " Onewing - rickroll em...er...us.",
  "",
  "",
  "---------------------------------------",
  ""
  "",
  " Special Thanks to Jakub Wasilewski for",
  "  organizing the Christmas Hack '09!"
  "",
  "",
  "",
  "",
  " I wish you a Merry Christmas and a Happy new Year. ",
  " Thanks for playing and save the Christmas one more time!",
  "",
  " You should try to save it faster now",
  " by beating your hiscores!",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "If you're still watching this, you can quit by pressing ESC..."
};

void GScene_End::draw() {
  al_clear_to_color(al_map_rgb_f(0, 0, 0));
  DRAW_TRANSFORMED(endgame_background, SCREEN_W/2, SCREEN_H/2, SCREEN_W, SCREEN_H, 0, 0);


  int s, f;
  s = (CreditRollY/(hiscore_font->Height()+RSH(6)))-SCREEN_H/(hiscore_font->Height()+RSH(6))-3;
  f = s+SCREEN_H/hiscore_font->Height()+2;
  if (s < 0) s = 0;
  if (s >= CREDITS_SIZE) s = CREDITS_SIZE-1;
  if (f < 0) f = 0;
  if (f >= CREDITS_SIZE) f = CREDITS_SIZE-1;

  for (int i=s; i!=f; i+=1) {
    hiscore_font->Print(credits[i], SCREEN_W/2-hiscore_font->Width(credits[i])/2-2, SCREEN_H-CreditRollY+i*(hiscore_font->Height()+RSH(6)), al_map_rgba_f(0, 0, 0, 1));
    hiscore_font->Print(credits[i], SCREEN_W/2-hiscore_font->Width(credits[i])/2+2, SCREEN_H-CreditRollY+i*(hiscore_font->Height()+RSH(6)), al_map_rgba_f(0, 0, 0, 1));
    hiscore_font->Print(credits[i], SCREEN_W/2-hiscore_font->Width(credits[i])/2, SCREEN_H-CreditRollY-2+i*(hiscore_font->Height()+RSH(6)), al_map_rgba_f(0, 0, 0, 1));
    hiscore_font->Print(credits[i], SCREEN_W/2-hiscore_font->Width(credits[i])/2, SCREEN_H-CreditRollY+2+i*(hiscore_font->Height()+RSH(6)), al_map_rgba_f(0, 0, 0, 1));
    hiscore_font->Print(credits[i], SCREEN_W/2-hiscore_font->Width(credits[i])/2, SCREEN_H-CreditRollY+i*(hiscore_font->Height()+RSH(6)));
  }

  if (BlackFade != 0) {
    al_draw_filled_rectangle(0, 0, SCREEN_W, SCREEN_H, al_map_rgba_f(0, 0, 0, BlackFade));
  }

  al_flip_display();
}


bool QuitGame=false;


void GScene_End::update() {
  UpdateGlobalZoomFactor();
  poll_my_keyboard();
  UpdateDelta();
  BlackFade += BlackFadeDir*DeltaTime;
  if (BlackFade < 0) BlackFade=0;
  if (BlackFade > 1) BlackFade=1;

  CreditRollY += RSH(0.5)*DeltaTime;

  if (Keyboard_Recently_Input[ALLEGRO_KEY_ESCAPE]) {
    BlackFadeDir = 0.008;
    QuitGame=true;
  }

  if ((QuitGame)&&(BlackFade == 1)) Scene=-1;

  FramesUpdated+=1;
}

bool EndgameCreated=0;

void create_endgame() {
  if (EndgameCreated) return;
  EndgameCreated=1;
  endgame_background = al_load_bitmap("Graphics/GUI/EndGameScreen.png");
}


void GScene_End::main() {
  ChangeGlobalMusic(music_end);
  CreditRollY = 0;
  create_endgame();
  BlackFade=1.0;
  BlackFadeDir=-0.06;
  al_start_timer(timer);
  ResetDelta();
  update();
  while (Scene == SCENE_END) {
    ALLEGRO_EVENT event;
    al_wait_for_event(queue, &event);
    if (event.type == ALLEGRO_EVENT_TIMER) {
      draw();
      update();
    }
  }
}
