

#include "allegro5/allegro5.h"
#include "cache.h"
#include "frames.h"


#ifndef GLOBALS_H_INCLUDED
#define GLOBALS_H_INCLUDED

#define SCREEN_W al_get_display_width()
#define SCREEN_H al_get_display_height()


#define OPACITY_BLEND(op) al_set_blender(ALLEGRO_ALPHA, ALLEGRO_INVERSE_ALPHA, al_map_rgba_f(1.0, 1.0, 1.0, op))
#define COLOR_BLEND(c) al_set_blender(ALLEGRO_ALPHA, ALLEGRO_INVERSE_ALPHA, c)
#define NORMAL_BLEND  al_set_blender(ALLEGRO_ALPHA, ALLEGRO_INVERSE_ALPHA, al_map_rgba_f(1, 1, 1, 1.0))

#define DRAW_TRANSFORMED(bit, x, y, w, h, angle, flag)  al_draw_rotated_scaled_bitmap(bit, (float) al_get_bitmap_width(bit)/2, (float) al_get_bitmap_height(bit)/2, x, y, ((float) w)/((float) al_get_bitmap_width(bit)), ((float) h)/((float) al_get_bitmap_height(bit)), angle, flag)
#define DRAWNORMAL al_set_target_bitmap(al_get_backbuffer())
#define DRAWTO(bit) al_set_target_bitmap(bit)

#define AL_MESSAGE(text) al_show_native_message_box("Allegro Message", "", text, NULL, ALLEGRO_MESSAGEBOX_WARN)

#define GUI_LIMIT  SCREEN_W-RSW(180)


#define SCENE_GAME         1
#define SCENE_MENU         2
#define SCENE_HISCORES     3
#define SCENE_END          4

#define PAN(x)       (((x) * 256) / SCREEN_W)

#define SPAWNS_SIZE  11
#define LIGHTS_SIZE  8

#define GAME_LEVELS  8

#define HELP_SCREENS 2

#define HOHO_SIZE    4

extern bool Music;

extern int Scene;
extern int ALLEGRO_SETUP;
extern char null_str[];
extern int BPP;
extern int EditorMode;
extern int Pause;
extern int MouseSensitivity;


extern int DelayAfterDoubleClick;

extern ALLEGRO_EVENT_QUEUE *queue;
extern ALLEGRO_TIMER *timer;

extern bool RectangleSelection;

extern ALLEGRO_SAMPLE_ID actual_music_id;


extern int Fade;
extern int FadeSpeed;
extern int BlackScreen;


extern ALLEGRO_DISPLAY *display;

extern ALLEGRO_BITMAP *cursor;
extern ALLEGRO_BITMAP *cursor_normal;
extern ALLEGRO_BITMAP *cursor_bucket;
extern ALLEGRO_BITMAP *cursor_walk;
extern ALLEGRO_BITMAP *cursor_attack;
extern ALLEGRO_BITMAP *cursor_power[];
extern ALLEGRO_BITMAP *cursor_hand;
extern ALLEGRO_BITMAP *spawns[];
extern ALLEGRO_BITMAP *lights[];
extern ALLEGRO_BITMAP *powers[];
extern ALLEGRO_BITMAP *results_next;
extern ALLEGRO_BITMAP *results_next_on;
extern ALLEGRO_BITMAP *snow_bit;

extern ALLEGRO_BITMAP *mission_complete_bit;
extern ALLEGRO_BITMAP *mission_failed_bit;


extern bool DynamicLighting;
extern bool MotionBlur;
extern bool Shadows;
extern bool DebugMode;


extern ALLEGRO_BITMAP *score_table_bit;

extern ALLEGRO_BITMAP *flash_grenade;
extern ALLEGRO_BITMAP *storyboard_bit;
extern ALLEGRO_BITMAP *briefing_bit;
extern ALLEGRO_BITMAP *help_bit;


extern ALLEGRO_BITMAP *selected_bit;
extern ALLEGRO_BITMAP *selected_enemy_bit;
extern ALLEGRO_BITMAP *selected_coward_bit;
extern ALLEGRO_BITMAP *collision_bit;
extern ALLEGRO_BITMAP *collision2_bit;

extern ALLEGRO_BITMAP *right_border;
extern ALLEGRO_BITMAP *right_border_top;
extern ALLEGRO_BITMAP *low_border;
extern ALLEGRO_BITMAP *remark_button;
extern ALLEGRO_BITMAP *remark_portrait;

extern ALLEGRO_BITMAP *help_pages[];

extern ALLEGRO_SAMPLE *global_music;
extern ALLEGRO_SAMPLE *chalk[];
extern ALLEGRO_SAMPLE *next_appear;
extern ALLEGRO_SAMPLE *cough[];
extern ALLEGRO_SAMPLE *hoho[];

extern ALLEGRO_SAMPLE *hit[];

extern ALLEGRO_SAMPLE *music_menu;
extern ALLEGRO_SAMPLE *music_game;
extern ALLEGRO_SAMPLE *music_hiscores;
extern ALLEGRO_SAMPLE *music_end;

extern ALLEGRO_AUDIO_STREAM *riot;

extern std::string GameLevels[];
extern int ActualLevel;
extern int MaximumAchievedLevel;

extern std::string UserName;

extern bool CanGuard;

extern float BlackFade;
extern float BlackFadeDir;

extern int StoryboardSize;


void ChangeGlobalMusic(ALLEGRO_SAMPLE *ms);
void Savegame();
void LoadSavegame();

void DrawLoadingScreen();


void change_map(std::string filename="", bool SameLevel=false);

int al_get_config_int(ALLEGRO_CONFIG *cfg, char *section, char *name, int def);
const char *al_get_config_str(ALLEGRO_CONFIG *cfg, char *section, char *name, char *def);
float al_get_config_float(ALLEGRO_CONFIG *cfg, char *section, char *name, float def);

void LoadGlobalResources();

#endif
