
#include "allegro5/allegro5.h"
#include <allegro5/allegro_opengl.h>
#include "allegro5/allegro_image.h"
#include <allegro5/allegro_direct3d.h>
#include <allegro5/allegro_native_dialog.h>
#include <allegro5/allegro_primitives.h>
#include <allegro5/allegro_font.h>
#include <allegro5/allegro_ttf.h>
#include <allegro5/allegro_audio.h>
#include <string>

using namespace std;


#ifndef FONTS_H_INCLUDED
#define FONTS_H_INCLUDED



ALLEGRO_COLOR char_to_color(char c);


const char PRINT_MODE_NORMAL = 0;
const char PRINT_MODE_OUTLINE = 1;
const char PRINT_MODE_SHADOW = 2;


class GameFont {
  protected:
    ALLEGRO_FONT *fgk;
    int height;
    ALLEGRO_COLOR color;
  public:
    GameFont(const char *filename, float h, ALLEGRO_COLOR col);
    ~GameFont() {
      al_destroy_font(fgk);
    }
    ALLEGRO_FONT *gk() {return fgk;}
    int Width(std::string msg) {
      int w = al_get_text_width(fgk, msg.c_str());
      return w;
    }
    int Height() {
      return height;
    }
    void Print(const std::string &text, int x, int baselineY) {
      al_draw_text(fgk, x, baselineY-height, 0, text.c_str());
    }
    void Print(const std::string &text, int x, int baselineY, ALLEGRO_COLOR col, char mode=PRINT_MODE_NORMAL);
    void PrintColorCoded(const std::string &text, int x, int baselineY);

};

extern GameFont *game_font;
extern GameFont *score_font;
extern GameFont *hiscore_font;


void load_game_fonts();


#endif
