#include "drawfx.h"
#include "globals.h"


// Looks Great!

float MotionBlurStart=3.0;

void DrawTransformedMotionBlur(ALLEGRO_BITMAP *b, int x, int y, int w, int h, float angle, int flag, Vec2D blur_dir, float angle_dir) {
  Vec2D norm;
  int l;
  norm = blur_dir.Normalized();
  l = blur_dir.GetMagnitude();

  l -= RSW(MotionBlurStart);

  if ((l > 0) && (MotionBlur)) {
    OPACITY_BLEND((1.0/(float)l)*4);
    DRAW_TRANSFORMED(b, x, y, w, h, angle, flag);

    OPACITY_BLEND((1.0/(float)l)*2);
    for (int i=l; i>0; i-=1) {
      DRAW_TRANSFORMED(b, (float)x-(norm.x*i), (float)y-(norm.y*i), w, h, angle, flag);
    }

    l = RadToAngle(angle_dir)/4;
    if (l > 1.0) {
      OPACITY_BLEND((1.0/(float)l)*2);
      for (int i=l; i>0; i-=1) {
        DRAW_TRANSFORMED(b, x, y, w, h, angle-(angle_dir/l)*i, flag);
      }
    }
  }
  else {
    DRAW_TRANSFORMED(b, x, y, w, h, angle, flag);
  }
  NORMAL_BLEND;
}
