#include "object.h"
#include "mymath.h"


#define PROJECTILE_TYPE_SNOWBALL  0

#ifndef PROJECTILE_H_INCLUDED
#define PROJECTILE_H_INCLUDED

class Projectile : public Object {
  protected:
    Vec2D dir;
    float speed;
    float damage;
    float life;
    bool my_side;
    float parb;
    float parb_dir;
    int type;
    bool hitt;
  public:
    Projectile(float s, float d, float lf, bool sd, Vec2D dr, int ty) {
      speed = s;
      damage = d;
      dir = dr;
      life = lf;
      my_side=sd;
      parb=1.0;
      parb_dir = (-0.5 / lf)*2;
      type = ty;
      hitt=false;
    }
    void CreateParticles();
    void UpdateGeneral();
    bool Dead() {return (life < 0);}
    void Draw();
};

extern std::deque<Projectile *> projectiles;


void AddProjectile(float x, float y, float s, float d, float lf, bool sd, Vec2D dr, int type);
void UpdateProjectiles();
void DrawProjectiles();


#endif
