
#include "mymath.h"
#include "mystr.h"
#include "globals.h"

float fastsqrt(float val) {
    int tmp = *(int *)&val;
    tmp -= 1<<23; /* Remove last bit to not let it go to mantissa */
    /* tmp is now an approximation to logbase2(val) */
    tmp >>= 1;    /* divide by 2 */
    tmp += 1<<29; /* add 64 to exponent: (e+127)/2 =(e/2)+63, */
                  /* that represents (e/2)-64 but we want e/2 */
    return *(float *)&tmp;
}


float distance_between_points(float x, float y, float tx, float ty) {
  float dx, dy;
  float dist;
  dx = tx - x; dx = dx*dx;
  dy = ty - y; dy = dy*dy;
  dist = dx + dy;
  dist = fastsqrt(dist);

  return dist;
}


float FixRadAngle(float v) {
  float total;
  total = AngleToRad(360);
  while (v < -total) v += total;
  while (v > total) v -= total;
  return v;
}


float mabs(float v) {
  return (v < 0 ? -v : v);
}

bool inside_rect(float a, float b, float x, float y, float fx, float fy) {
  if ((a>x)&&(a<fx)&&(b>y)&&(b<fy)) return true;
  return false;
}

float AngleToRad(float a) {
  return a * DEGTORAD;
}

float RadToAngle(float a) {
  return a / DEGTORAD;
}


float GlobalZoomXFactor=1;
float GlobalZoomYFactor=1;
float GlobalZoom=1.0;


float GlobalAspectRatio;

void UpdateGlobalZoomFactor() {
  GlobalZoomXFactor = (SCREEN_W / (768.0 * GlobalAspectRatio));
  GlobalZoomYFactor = (SCREEN_H / 768.0);
}

float RSW(float v) {
  return v * ((float)SCREEN_W*GlobalZoom / ((768.0) * GlobalAspectRatio));
}

float RSH(float v) {
  return v * ((float)SCREEN_H*GlobalZoom / (768.0));
}

float SRW(float v) {
  return v / ((float)SCREEN_W*GlobalZoom / ((768.0) * GlobalAspectRatio));
}

float SRH(float v) {
  return v / ((float)SCREEN_H*GlobalZoom / (768.0));
}


float RSX(float v) {
  return (v * GlobalZoomXFactor) * GlobalZoom;
}
float RSY(float v) {
  return (v * GlobalZoomYFactor) * GlobalZoom;
}

float SRX(float v) {
  return (v / GlobalZoomXFactor) / GlobalZoom;
}
float SRY(float v) {
  return (v / GlobalZoomYFactor) / GlobalZoom;
}

float BSX(float v) {
  return (v/1024.0) * SCREEN_W;
}

float BSY(float v) {
  return (v/768.0) * SCREEN_H;
}

int sgn(float v) {
  if (v >= 0) return 1;
  else return -1;
}

Vec2D Perpendicular(Vec2D v) {
  float t;
  t = -v.x;
  v.x = v.y;
  v.y = t;
  return v;
}


float ToFloat(std::string n) {
  float v, t;
  v = 0;
  bool dec, neg;
  int dec_s;
  dec_s = 0;
  dec=neg=false;

  if (n.size() == 0) return 1;

  for (int i=n.size()-1; i>=0; i-=1) {
    if (n[i] == '-') neg=true;
    else if (n[i] == '.') {
      dec=true;
      dec_s = i;
    }
  }


  int s, z;
  s= 1;
  z = 0;
  for (int i=n.size()-1; i>=0; i-=1) {
    if (n[i] == '.') {
      dec = false;
      s = 1;
    }
    else if (n[i] == '-') return -v;
    else {
      if (dec == false) {
        if (n[i] == '0') z += 1;
        else {
          float p;
          if (s == 1) p = 1;
          else {
            p = 1;
            for (int d=0; d!=(s-1); d+=1) {
              p = p * 10;
            }
          }
          t = (c_char_to_i(n[i]) * p);
          v += t;
          z = 0;
        }
      }
      else {
        float dc;
        dc=1;
        for (int d=0; d!=(i-dec_s); d+=1) dc = dc / 10;
        t = c_char_to_i(n[i]) * dc;
        v += t;
      }
      s+=1;
    }

  }



  return v;
}
