#include "cache.h"
#include "scenes.h"
#include "globals.h"
#include "mymath.h"
#include "mykeyboard.h"
#include "frames.h"
#include "drawfx.h"
#include "gui.h"
#include "map.h"
#include "hiscore.h"



ALLEGRO_BITMAP *hiscores_background;
ALLEGRO_BITMAP *hiscores_arrow;
ALLEGRO_BITMAP *hiscores_arrow_over;

std::string real_name;

bool LeftArrowOver=false;
bool RightArrowOver=false;

Map temp_map;

void LoadScoresMap() {
  real_name=GetRealMapName(GameLevels[ActualLevel]);
}

void GScene_HS::draw() {
  al_clear_to_color(al_map_rgb_f(0, 0, 0));


  DRAW_TRANSFORMED(hiscores_background, SCREEN_W/2, SCREEN_H/2, SCREEN_W, SCREEN_H, 0, 0);


  score_font->Print("Best Times", RSW(100)+4, RSH(140)+4, al_map_rgb(0, 0, 0));
  score_font->Print("Best Scores", RSW(660)+4, RSH(140)+4, al_map_rgb(0, 0, 0));

  score_font->Print("Best Times", RSW(100), RSH(140));
  score_font->Print("Best Scores", RSW(660), RSH(140));

  score_font->Print(real_name, SCREEN_W/2-score_font->Width(real_name)/2+4, SCREEN_H-RSH(40)+4, al_map_rgb(0, 0, 0));
  score_font->Print(real_name, SCREEN_W/2-score_font->Width(real_name)/2, SCREEN_H-RSH(40));

  if (ActualLevel != 0) DRAW_TRANSFORMED((LeftArrowOver ? hiscores_arrow_over : hiscores_arrow), RSW(70), RSH(710), RSW(100), RSH(100), 0, 0);
  if (ActualLevel != MaximumAchievedLevel-1) DRAW_TRANSFORMED((RightArrowOver ? hiscores_arrow_over : hiscores_arrow), SCREEN_W-RSW(74), RSH(710), RSW(100), RSH(100), 0, ALLEGRO_FLIP_HORIZONTAL);

  int count=0;

  std::deque<HSTime> *l_1;
  l_1 = (std::deque<HSTime> *) hiscore_table.GetTimes()->get(GameLevels[ActualLevel]);
  if (l_1 != NULL) {
    for (std::deque<HSTime>::iterator it=l_1->begin(); it!=l_1->end(); it+=1) {
      int min;
      min = (int)(*it).v/60;
      hiscore_font->Print(ToString(count+1)+".", RSW(30)+2, RSH(200)+(hiscore_font->Height()+3)*count+2, al_map_rgb(0,0,0));
      hiscore_font->Print((*it).name, RSW(70)+2, RSH(200)+(hiscore_font->Height()+3)*count+2, al_map_rgb(0,0,0));
      hiscore_font->Print(ToString(min) + ":" + ToString((*it).v - (min*60)), RSW(340)+2, RSH(200)+(hiscore_font->Height()+3)*count+2, al_map_rgb(0,0,0));

      hiscore_font->Print(ToString(count+1)+".", RSW(30), RSH(200)+(hiscore_font->Height()+3)*count);
      hiscore_font->Print((*it).name, RSW(70), RSH(200)+(hiscore_font->Height()+3)*count);
      hiscore_font->Print(ToString(min) + ":" + ToString((*it).v - (min*60)), RSW(340), RSH(200)+(hiscore_font->Height()+3)*count);
      count+=1;
      if (count == 10) break;
    }
  }



  std::deque<HSScore> *l_2;
  l_2 = (std::deque<HSScore> *) hiscore_table.GetScores()->get(GameLevels[ActualLevel]);

  count=0;
  if (l_2 != NULL) {
    for (std::deque<HSScore>::iterator it=l_2->begin(); it!=l_2->end(); it+=1) {

      hiscore_font->Print(ToString(count+1)+".", RSW(600)+2, RSH(200)+(hiscore_font->Height()+3)*count+2, al_map_rgb(0,0,0));
      hiscore_font->Print((*it).name, RSW(640)+2, RSH(200)+(hiscore_font->Height()+3)*count+2, al_map_rgb(0,0,0));
      hiscore_font->Print(ToString((*it).v), RSW(900)+2, RSH(200)+(hiscore_font->Height()+3)*count+2, al_map_rgb(0,0,0));


      hiscore_font->Print(ToString(count+1)+".", RSW(600), RSH(200)+(hiscore_font->Height()+3)*count);
      hiscore_font->Print((*it).name, RSW(640), RSH(200)+(hiscore_font->Height()+3)*count);
      hiscore_font->Print(ToString((*it).v), RSW(900), RSH(200)+(hiscore_font->Height()+3)*count);
      count+=1;
      if (count == 10) break;
    }
  }


  if (BlackFade != 0) {
    al_draw_filled_rectangle(0, 0, SCREEN_W, SCREEN_H, al_map_rgba_f(0, 0, 0, BlackFade));
  }

  float rw, rh;
  rw = RSW(al_get_bitmap_width(cursor));
  rh = RSH(al_get_bitmap_height(cursor));

  Vec2D last_pos;
  last_pos = Vec2D(mick_x, mick_y);
  DrawTransformedMotionBlur(cursor, mouse_x+rw/2, mouse_y+rh/2, rw, rh, 0, 0, last_pos);

  al_flip_display();
}




void GScene_HS::update() {
  cursor = cursor_normal;

  UpdateGlobalZoomFactor();
  poll_my_keyboard();
  UpdateDelta();
  BlackFade += BlackFadeDir*DeltaTime;
  if (BlackFade < 0) BlackFade=0;
  if (BlackFade > 1) BlackFade=1;

  if (Keyboard_Recently_Input[ALLEGRO_KEY_ESCAPE]) Scene = SCENE_MENU;

  LeftArrowOver=false;
  RightArrowOver=false;

  if (inside_rect(mouse_x, mouse_y, SCREEN_W-RSW(128), RSH(670), SCREEN_W-RSW(28), RSH(768))) RightArrowOver=true;
  if (inside_rect(mouse_x, mouse_y, RSW(16), RSH(670), RSW(116), RSH(768))) LeftArrowOver=true;

  if (Keyboard_Recently_Input[ALLEGRO_KEY_MOUSE_LCLICK]) {
    if (LeftArrowOver) {
      ActualLevel-=1;
      if (ActualLevel < 0) ActualLevel=0;
      LoadScoresMap();
    }
    if (RightArrowOver) {
      ActualLevel+=1;
      if (ActualLevel >= MaximumAchievedLevel) ActualLevel=MaximumAchievedLevel-1;
      LoadScoresMap();
    }
  }


  FramesUpdated+=1;\
}
bool HiscoresCreated=0;

void create_hiscores() {
  if (HiscoresCreated) return;
  HiscoresCreated=1;
  hiscores_background = al_load_bitmap("Graphics/GUI/HiscoresBackground.png");
  hiscores_arrow = al_load_bitmap("Graphics/GUI/HiscoresArrow.png");
  hiscores_arrow_over = al_load_bitmap("Graphics/GUI/HiscoresArrowOver.png");
}


void GScene_HS::main() {
  ChangeGlobalMusic(music_hiscores);

  ActualLevel=0;
  BlackFadeDir = -0.02;
  LoadScoresMap();

  create_hiscores();
  al_start_timer(timer);
  ResetDelta();
  update();
  while (Scene == SCENE_HISCORES) {
    ALLEGRO_EVENT event;
    al_wait_for_event(queue, &event);
    if (event.type == ALLEGRO_EVENT_TIMER) {
      draw();
      update();
    }
  }
}
