
/*
  Elven Revolution  V 0.9

  Version Date: 22/12/09

  Coded by dario ff
*/




// Allegro
#include "alleginit.h"
// Misc
#include <stdio.h>
#include <stdlib.h>
#include "string.h"
#include <time.h>
#include "frames.h"
#include "globals.h"
#include "scenes.h"
#include "mykeyboard.h"
#include "cache.h"
#include "mymath.h"
#include "log.h"

#include "allegroincludes.h"

#include "allegro5/allegro5.h"
#include <allegro5/allegro_opengl.h>
#include <allegro5/allegro_direct3d.h>
#include <allegro5/allegro_native_dialog.h>
#include <allegro5/allegro_primitives.h>
#include "allegro5/allegro_audio.h"



GScene_Game *scene_game;
GScene_Menu *scene_menu;
GScene_HS *scene_hs;
GScene_End *scene_end;



int main(int argc, char *argv[]) {

   global_log = new LogFileClass("gamelog.txt");
   global_log->LogMessage("Log created.");

   srand(time(0));
   init_alleg_constants();
   global_log->LogMessage("Started Allegro.");
   init_mapping();
   global_log->LogMessage("Keyboard Started.");

   Scene = SCENE_MENU;

   scene_game = new GScene_Game();
   scene_menu = new GScene_Menu();
   scene_hs   = new GScene_HS();
   scene_end  = new GScene_End();

   global_log->LogMessage("Game Scene created.");


   while (Scene != -1) {
     if (Scene == SCENE_GAME) scene_game->main();
     if (Scene == SCENE_MENU) scene_menu->main();
     if (Scene == SCENE_HISCORES) scene_hs->main();
     if (Scene == SCENE_END) scene_end->main();
   }

   global_log->LogMessage("No scene. Closing Application.");

   clear_all_cache();
   close_alleg_constants();

   global_log->LogMessage("Exit. Have a good day :)");
   delete global_log;
   return 0;
}

END_OF_MAIN()
