#include "globals.h"
#include "mystr.h"
#include "mymath.h"
#include "powers.h"
#include "screenfx.h"
#include "particle.h"


#include <iostream>
#include <fstream>


using namespace std;


ALLEGRO_EVENT_QUEUE *queue;
ALLEGRO_TIMER *timer;

ALLEGRO_SAMPLE *global_music=NULL;

ALLEGRO_SAMPLE *hit[6];
ALLEGRO_SAMPLE *chalk[2];
ALLEGRO_SAMPLE *cough[4];
ALLEGRO_SAMPLE *next_appear;

ALLEGRO_BITMAP *help_pages[HELP_SCREENS];

ALLEGRO_AUDIO_STREAM *riot;


ALLEGRO_SAMPLE_ID actual_music_id;

ALLEGRO_SAMPLE *music_menu;
ALLEGRO_SAMPLE *music_game;
ALLEGRO_SAMPLE *music_hiscores;
ALLEGRO_SAMPLE *music_end;
ALLEGRO_SAMPLE *hoho[HOHO_SIZE];


ALLEGRO_BITMAP *cursor;
ALLEGRO_BITMAP *cursor_normal;
ALLEGRO_BITMAP *cursor_bucket;
ALLEGRO_BITMAP *cursor_walk;
ALLEGRO_BITMAP *cursor_attack;
ALLEGRO_BITMAP *cursor_power[4];
ALLEGRO_BITMAP *cursor_hand;

ALLEGRO_BITMAP *collision_bit;
ALLEGRO_BITMAP *collision2_bit;
ALLEGRO_BITMAP *selected_bit;
ALLEGRO_BITMAP *selected_enemy_bit;
ALLEGRO_BITMAP *selected_coward_bit;
ALLEGRO_BITMAP *right_border;
ALLEGRO_BITMAP *right_border_top;
ALLEGRO_BITMAP *low_border;
ALLEGRO_BITMAP *snow_bit;


ALLEGRO_BITMAP *help_bit;
ALLEGRO_BITMAP *storyboard_bit;
ALLEGRO_BITMAP *briefing_bit;


ALLEGRO_BITMAP *torch;
ALLEGRO_BITMAP *remark_button;
ALLEGRO_BITMAP *remark_portrait;
ALLEGRO_BITMAP *powers[12];
ALLEGRO_BITMAP *spawns[SPAWNS_SIZE];
ALLEGRO_BITMAP *lights[LIGHTS_SIZE];

ALLEGRO_BITMAP *mission_complete_bit;
ALLEGRO_BITMAP *mission_failed_bit;
ALLEGRO_BITMAP *score_table_bit;
ALLEGRO_BITMAP *results_next;
ALLEGRO_BITMAP *results_next_on;

bool Music=1;

ALLEGRO_BITMAP *loading_bit;


bool DynamicLighting=1;
bool MotionBlur=1;
bool Shadows=1;
bool DebugMode=0;


int ActualLevel;
int MaximumAchievedLevel;


std::string GameLevels[GAME_LEVELS] = {"Level1", "Level2", "Level3", "Level4", "Level5", "Level6", "Level7", "Level8"};



std::string UserName;



int Scene;
int Pause=0;
int FirstMap=1;
int Fade=-1;
int FadeSpeed=0;
char null_str[] = "";
int BPP = 16;

int DelayAfterDoubleClick=0;


int Night=0;

int BlackScreen=255;


void Savegame() {
  ofstream myfile;
  myfile.open ("savegame.dat", ios::out | ios::binary);
  myfile.write(reinterpret_cast<char *>(&MaximumAchievedLevel), sizeof(int));
  myfile.close();
}

void LoadSavegame() {
  MaximumAchievedLevel = 1;
  if (al_filename_exists("savegame.dat")) {
    ifstream myfile;
    myfile.open ("savegame.dat", ios::in | ios::binary);
    myfile.read(reinterpret_cast<char *>(&MaximumAchievedLevel), sizeof(int));
    myfile.close();
  }
  else {
    Savegame();
  }
}


void LoadGlobalResources() {

  loading_bit = al_load_bitmap("Graphics/GUI/Loading.png");
  DrawLoadingScreen();

  cursor_normal = al_load_bitmap("Graphics/Cursor/Normal.png");
  cursor_bucket = al_load_bitmap("Graphics/Cursor/Bucket.png");
  cursor_walk = al_load_bitmap("Graphics/Cursor/Walk.png");
  cursor_attack = al_load_bitmap("Graphics/Cursor/Attack.png");
  cursor_power[0] = al_load_bitmap("Graphics/Cursor/Flash.png");
  cursor_power[1] = al_load_bitmap("Graphics/Cursor/Smoke.png");
  cursor_power[2] = al_load_bitmap("Graphics/Cursor/Gift.png");
  cursor_power[3] = al_load_bitmap("Graphics/Cursor/Santa.png");
  cursor_hand = al_load_bitmap("Graphics/Cursor/Hand.png");

  selected_bit = al_load_bitmap("Graphics/GUI/Selected.png");
  selected_enemy_bit = al_load_bitmap("Graphics/GUI/SelectedEnemy.png");
  selected_coward_bit = al_load_bitmap("Graphics/GUI/SelectedCoward.png");
  collision_bit = al_load_bitmap("Graphics/GUI/Collision.png");
  collision2_bit = al_load_bitmap("Graphics/GUI/Collision2.png");
  right_border = al_load_bitmap("Graphics/GUI/RightBorder.png");
  right_border_top = al_load_bitmap("Graphics/GUI/RightBorderTop.png");
  low_border = al_load_bitmap("Graphics/GUI/Tooltip.png");
  results_next = al_load_bitmap("Graphics/GUI/ResultsNext.png");
  results_next_on = al_load_bitmap("Graphics/GUI/ResultsNextOn.png");

  storyboard_bit = al_load_bitmap("Graphics/GUI/Storyboard.png");
  briefing_bit = al_load_bitmap("Graphics/GUI/Briefing.png");
  help_bit = al_load_bitmap("Graphics/GUI/Help.png");

  snow_bit = al_load_bitmap("Graphics/Snow.png");


  hit[0] = al_load_sample("Sounds/Hit1.ogg");
  hit[1] = al_load_sample("Sounds/Hit2.ogg");
  hit[2] = al_load_sample("Sounds/Hit3.ogg");
  hit[3] = al_load_sample("Sounds/Hit4.ogg");
  hit[4] = al_load_sample("Sounds/Hit5.ogg");
  hit[5] = al_load_sample("Sounds/Hit6.ogg");

  cough[0] = al_load_sample("Sounds/Cough1.ogg");
  cough[1] = al_load_sample("Sounds/Cough2.ogg");
  cough[2] = al_load_sample("Sounds/Cough3.ogg");
  cough[3] = al_load_sample("Sounds/Cough4.ogg");


  for (int i=0; i!=HOHO_SIZE; i+=1) {
    hoho[i] = al_load_sample(("Sounds/Hoho_"+ToString(i+1)+".ogg").c_str());
  }

  music_game = al_load_sample("Sounds/Track1.ogg");
  music_menu = al_load_sample("Sounds/Track2.ogg");
  music_hiscores = al_load_sample("Sounds/Track3.ogg");
  music_end = al_load_sample("Sounds/Track4.ogg");


  chalk[0] = al_load_sample("Sounds/Chalk1.ogg");
  chalk[1] = al_load_sample("Sounds/Chalk2.ogg");

  next_appear = al_load_sample("Sounds/NextAppear.ogg");

  riot = al_load_audio_stream("Sounds/Riot.ogg", 2, 22100);
  al_attach_audio_stream_to_mixer(riot, mixer);
  al_set_audio_stream_gain(riot, 0);


  for (int i=0;i!=SPAWNS_SIZE; i+=1) {
    spawns[i] = al_load_bitmap(("Graphics/GUI/Spawns/" + ToString(i) + ".png").c_str());
  }

  for (int i=0;i!=HELP_SCREENS; i+=1) {
    help_pages[i] = al_load_bitmap(("Graphics/GUI/Help_" + ToString(i+1) + ".png").c_str());
  }

  lights[0] = al_load_bitmap("Graphics/Lights/Torch01.png");
  lights[1] = al_load_bitmap("Graphics/Lights/Twinkle01.png");
  lights[2] = al_load_bitmap("Graphics/Lights/Twinkle02.png");
  lights[3] = al_load_bitmap("Graphics/Lights/Twinkle03.png");
  lights[4] = al_load_bitmap("Graphics/Lights/Twinkle04.png");
  lights[5] = al_load_bitmap("Graphics/Lights/Twinkle05.png");
  lights[6] = al_load_bitmap("Graphics/Lights/Twinkle06.png");
  lights[7] = al_load_bitmap("Graphics/Lights/Twinkle07.png");


  powers[0] = al_load_bitmap("Graphics/GUI/Powers/Flash.png");
  powers[1] = al_load_bitmap("Graphics/GUI/Powers/FlashOver.png");
  powers[2] = al_load_bitmap("Graphics/GUI/Powers/FlashNo.png");
  powers[3] = al_load_bitmap("Graphics/GUI/Powers/Smoke.png");
  powers[4] = al_load_bitmap("Graphics/GUI/Powers/SmokeOver.png");
  powers[5] = al_load_bitmap("Graphics/GUI/Powers/SmokeNo.png");
  powers[6] = al_load_bitmap("Graphics/GUI/Powers/Spawn.png");
  powers[7] = al_load_bitmap("Graphics/GUI/Powers/SpawnOver.png");
  powers[8] = al_load_bitmap("Graphics/GUI/Powers/SpawnNo.png");
  powers[9] = al_load_bitmap("Graphics/GUI/Powers/Santa.png");
  powers[10] = al_load_bitmap("Graphics/GUI/Powers/SantaOver.png");
  powers[11] = al_load_bitmap("Graphics/GUI/Powers/SantaNo.png");

  remark_button = al_load_bitmap("Graphics/GUI/Remark.png");
  remark_portrait = al_load_bitmap("Graphics/GUI/PortraitRemark.png");

  torch = al_load_bitmap("Graphics/Lights/Torch01.png");

  mission_complete_bit = al_load_bitmap("Graphics/GUI/MissionComplete.png");
  mission_failed_bit = al_load_bitmap("Graphics/GUI/MissionFailed.png");

  score_table_bit = al_load_bitmap("Graphics/GUI/ScoreTable.png");

  ActualLevel=0;
  MaximumAchievedLevel=1;

  LoadPowersResources();
  load_game_fonts();
  LoadScreenFX();
  LoadParticles();
}


int al_get_config_int(ALLEGRO_CONFIG *cfg, char *section, char *name, int def) {
  const char *str;
  str = al_get_config_value(cfg, section, name);
  if (str != NULL) return ToFloat(ToString(str));
  else return def;
}


const char *al_get_config_str(ALLEGRO_CONFIG *cfg, char *section, char *name, char *def) {
  const char *str;
  str = al_get_config_value(cfg, section, name);
  if (str != NULL) return str;
  else return def;
}


float al_get_config_float(ALLEGRO_CONFIG *cfg, char *section, char *name, float def) {
  const char *str;
  str = al_get_config_value(cfg, section, name);
  if (str != NULL) return ToFloat(ToString(str));
  else return def;
}

void DrawLoadingScreen() {
  al_clear_to_color(al_map_rgb_f(0, 0, 0));
  float rw, rh;
  rw=RSW(al_get_bitmap_width(loading_bit));
  rh=RSH(al_get_bitmap_height(loading_bit));
  DRAW_TRANSFORMED(loading_bit, SCREEN_W-rw/2, SCREEN_H-rh/2, rw, rh, 0, 0);
  al_flip_display();
}

void ChangeGlobalMusic(ALLEGRO_SAMPLE *ms) {
  if (!Music) return;
  if (global_music != ms) {
    global_music = ms;
    al_stop_sample(&actual_music_id);
    al_play_sample(global_music, 1.2, 0.5, 1.0, ALLEGRO_PLAYMODE_LOOP, &actual_music_id);
  }
}
