
#include "fonts.h"
#include "mymath.h"


GameFont *game_font;
GameFont *score_font;
GameFont *hiscore_font;

GameFont::GameFont(const char *filename, float h, ALLEGRO_COLOR col) {
  fgk = al_load_font(filename, h, ALLEGRO_TTF_NO_KERNING);
  height = h;
  color = col;
}

void load_game_fonts() {
  game_font = new GameFont("Fonts/GameFont.ttf",RSH(18), al_map_rgb(255, 255, 255));
  score_font = new GameFont("Fonts/ScoreFont.ttf",RSH(48), al_map_rgb(255, 255, 255));
  hiscore_font = new GameFont("Fonts/ScoreFont.ttf",RSH(34), al_map_rgb(255, 255, 255));
}


void GameFont::PrintColorCoded(const std::string &text, int x, int baselineY) {
    std::string t_text;
    int w, ind;
    char c;
    w=0; t_text="";
    for (ind=0; ind!=text.size(); ind+=1) {
      c = text[ind];
      if (c == '~') {
        Print(t_text, x+w, baselineY);
        w+=Width(t_text);
        t_text = "";
        ind+=1;
        c = text[ind];
        al_set_blender(ALLEGRO_ALPHA, ALLEGRO_INVERSE_ALPHA, char_to_color(c));
      }
      else {
        t_text += c;
      }


    al_set_blender(ALLEGRO_ALPHA, ALLEGRO_INVERSE_ALPHA, al_map_rgb(255, 255, 255));
    Print(t_text, x+w, baselineY);
  }
}

void GameFont::Print(const std::string &text, int x, int baselineY, ALLEGRO_COLOR col, char mode) {
  if (mode == PRINT_MODE_OUTLINE) {
    al_set_blender(ALLEGRO_ALPHA, ALLEGRO_INVERSE_ALPHA, al_map_rgb(0, 0, 0));
    Print(text, x-1, baselineY);
    Print(text, x, baselineY-1);
    Print(text, x, baselineY+1);
    Print(text, x+1, baselineY);
  }

  al_set_blender(ALLEGRO_ALPHA, ALLEGRO_INVERSE_ALPHA, col);
  Print(text, x, baselineY);
  al_set_blender(ALLEGRO_ALPHA, ALLEGRO_INVERSE_ALPHA, al_map_rgb(255, 255, 255));
}
