
#include "globals.h"
#include "map.h"
#include "mykeyboard.h"
#include "mymath.h"


#define SCROLLING_SPEED    14


float Camera_X, Camera_Y, Camera_Boundary_X, Camera_Boundary_Y;


int MoveCameraX=0;
int MoveCameraY=0;

float TargetCamera_X;
float TargetCamera_Y;

int MoveCameraFrames=0;

int ShakeCameraX=0;
int ShakeCameraY=0;
int ShakeDirection=0;
int ShakeFrames=0;


void update_camera() {
  int sx, sy, lx, ly, mcf;
  sx=0;
  sy=0;
  lx = Camera_Boundary_X+RSW(180);
  ly = Camera_Boundary_Y;

  if (TargetCamera_X != Camera_X) Camera_X += (TargetCamera_X-Camera_X)/8;
  if (TargetCamera_Y != Camera_Y) Camera_Y += (TargetCamera_Y-Camera_Y)/8;

  if ((mabs(TargetCamera_X-Camera_X) < 1)) TargetCamera_X=Camera_X;
  if ((mabs(TargetCamera_Y-Camera_Y) < 1)) TargetCamera_Y=Camera_Y;

  if (Camera_X < sx) Camera_X = sx;
  if (Camera_X > lx) Camera_X = lx;
  if (Camera_Y < sy) Camera_Y = sy;
  if (Camera_Y > ly) Camera_Y = ly;

  if (TargetCamera_X < sx) TargetCamera_X = sx;
  if (TargetCamera_X > lx) TargetCamera_X = lx;
  if (TargetCamera_Y < sy) TargetCamera_Y = sy;
  if (TargetCamera_Y > ly) TargetCamera_Y = ly;
}


void center_camera(int x, int y) {
  TargetCamera_X = x-1024/2;
  TargetCamera_X = y-768/2;
}

void update_key_camera() {
  bool turbo;
  turbo = al_key_down(&keyb, ALLEGRO_KEY_LSHIFT);
  if ((al_key_down(&keyb, ALLEGRO_KEY_LEFT))  || (mouse_x <= 2))  TargetCamera_X -= (SCROLLING_SPEED+(turbo ? SCROLLING_SPEED *3 : 0)) * DeltaTime;
  if ((al_key_down(&keyb, ALLEGRO_KEY_RIGHT)) || (mouse_x >= SCREEN_W-3)) TargetCamera_X += (SCROLLING_SPEED+(turbo ? SCROLLING_SPEED *3 : 0)) * DeltaTime;
  if ((al_key_down(&keyb, ALLEGRO_KEY_UP))    || (mouse_y <= 3))    TargetCamera_Y -= (SCROLLING_SPEED+(turbo ? SCROLLING_SPEED *3 : 0)) * DeltaTime;
  if ((al_key_down(&keyb, ALLEGRO_KEY_DOWN))  || (mouse_y >= SCREEN_H-2))  TargetCamera_Y += (SCROLLING_SPEED+(turbo ? SCROLLING_SPEED *3 : 0)) * DeltaTime;

}
