
#include "allegro5/allegro5.h"
#include "allegro5/allegro_image.h"
#include <allegro5/allegro_opengl.h>
#include <allegro5/allegro_direct3d.h>
#include <allegro5/allegro_native_dialog.h>
#include <allegro5/allegro_primitives.h>
#include "allegro5/allegro_audio.h"
#include <string>


#ifndef CACHE_H_INCLUDED
#define CACHE_H_INCLUDED

#define LOAD_BITMAP                 0


extern ALLEGRO_VOICE *voice;
extern ALLEGRO_MIXER *mixer;

class CacheBitmap {
  private:
    ALLEGRO_BITMAP *bit;
    ALLEGRO_BITMAP *red_bit;
    ALLEGRO_BITMAP *downsized;
    std::string name;
    CacheBitmap *next;
  public:
    CacheBitmap(){red_bit=NULL;downsized=NULL;}
    void reset(){}
    CacheBitmap *get_next(){return next;}
    void set_next(CacheBitmap *n) {next = n;}
    void set_name(std::string n) {name=n;}
    std::string get_name(){return name;}
    ALLEGRO_BITMAP *get_bit(){return bit;}
    void set_bit(ALLEGRO_BITMAP *b){bit = b;}

    ALLEGRO_BITMAP *get_red_bit();

    int Width() {return al_get_bitmap_width(bit);}
    int Height() {return al_get_bitmap_height(bit);}
};

class CacheSample {
  protected:
    ALLEGRO_SAMPLE *samp;
    ALLEGRO_SAMPLE_INSTANCE *samp_ins;
    std::string name;
    CacheSample *next;
  public:
    CacheSample() {
      samp_ins = al_create_sample_instance(NULL);
    }
    CacheSample *get_next(){return next;}
    void set_next(CacheSample *n) {next = n;}
    void set_name(std::string n) {name=n;}
    std::string get_name(){return name;}
    void set_sample(ALLEGRO_SAMPLE *s) {
      samp = s;
      al_set_sample(samp_ins, s);
      al_attach_sample_to_mixer(samp_ins, mixer);
    }
    ALLEGRO_SAMPLE *get_sample(){return samp;}
};

extern CacheBitmap *Cache_List;
CacheBitmap *load_cache_bitmap(std::string filename);
void delete_CacheBitmap(CacheBitmap *tCacheBitmap);


extern CacheSample *CacheSample_List;
CacheSample *load_cache_sample(std::string filename);
void delete_CacheSample(CacheSample *tCacheSample);


void clear_all_cache();

#endif
