
#include "cache.h"
#include "string.h"
#include "mystr.h"
#include "globals.h"
#include "object.h"

ALLEGRO_VOICE *voice;
ALLEGRO_MIXER *mixer;


CacheBitmap *Cache_List=NULL;


CacheBitmap *load_cache_bitmap(std::string filename) {
  if (filename == "NONE") return NULL;

  CacheBitmap *iter, *tCacheBitmap;
  const char *c_f;
  char fln[128];
  int b;
  int ind;
  b = 1;
  if (Cache_List != NULL) {
    for (iter = Cache_List; iter->get_next(); iter = iter->get_next()) {
      if (filename==iter->get_name()) {
        b = 0;
        tCacheBitmap = iter;
      }
    }
  }
  if (b) {
    tCacheBitmap = new CacheBitmap();
    tCacheBitmap->reset();
    tCacheBitmap->set_next(NULL);
    c_f = filename.c_str();
    if (!al_filename_exists(c_f)) {
      AL_MESSAGE(ToString("There is no " + filename + " on the disk.").c_str());
    }
    tCacheBitmap->set_name(filename);
    tCacheBitmap->set_bit(al_load_bitmap(filename.c_str()));


    if (Cache_List == NULL) {
      Cache_List = tCacheBitmap;
    }
    else {
      for (iter = Cache_List; iter->get_next(); iter = iter->get_next());
      iter->set_next(tCacheBitmap);
    }
   }
   return tCacheBitmap;
}

ALLEGRO_BITMAP *CacheBitmap::get_red_bit() {
  if (red_bit == NULL) {
    red_bit = al_create_bitmap(Width(), Height());
    DRAWTO(red_bit);
    al_draw_bitmap(bit, 0, 0, 0);
    COLOR_BLEND(al_map_rgba_f(1.0, 0.0, 0.0, 1.0));
    al_draw_bitmap(bit, 0, 0, 0);
    DRAWNORMAL;
  }

  return red_bit;
}


void delete_CacheBitmap(CacheBitmap *tCacheBitmap)
{
   int freed, ind, b;
   CacheBitmap *iter;
   /* special treatment for head */
   freed = 1;
   if (tCacheBitmap != NULL) {
   b=0;
   if (Cache_List != NULL) {
    for (iter = Cache_List; iter->get_next(); iter = iter->get_next()) {
      if (tCacheBitmap->get_name()==iter->get_name()) {
        b=1;
        break;
      }
    }
  }
  if (b) {
   al_destroy_bitmap(tCacheBitmap->get_bit());
   if (tCacheBitmap == Cache_List) {
      Cache_List = tCacheBitmap->get_next();
      delete tCacheBitmap;
   }
   else {
      for (iter = Cache_List; iter->get_next() != tCacheBitmap; iter = iter->get_next()) ;
      iter->set_next(tCacheBitmap->get_next());
      delete tCacheBitmap;
   }
  }
 }
}





CacheSample *CacheSample_List=NULL;


CacheSample *load_cache_sample(std::string filename) {
  CacheSample *iter, *tCacheSample;
  const char *c_f;
  char fln[128];
  int b;
  int ind;
  b = 1;
  if (CacheSample_List != NULL) {
    for (iter = CacheSample_List; iter->get_next(); iter = iter->get_next()) {
      if (filename==iter->get_name()) {
        b = 0;
        tCacheSample = iter;
      }
    }
  }
  if (b) {
    tCacheSample = new CacheSample();
    tCacheSample->set_next(NULL);
    c_f = filename.c_str();
    if (!al_filename_exists(c_f)) {
      AL_MESSAGE(ToString("There is no " + filename + " on the disk.").c_str());
    }
    tCacheSample->set_name(filename);
    tCacheSample->set_sample(al_load_sample(filename.c_str()));

    if (CacheSample_List == NULL) {
      CacheSample_List = tCacheSample;
    }
    else {
      for (iter = CacheSample_List; iter->get_next(); iter = iter->get_next());
      iter->set_next(tCacheSample);
    }
   }
   return tCacheSample;
}

void delete_CacheSample(CacheSample *tCacheSample)
{
   int freed, ind, b;
   CacheSample *iter;
   /* special treatment for head */
   freed = 1;
   if (tCacheSample != NULL) {
   b=0;
   if (CacheSample_List != NULL) {
    for (iter = CacheSample_List; iter->get_next(); iter = iter->get_next()) {
      if (tCacheSample->get_name()==iter->get_name()) {
        b=1;
        break;
      }
    }
  }
  if (b) {
   if (tCacheSample == CacheSample_List) {
      CacheSample_List = tCacheSample->get_next();
      delete tCacheSample;
   }
   else {
      for (iter = CacheSample_List; iter->get_next() != tCacheSample; iter = iter->get_next()) ;
      iter->set_next(tCacheSample->get_next());
      delete tCacheSample;
   }
  }
 }
}


void clear_all_cache() {
}




