#include "cache.h"
#include <vector>


#ifndef ANSPRITE_H_INCLUDED
#define ANSPRITE_H_INCLUDED


class AnimatedSprite {
  public:
    std::string path;
    int animation_limit;
    float frame, animation_speed;
    bool raf, finish;
    float opacity;
    int loaded;

    bool loop;

    std::vector<CacheBitmap *> bits;

    std::string act_charname;

    CacheBitmap *act;


    float frame_dir;

    void Reset();

    void Load(std::string p);

    CacheBitmap *GetActualBitmap(){return act;}
    void GenerateActualCharname();

    void ChooseActualBitmap();

    void Update();

    void Copy(AnimatedSprite *an);

    bool Finished() {
      return finish;
    }

    void Clear() {
      path.clear();
      act_charname.clear();
      bits.clear();
    }

    ~AnimatedSprite();
};


#endif
