#include "alleginit.h"
#include "mymath.h"
#include "globals.h"
#include "cache.h"

#include "allegro5/allegro5.h"
#include <allegro5/allegro_opengl.h>
#include "allegro5/allegro_image.h"
#include <allegro5/allegro_direct3d.h>
#include <allegro5/allegro_native_dialog.h>
#include <allegro5/allegro_primitives.h>
#include <allegro5/allegro_font.h>
#include <allegro5/allegro_ttf.h>
#include "allegro5/allegro_audio.h"
#include "allegro5/allegro_vorbis.h"

#include "hiscore.h"


int RES_W, RES_H;
int ALLEGRO_SETUP=0;

ALLEGRO_DISPLAY *display;

void init_alleg_constants() {
   float x, y, z;
   float sx, sy;

   al_init();
   ALLEGRO_CONFIG *config;


   config = al_load_config_file("Settings.ini");

   Music = ToFloat(al_get_config_value(config, "Audio", "Music"));

   Shadows = ToFloat(al_get_config_value(config, "Video", "Shadows"));
   DynamicLighting = ToFloat(al_get_config_value(config, "Video", "DynamicLighting"));
   MotionBlur = ToFloat(al_get_config_value(config, "Video", "MotionBlur"));
   DebugMode = ToFloat(al_get_config_value(config, "Player", "DebugMode"));

   if (ToFloat(al_get_config_value(config, "Display", "FirstRun")) == 1) {
     al_set_config_value(config, "Display", "FirstRun", "0");

     display = al_create_display(320, 200);
     al_reset_new_display_options();
     int n = al_get_num_display_formats();

     AL_MESSAGE(ToString(n).c_str());

     ALLEGRO_DISPLAY_MODE displaymode;
     int best_w, best_h;
     best_w = 0; best_h = 0;
     for (int i = 0; i < n; i++) {
       al_get_display_mode(i, &displaymode);
       if ((displaymode.width >= best_w) && (displaymode.height >= best_h)) {
         best_w = displaymode.width;
         best_h = displaymode.height;
         AL_MESSAGE((ToString(best_w) + ", " + ToString(best_h)).c_str());
       }
     }

     al_set_config_value(config, "Display", "Width", ToString(best_w).c_str());
     al_set_config_value(config, "Display", "Height", ToString(best_h).c_str());

     al_destroy_display(display);

     al_save_config_file(config, "Settings.ini");
     config = al_load_config_file("Settings.ini");
   }

   RES_W = 1024;
   RES_H = 768;


   RES_W = ToFloat(al_get_config_value(config, "Display", "Width"));
   RES_H = ToFloat(al_get_config_value(config, "Display", "Height"));


   GlobalAspectRatio = ToFloat(al_get_config_value(config, "Display", "AspectRatio"));

   int md;
   if (ToFloat(al_get_config_value(config, "Display", "Windowed"))) md = 1;
   else md = 0;




   al_install_mouse();
   al_install_keyboard();
   al_install_audio(ALLEGRO_AUDIO_DRIVER_AUTODETECT);
   al_init_image_addon();
   al_init_font_addon();
   al_init_ttf_addon();
   al_init_ogg_vorbis_addon();
   al_reserve_samples(16);

   ALLEGRO_BITMAP *shadow_buffer;

   char *buffer;
   buffer = (char *) al_get_config_value(config, "Display", "Driver");
   if (ToString(buffer) == "D3D") {
     al_set_new_display_flags(ALLEGRO_DIRECT3D);
   }
   else al_set_new_display_flags(ALLEGRO_OPENGL);


   voice = al_create_voice(44100, ALLEGRO_AUDIO_DEPTH_INT16,ALLEGRO_CHANNEL_CONF_2);
   mixer = al_create_mixer(44100, ALLEGRO_AUDIO_DEPTH_FLOAT32, ALLEGRO_CHANNEL_CONF_2);
   al_attach_mixer_to_voice(mixer, voice);

   if (md) al_set_new_display_flags(ALLEGRO_WINDOWED);
   else {
     al_set_new_display_flags(ALLEGRO_FULLSCREEN);
   }
   al_set_new_display_option(ALLEGRO_VSYNC, 1, ALLEGRO_REQUIRE);


   display = al_create_display(RES_W, RES_H);
   if (!display) {
     RES_W = 640; RES_H = 480; al_set_new_display_flags(ALLEGRO_WINDOWED);
     display = al_create_display(RES_W, RES_H);
     AL_MESSAGE("Requested Display couldn't be created, defaulting to 640x480 in Windowed Mode.");
   }
   al_hide_mouse_cursor();
   al_set_window_title("Elven Revolution");

   if (GlobalAspectRatio == -1) GlobalAspectRatio = (float)RES_W / (float)RES_H;

   float f = ToFloat(al_get_config_value(config, "Display", "FPS"));
   timer = al_install_timer(ALLEGRO_BPS_TO_SECS(f));
   queue = al_create_event_queue();
   al_register_event_source(queue, (ALLEGRO_EVENT_SOURCE *)timer);
   al_register_event_source(queue, (ALLEGRO_EVENT_SOURCE *)al_get_keyboard_event_source());

   LoadGlobalResources();

   al_set_new_bitmap_flags(ALLEGRO_NO_PRESERVE_TEXTURE);


   hiscore_table.Reset();
   if (al_filename_exists("Scores.dat")) hiscore_table.Load();

   UserName = ToString(al_get_config_value(config, "Player", "User"));

   LoadSavegame();

   ALLEGRO_SETUP = 1;
}



void close_alleg_constants() {
  //al_uninstall_audio();
}
