/*
##########################
#         FRUSTRATION         #
# Mensch ärgere dich nicht #
##########################

playable and winable

0-4 Player Game with easy AI


VERSION 1.00
made by AE
may, 2010
*/
/*
todo:
            make sound
*/

#include <allegro.h>
#include <time.h>
#include <stdio.h>

#include "mensch.h"
#include "game.h"
#include "turn.h"
#include "play.h"
#include "calc.h"
#include "rule.h"
#include "ai.h"

const int STATE_NEXT = 0;
const int STATE_PLAY_1 = 1;
const int STATE_PLAY_2 = 2;
const int STATE_PLAY_3 = 3;
const int STATE_PLAY_4 = 4;
const int STATE_MENU = 5;
const int STATE_GAME_OVER = 6;

BITMAP *doublebuffer = NULL;
BITMAP *spielfeld = NULL;
BITMAP *splfld = NULL;
BITMAP *ae = NULL;
BITMAP *btn_q = NULL;
BITMAP *btn_qu = NULL;
BITMAP *btn_ng = NULL;
BITMAP *btn_pl = NULL;
BITMAP *blue = NULL;
BITMAP *red = NULL;
BITMAP *green = NULL;
BITMAP *yellow = NULL;

BITMAP *red_tu = NULL;
BITMAP *blue_tu = NULL;
BITMAP *green_tu = NULL;
BITMAP *yellow_tu = NULL;
BITMAP *menu = NULL;
BITMAP *menu_ob = NULL;

BITMAP *pt[6];
char buffer[256];

DATAFILE *go_dat;
FONT *go_fnt;
DATAFILE *pl_dat;
FONT *old_font;

double version = 1;
int fs = 0;
int poss_tu = 0;
int pl_re = 0;
int pl_bl = 0;
int pl_gr = 0;
int pl_ye = 0;
int try_pt = 0;
int map_x = 0;
int map_y = 0;
int map_field = 40;
int map[40] = {0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0};
int map_beg[4][1] = {{4}, {4}, {4}, {4}};
int map_end[4][4] = {{0,0,0,0}, {0,0,0,0}, {0,0,0,0}, {0,0,0,0}};
int win[4] = {0,0,0,0};
int win_pl = 0;
int map_pl[4][4] = {{0,0,0,0}, {0,0,0,0}, {0,0,0,0}, {0,0,0,0}};
int player = 0;
int end_counter = -1;
int anz_pt = 0;
int old_anz = 0;
int old = 0;

// rnd - generates random number
int rnd(int n)  {
    return (int) (n * ((double)rand() / (double) (RAND_MAX + 1.0)));
}

// timerCounter - needed for FPS
volatile int timerCounter = 0;
static void timerCounterUpdater()  {
    timerCounter++;
}  END_OF_STATIC_FUNCTION(timerCounterUpdater)

// output of ERROR-messages (ex. load of bmp failed)
void fatalError(char *str)  {
    allegro_message(str);
    exit(0);
}

// set color depth
int setGfxMode(int mode, int width, int height)  {
    static int colorDepths[] = {16, 24, 15, 32};
    int a;
    for (a=0; a < 4; a++)  {
        set_color_depth(colorDepths[a]);
        if (set_gfx_mode(mode, width, height, 0, 0) >= 0)  {
            return 1;
        }
    }
    return 0;
}

// execute if new_game is started
void new_game()  {
    for (int a = 0; a < 40; a++)  {
        map[a] = 0;
    }
    for (int b = 0; b < 4; b++)  {
        win[b] = 0;
        map_beg[b][0] = 4;
        for (int c = 0; c < 4; c++)  {
            map_end[b][c] = 0;
            map_pl[b][c] = 0;
        }
    }
    player = 0;
    win_pl = 0;
}

// check every turn for a winner
void sieg()  {
    if (map_end[player][0] + map_end[player][1] + map_end[player][2] + map_end[player][3] == 4)  {
        win[player] = 1;
    }
    // show the winner, but only the first - dirty code but it works
    if (win[0] == 1 && win[1] != 1 && win[2] != 1 && win[3] != 1)  {
        win_pl = 1;
    }
    else if (win[0] != 1 && win[1] == 1 && win[2] != 1 && win[3] != 1)  {
        win_pl = 2;
    }
    else if (win[0] != 1 && win[1] != 1 && win[2] == 1 && win[3] != 1)  {
        win_pl = 3;
    }
    else if (win[0] != 1 && win[1] != 1 && win[2] != 1 && win[3] == 1)  {
        win_pl = 4;
    }
}

// check player positions
void wo_pl()  {
    pl_re = 0;
    pl_bl = 0;
    pl_gr = 0;
    pl_ye = 0;
    for (int a=0; a < 4; a++)  {
        map_pl[0][a] = 0;
        map_pl[1][a] = 0;
        map_pl[2][a] = 0;
        map_pl[3][a] = 0;
    }
    for (int a=0; a < 40; a++)  {
        if (map[a] == 1)  {
            map_pl[0][pl_re] = a+1;
            pl_re++;
        }
        else if (map[a] == 2)  {
            map_pl[1][pl_bl] = a+1;
            pl_bl++;
        }
        else if (map[a] == 3)  {
            map_pl[2][pl_gr] = a+1;
            pl_gr++;
        }
        else if (map[a] == 4)  {
            map_pl[3][pl_ye] = a+1;
            pl_ye++;
        }
    }
}

// show mouse and screen
void show()  {
    show_mouse(doublebuffer);
    blit(doublebuffer, screen, 0,0,0,0, doublebuffer->w, doublebuffer->h);
    vsync();
}

// show playground, pause_button, and player
void table()  {
    draw_sprite(doublebuffer, spielfeld, map_x, map_y);
    game();
    draw_trans_sprite(doublebuffer, btn_q, map_x + spielfeld->w - 110, map_y + spielfeld->h - 30);
}

// quit window if close is clicked
volatile int close_button_pressed = FALSE;
void close_button_handler(void)  {
    close_button_pressed = TRUE;
}  END_OF_FUNCTION(close_button_handler)

// init allegro, load bitmaps / fonts
void init() {
    srand(time(NULL));
    set_uformat(U_UTF8);
    go_dat = load_datafile("go.dat");
    go_fnt = (FONT*) go_dat[0].dat;
    pl_dat = load_datafile("pl.dat");
    old_font = font;
    font = (FONT*) pl_dat[0].dat;
    allegro_init();
    LOCK_FUNCTION(close_button_handler);
    set_close_button_callback(close_button_handler);
    if (fs == 1)  {
        if (!setGfxMode(GFX_AUTODETECT_FULLSCREEN, 640, 480))  {
            fs = 0;
            if (!setGfxMode(GFX_AUTODETECT_WINDOWED, 480, 480))  {
                fatalError("Unable to set a graphics mode");
            }
        }
    }
    else if (fs == 0)  {
        if (!setGfxMode(GFX_AUTODETECT_WINDOWED, 480, 480))  {
            fatalError("Unable to set a graphics mode");
        }
    }
    install_timer();
    install_keyboard();
    install_mouse();
    //install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
    doublebuffer = create_bitmap(SCREEN_W, SCREEN_H);
    if (!doublebuffer)  {
        fatalError("Unable to create double buffer");
    }
    spielfeld = load_bitmap("pics/spielfeld.tga", NULL);
    if (!spielfeld)  {
        fatalError("Unable to load map");
    }
    splfld = load_bitmap("pics/spielfld.tga", NULL);
    if (!splfld)  {
        fatalError("Unable to load map");
    }
    ae = load_bitmap("pics/made.tga", NULL);
    if (!ae)  {
        fatalError("Unable to load logo");
    }
    red = load_bitmap("pics/red.tga", NULL);
    if (!red)  {
        fatalError("Unable to load bitmap of player 1");
    }
    blue = load_bitmap("pics/blue.tga", NULL);
    if (!blue)  {
        fatalError("Unable to load bitmap of player 2");
    }
    green = load_bitmap("pics/green.tga", NULL);
    if (!green)  {
        fatalError("Unable to load bitmap of player 3");
    }
    yellow = load_bitmap("pics/yellow.tga", NULL);
    if (!yellow)  {
        fatalError("Unable to load bitmap of player 4");
    }
    btn_q = load_bitmap("pics/quit_btn.tga", NULL);
    if (!btn_q)  {
        fatalError("Unable to load bitmap");
    }
    btn_qu = load_bitmap("pics/btn_qu.tga", NULL);
    if (!btn_qu)  {
        fatalError("Unable to load bitmap");
    }
    btn_ng = load_bitmap("pics/btn_ng.tga", NULL);
    if (!btn_ng)  {
        fatalError("Unable to load bitmap");
    }
    btn_pl = load_bitmap("pics/btn_pl.tga", NULL);
    if (!btn_pl)  {
        fatalError("Unable to load bitmap");
    }
    red_tu = load_bitmap("pics/red_tu.tga", NULL);
    if (!red_tu)  {
        fatalError("Unable to load bitmap");
    }
    blue_tu = load_bitmap("pics/blue_tu.tga", NULL);
    if (!blue_tu)  {
        fatalError("Unable to load bitmap");
    }
    green_tu = load_bitmap("pics/green_tu.tga", NULL);
    if (!green_tu)  {
        fatalError("Unable to load bitmap");
    }
    yellow_tu = load_bitmap("pics/yellow_tu.tga", NULL);
    if (!yellow_tu)  {
        fatalError("Unable to load bitmap");
    }
    menu = load_bitmap("pics/bgd_men.tga", NULL);
    if (!menu)  {
        fatalError("Unable to load bitmap");
    }
    menu_ob = load_bitmap("pics/menu.tga", NULL);
    if (!menu_ob)  {
        fatalError("Unable to load bitmap");
    }
    for (int a=0; a < 6; a++)  {
        snprintf(buffer, 128, "pics/q_%d.tga", a + 1);
        pt[a] = load_bitmap(buffer, NULL);
    }
    LOCK_FUNCTION(timerCounterUpdater);
    LOCK_VARIABLE(timerCounter);
    install_int_ex(timerCounterUpdater, BPS_TO_TIMER(30));
    set_trans_blender(0,0,0, 190);
}

// clean up at game-exit
void done()  {
    show_mouse(NULL);
    destroy_bitmap(doublebuffer);
    destroy_bitmap(spielfeld);
    destroy_bitmap(splfld);
    destroy_bitmap(ae);
    destroy_bitmap(blue);
    destroy_bitmap(red);
    destroy_bitmap(yellow);
    destroy_bitmap(green);
    destroy_bitmap(btn_q);
    destroy_bitmap(btn_qu);
    destroy_bitmap(btn_ng);
    destroy_bitmap(btn_pl);
    destroy_bitmap(red_tu);
    destroy_bitmap(blue_tu);
    destroy_bitmap(green_tu);
    destroy_bitmap(yellow_tu);
    destroy_bitmap(menu);
    destroy_bitmap(menu_ob);
    for (int a=0; a < 6; a++)  {
        destroy_bitmap(pt[a]);
    }
    font = old_font;
}

// getopt - gets commandline-options
int getopt(char *argument, char *option)  {
    if( argument[0]=='-' && argument[1]==option[0] )
        return TRUE;
    return FALSE;
}

//  ----------------------------  MAIN  ----------------------------
int main(int argc, char **argv)  {
    // commandline_options
    if (argc > 1)  {
        if (getopt(argv[1],"v") == TRUE)  {
            printf("\n############################\n"\
                    "\n\tFRUSTRATION"\
                    "\n (Mensch ärgere dich nicht)"\
                    "\n\tVersion %2.2f\n"\
                    "\n  made by AE - may_2010"\
                    "\n###########################\n"\
                    "\nusage:\t%s [OPTION]\n\noptions:\t-v show this\n\t\t-f fullscreen-mode\n\t\t-w windowed-mode\n\t\t-h show help\n\n", version, argv[0]);
            return EXIT_SUCCESS;
        }
        else if (getopt(argv[1],"h") == TRUE)  {
            printf("\n\t\tHELP\n"\
                    "\nusage:\t%s [OPTION]\n\noptions:\t-v show this\n\t\t-f fullscreen-mode\n\t\t-w windowed-mode\n\t\t-h show help\n\n", argv[0]);
            return EXIT_SUCCESS;
        }
        else if (getopt(argv[1],"f") == TRUE)  {
            printf("Fullscreen ON\ntype %s -w for window\n", argv[0]);
            fs = 1;
        }
        else if (getopt(argv[1],"w") == TRUE)  {
            printf("Fullscreen OFF\ntype %s -f for fullscreen\n", argv[0]);
            fs = 0;
        }
    }
    int gameOver = FALSE;
    init();
    map_x = (SCREEN_W - spielfeld->w)/2;
    map_y = (SCREEN_H - spielfeld->h)/2;
    int state = STATE_MENU;
    // MAIN-GAME
    while ((!gameOver))  {
        
        
        switch (state)  {
            case STATE_NEXT:
                sieg();
                if (end_counter < 0)  {
                    end_counter = timerCounter + 45;
                }
                else if (timerCounter >= end_counter)  {
                    wo_pl();
                    end_counter = -1;
                    if (old_anz > 0)  {
                        anz_pt = old_anz;
                        old_anz = 0;
                    }
                    else  {
                        anz_pt = rnd(6) + 1;
                    }
                    if (player == 0)  {
                        if (win[player] < 1)  {
                            state = STATE_PLAY_1;
                        }
                        else  {
                            player++;
                        }
                    }
                    else if (player == 1)  {
                        if (win[player] < 1)  {
                            state = STATE_PLAY_2;
                        }
                        else  {
                            player++;
                        }
                    }
                    else if (player == 2)  {
                        if (win[player] < 1)  {
                            state = STATE_PLAY_3;
                        }
                        else  {
                            player++;
                        }
                    }
                    else if (player == 3)  {
                        if (win[player] < 1)  {
                            state = STATE_PLAY_4;
                        }
                        else  {
                            player = 0;
                        }
                    }
                }
                if (player == 0)  {
                    if (win[player] < 1)  {
                        textprintf_centre_ex(doublebuffer, go_fnt, map_x + (spielfeld->w / 2), map_y + (spielfeld->h / 2) - 28, makecol(255,0,0), -1, "Player %d", player + 1);
                    }
                }
                else if (player == 1)  {
                    if (win[player] < 1)  {
                        textprintf_centre_ex(doublebuffer, go_fnt, map_x + (spielfeld->w / 2), map_y + (spielfeld->h / 2) - 28, makecol(255,0,0), -1, "Player %d", player + 1);
                    }
                }
                else if (player == 2)  {
                    if (win[player] < 1)  {
                        textprintf_centre_ex(doublebuffer, go_fnt, map_x + (spielfeld->w / 2), map_y + (spielfeld->h / 2) - 28, makecol(255,0,0), -1, "Player %d", player + 1);
                    }
                }
                else if (player == 3)  {
                    if (win[player] < 1)  {
                        textprintf_centre_ex(doublebuffer, go_fnt, map_x + (spielfeld->w / 2), map_y + (spielfeld->h / 2) - 28, makecol(255,0,0), -1, "Player %d", player + 1);
                    }
                }
                if ((win[0] == 1 || win[0] == 2) && (win[1] == 1 || win[1] == 2) && (win[2] == 1 || win[2] == 2) && (win[3] == 1 || win[3] == 2))  {
                    state = STATE_GAME_OVER;
                }
                break;


            case STATE_PLAY_1:
                draw_sprite(doublebuffer, red_tu, map_x + 68, map_y + 334);
                textprintf_centre_ex(doublebuffer, font, map_x + 105, map_y + 415, makecol(255,0,0), -1, "Player 1");
                textprintf_centre_ex(doublebuffer, font, map_x + 105, map_y + 430, makecol(0,0,0), -1, "You got %d!", anz_pt);
                poss();
                if (poss_tu > 0)  {
                    if (win[player] == -1)  {
                        if (end_counter < 0)  {
                            end_counter = timerCounter + 20;
                        }
                        else if (timerCounter >= end_counter)  {
                            ai();
                            end_counter = 1;
                        }
                    }
                    else  {
                        play();
                    }
                }
                else  {
                    if (win[player] == -1)  {
                        if (end_counter < 0)  {
                            end_counter = timerCounter + 15;
                        }
                        else if (timerCounter >= end_counter)  {
                            rule();
                            end_counter = 1;
                        }
                    }
                    else  {
                        if (mouse_b & 0x01)  {
                            rule();
                            end_counter = 1;
                        }
                    }
                }
                draw_sprite(doublebuffer, pt[anz_pt-1], (map_x + spielfeld->w / 2 - (pt[0]->w / 2)), (map_y + spielfeld->h / 2 - (pt[0]->h / 2)));
                if  (end_counter == 1)  {
                    end_counter = -1;
                    state = STATE_NEXT;
                }
                break;


            case STATE_PLAY_2:
                draw_sprite(doublebuffer, blue_tu, map_x + 68, map_y + 68);
                textprintf_centre_ex(doublebuffer, font, map_x + 105, map_y + 145, makecol(255,0,0), -1, "Player 2");
                textprintf_centre_ex(doublebuffer, font, map_x + 105, map_y + 160, makecol(0,0,0), -1, "You got %d!", anz_pt);
                poss_tu = 0;
                poss();
                if (poss_tu > 0)  {
                    if (win[player] == -1)  {
                        if (end_counter < 0)  {
                            end_counter = timerCounter + 20;
                        }
                        else if (timerCounter >= end_counter)  {
                            ai();
                            end_counter = 1;
                        }
                    }
                    else  {
                        play();
                    }
                    try_pt = 0;
                }
                else  {
                    if (win[player] == -1)  {
                        if (end_counter < 0)  {
                            end_counter = timerCounter + 15;
                        }
                        else if (timerCounter >= end_counter)  {
                            rule();
                            end_counter = 1;
                        }
                    }
                    else  {
                        if (mouse_b & 0x01)  {
                            rule();
                            end_counter = 1;
                        }
                    }
                }
                draw_sprite(doublebuffer, pt[anz_pt-1], (map_x + spielfeld->w / 2 - (pt[0]->w / 2)), (map_y + spielfeld->h / 2 - (pt[0]->h / 2)));
                if  (end_counter == 1)  {
                    end_counter = -1;
                    state = STATE_NEXT;
                }
                break;


            case STATE_PLAY_3:
                draw_sprite(doublebuffer, green_tu, map_x + 334, map_y + 68);
                textprintf_centre_ex(doublebuffer, font, map_x + 371, map_y + 145, makecol(255,0,0), -1, "Player 3");
                textprintf_centre_ex(doublebuffer, font, map_x + 371, map_y + 160, makecol(0,0,0), -1, "You got %d!", anz_pt);
                poss_tu = 0;
                poss();
                if (poss_tu > 0)  {
                    if (win[player] == -1)  {
                        if (end_counter < 0)  {
                            end_counter = timerCounter + 20;
                        }
                        else if (timerCounter >= end_counter)  {
                            ai();
                            end_counter = 1;
                        }
                    }
                    else  {
                        play();
                    }
                    try_pt = 0;
                }
                else  {
                    if (win[player] == -1)  {
                        if (end_counter < 0)  {
                            end_counter = timerCounter + 15;
                        }
                        else if (timerCounter >= end_counter)  {
                            rule();
                            end_counter = 1;
                        }
                    }
                    else  {
                        if (mouse_b & 0x01)  {
                            rule();
                            end_counter = 1;
                        }
                    }
                }
                draw_sprite(doublebuffer, pt[anz_pt-1], (map_x + spielfeld->w / 2 - (pt[0]->w / 2)), (map_y + spielfeld->h / 2 - (pt[0]->h / 2)));
                if  (end_counter == 1)  {
                    end_counter = -1;
                    state = STATE_NEXT;
                }
                break;


            case STATE_PLAY_4:
                draw_sprite(doublebuffer, yellow_tu, map_x + 334, map_y + 334);
                textprintf_centre_ex(doublebuffer, font, map_x + 371, map_y + 410, makecol(255,0,0), -1, "Player 4");
                textprintf_centre_ex(doublebuffer, font, map_x + 371, map_y + 425, makecol(0,0,0), -1, "You got %d!", anz_pt);
                poss_tu = 0;
                poss();
                if (poss_tu > 0)  {
                    if (win[player] == -1)  {
                        if (end_counter < 0)  {
                            end_counter = timerCounter + 20;
                        }
                        else if (timerCounter >= end_counter)  {
                            ai();
                            end_counter = 1;
                        }
                    }
                    else  {
                        play();
                    }
                    try_pt = 0;
                }
                else  {
                    if (win[player] == -1)  {
                        if (end_counter < 0)  {
                            end_counter = timerCounter + 15;
                        }
                        else if (timerCounter >= end_counter)  {
                            rule();
                            end_counter = 1;
                        }
                    }
                    else  {
                        if (mouse_b & 0x01)  {
                            rule();
                            end_counter = 1;
                        }
                    }
                }
                draw_sprite(doublebuffer, pt[anz_pt-1], (map_x + spielfeld->w / 2 - (pt[0]->w / 2)), (map_y + spielfeld->h / 2 - (pt[0]->h / 2)));
                if  (end_counter == 1)  {
                    end_counter = -1;
                    state = STATE_NEXT;
                }
                break;


            case STATE_MENU:
                draw_sprite(doublebuffer, splfld, map_x, map_y);
                game();
                draw_trans_sprite(doublebuffer, btn_pl, map_x + (spielfeld->w / 2) - (btn_pl->w / 2), map_y + spielfeld->h - 130);
                draw_trans_sprite(doublebuffer, btn_ng, map_x + (spielfeld->w / 2) - (btn_ng->w / 2), map_y + spielfeld->h - 100);
                draw_trans_sprite(doublebuffer, btn_qu, map_x + (spielfeld->w / 2) - (btn_qu->w / 2), map_y + spielfeld->h - 70);
                draw_sprite(doublebuffer, ae, (map_x + spielfeld->w - 100), (map_y + spielfeld->h - 15));
                draw_trans_sprite(doublebuffer, menu_ob, map_x + (spielfeld->w / 2) - (menu_ob->w / 2), map_y + 30);
                textprintf_centre_ex(doublebuffer, go_fnt, map_x + spielfeld->w / 2, map_y + 40, makecol(255,0,0), -1, "Frustration");
                textprintf_centre_ex(doublebuffer, font, map_x + spielfeld->w / 2, map_y + 80, makecol(255,255,0), -1, "(Mensch ärgere dich nicht!)");
                if (anz_pt != 0)  {
                    textprintf_centre_ex(doublebuffer, go_fnt, map_x + (spielfeld->w / 2), map_y + 110, makecol(0,255,255), -1, "GAME PAUSE");
                }
                else  {
                    textprintf_centre_ex(doublebuffer, go_fnt, map_x + (spielfeld->w / 2), map_y + 110, makecol(0,255,255), -1, "MENU");
                }
                draw_trans_sprite(doublebuffer, menu, map_x + (spielfeld->w / 2) - (menu->w / 2), map_y + (spielfeld->h  / 2) - (menu->h / 2));
                textprintf_right_ex(doublebuffer, font, map_x + (spielfeld->w / 2) - 10, map_y + (spielfeld->h  / 2) - 40, makecol(255,255,0), -1, "ON");
                textprintf_right_ex(doublebuffer, font, map_x + (spielfeld->w / 2) - 10, map_y + (spielfeld->h  / 2) - 5, makecol(255,255,0), -1, "OFF");
                textprintf_right_ex(doublebuffer, font, map_x + (spielfeld->w / 2) - 10, map_y + (spielfeld->h  / 2) + 30, makecol(255,255,0), -1, "Computer");
                if (win[0] == 0 || win[0] == 1)  {
                    draw_sprite(doublebuffer, red, map_x + (spielfeld->w / 2), map_y + (spielfeld->h  / 2) - 55);
                }
                else if (win[0] == 2)  {
                    draw_sprite(doublebuffer, red, map_x + (spielfeld->w / 2), map_y + (spielfeld->h  / 2) - 20);
                }
                else if (win[0] == -1)  {
                    draw_sprite(doublebuffer, red, map_x + (spielfeld->w / 2), map_y + (spielfeld->h  / 2) +15);
                }
                if (win[1] == 0 || win[1] == 1)  {
                    draw_sprite(doublebuffer, blue, map_x + (spielfeld->w / 2) + 25, map_y + (spielfeld->h  / 2) - 55);
                }
                else if (win[1] == 2)  {
                    draw_sprite(doublebuffer, blue, map_x + (spielfeld->w / 2) + 25, map_y + (spielfeld->h  / 2) - 20);
                }
                else if (win[1] == -1)  {
                    draw_sprite(doublebuffer, blue, map_x + (spielfeld->w / 2) + 25, map_y + (spielfeld->h  / 2) + 15);
                }
                if (win[2] == 0 || win[2] == 1)  {
                    draw_sprite(doublebuffer, green, map_x + (spielfeld->w / 2) + 50, map_y + (spielfeld->h  / 2) - 55);
                }
                else if (win[2] == 2)  {
                    draw_sprite(doublebuffer, green, map_x + (spielfeld->w / 2) + 50, map_y + (spielfeld->h  / 2) - 20);
                }
                else if (win[2] == -1)  {
                    draw_sprite(doublebuffer, green, map_x + (spielfeld->w / 2) + 50, map_y + (spielfeld->h  / 2) + 15);
                }
                if (win[3] == 0 || win[3] == 1)  {
                    draw_sprite(doublebuffer, yellow, map_x + (spielfeld->w / 2) + 75, map_y + (spielfeld->h  / 2) - 55);
                }
                else if (win[3] == 2)  {
                    draw_sprite(doublebuffer, yellow, map_x + (spielfeld->w / 2) + 75, map_y + (spielfeld->h  / 2) - 20);
                }
                else if (win[3] == -1)  {
                    draw_sprite(doublebuffer, yellow, map_x + (spielfeld->w / 2) + 75, map_y + (spielfeld->h  / 2) + 15);
                }
                if (mouse_b & 0x01 && mouse_x > map_x + (spielfeld->w / 2) && mouse_x < map_x + (spielfeld->w / 2) + 20 && mouse_y > map_y + (spielfeld->h  / 2) - 40 && mouse_y < map_y + (spielfeld->h  / 2) - 15)  {
                    win[0] = 0;
                }
                if (mouse_b & 0x01 && mouse_x > map_x + (spielfeld->w / 2) && mouse_x < map_x + (spielfeld->w / 2) + 20 && mouse_y > map_y + (spielfeld->h  / 2) - 5 && mouse_y < map_y + (spielfeld->h  / 2) + 20)  {
                    win[0] = 2;
                }
                if (mouse_b & 0x01 && mouse_x > map_x + (spielfeld->w / 2) && mouse_x < map_x + (spielfeld->w / 2) + 20 && mouse_y > map_y + (spielfeld->h  / 2) + 30 && mouse_y < map_y + (spielfeld->h  / 2) + 55)  {
                    win[0] = -1;
                }
                if (mouse_b & 0x01 && mouse_x > map_x + (spielfeld->w / 2) + 25 && mouse_x < map_x + (spielfeld->w / 2) + 45 && mouse_y > map_y + (spielfeld->h  / 2) - 40 && mouse_y < map_y + (spielfeld->h  / 2) - 15)  {
                    win[1] = 0;
                }
                if (mouse_b & 0x01 && mouse_x > map_x + (spielfeld->w / 2) + 25 && mouse_x < map_x + (spielfeld->w / 2) + 45 && mouse_y > map_y + (spielfeld->h  / 2) - 5 && mouse_y < map_y + (spielfeld->h  / 2) + 20)  {
                    win[1] = 2;
                }
                if (mouse_b & 0x01 && mouse_x > map_x + (spielfeld->w / 2) + 25 && mouse_x < map_x + (spielfeld->w / 2) + 45 && mouse_y > map_y + (spielfeld->h  / 2) + 30 && mouse_y < map_y + (spielfeld->h  / 2) + 55)  {
                    win[1] = -1;
                }
                if (mouse_b & 0x01 && mouse_x > map_x + (spielfeld->w / 2) + 50 && mouse_x < map_x + (spielfeld->w / 2) + 70 && mouse_y > map_y + (spielfeld->h  / 2) - 40 && mouse_y < map_y + (spielfeld->h  / 2) - 15)  {
                    win[2] = 0;
                }
                if (mouse_b & 0x01 && mouse_x > map_x + (spielfeld->w / 2) + 50 && mouse_x < map_x + (spielfeld->w / 2) + 70 && mouse_y > map_y + (spielfeld->h  / 2) - 5 && mouse_y < map_y + (spielfeld->h  / 2) + 20)  {
                    win[2] = 2;
                }
                if (mouse_b & 0x01 && mouse_x > map_x + (spielfeld->w / 2) + 50 && mouse_x < map_x + (spielfeld->w / 2) + 70 && mouse_y > map_y + (spielfeld->h  / 2) + 30 && mouse_y < map_y + (spielfeld->h  / 2) + 55)  {
                    win[2] = -1;
                }
                if (mouse_b & 0x01 && mouse_x > map_x + (spielfeld->w / 2) + 75 && mouse_x < map_x + (spielfeld->w / 2) + 95 && mouse_y > map_y + (spielfeld->h  / 2) - 40 && mouse_y < map_y + (spielfeld->h  / 2) - 15)  {
                    win[3] = 0;
                }
                if (mouse_b & 0x01 && mouse_x > map_x + (spielfeld->w / 2) + 75 && mouse_x < map_x + (spielfeld->w / 2) + 95 && mouse_y > map_y + (spielfeld->h  / 2) - 5 && mouse_y < map_y + (spielfeld->h  / 2) + 20)  {
                    win[3] = 2;
                }
                if (mouse_b & 0x01 && mouse_x > map_x + (spielfeld->w / 2) + 75 && mouse_x < map_x + (spielfeld->w / 2) + 95 && mouse_y > map_y + (spielfeld->h  / 2) + 30 && mouse_y < map_y + (spielfeld->h  / 2) + 55)  {
                    win[3] = -1;
                }
                if (mouse_b & 0x01 && mouse_x > map_x + (spielfeld->w / 2) - (btn_pl->w / 2) && mouse_x < map_x + (spielfeld->w / 2) - (btn_pl->w / 2) + 120 && mouse_y > map_y + spielfeld->h - 130 && mouse_y < map_y + spielfeld->h - 106)  {
                    old_anz = anz_pt;
                    state = STATE_NEXT;
                }
                if (mouse_b & 0x01 && mouse_x > map_x + (spielfeld->w / 2) - (btn_ng->w / 2) && mouse_x < map_x + (spielfeld->w / 2) - (btn_ng->w / 2) + 120 && mouse_y > map_y + spielfeld->h - 100 && mouse_y < map_y + spielfeld->h - 76)  {
                    new_game();
                    state = STATE_NEXT;
                }
// EXIT if quit-button is clicked or right_mouse_button is pressed
                if ((mouse_b & 0x01 && mouse_x > map_x + (spielfeld->w / 2) - (btn_qu->w / 2) && mouse_x < map_x + (spielfeld->w / 2) - (btn_qu->w / 2) + 120 && mouse_y > map_y + spielfeld->h - 70 && mouse_y < map_y + spielfeld->h - 46) || mouse_b & 0x02)  {
                    gameOver = TRUE;
                }
                break;
            case STATE_GAME_OVER:
                textprintf_centre_ex(doublebuffer, go_fnt, map_x + (spielfeld->w / 2), map_y + (spielfeld->h / 2) - 28, makecol(255,0,0), -1, "GAME OVER", 0);
                break;
        }
        // QUIT GAME:
        if (close_button_pressed)  {
            gameOver = TRUE;
        }
// menu-button:
        if ((mouse_b & 0x01 && mouse_x > map_x + spielfeld->w - 110 && mouse_x < map_x + spielfeld->w - 40 && mouse_y > map_y + spielfeld->h - 30 && mouse_y < map_y + spielfeld->h - 10) || key[KEY_ESC])  {
            state = STATE_MENU;
        }
        if (win_pl == 1)  {
            textprintf_centre_ex(doublebuffer, font, map_x + 105, map_y + 310, makecol(255,0,0), -1, "[Winner] Player 1");
        }
        else if (win_pl == 2)  {
            textprintf_centre_ex(doublebuffer, font, map_x + 105, map_y + 40, makecol(255,0,0), -1, "[Winner] Player 2");
        }
        else if (win_pl == 3)  {
            textprintf_centre_ex(doublebuffer, font, map_x + 371, map_y + 40, makecol(255,0,0), -1, "[Winner] Player 3");
        }
        else if (win_pl == 4)  {
            textprintf_centre_ex(doublebuffer, font, map_x + 371, map_y + 310, makecol(255,0,0), -1, "[Winner] Player 4");
        }
        show();
        table();
    }
    // END of MAIN_GAME
    done();
}  END_OF_MAIN()
