/*
MANCALA - Bohnenspiel

THE GAME IS COMPLETLY PLAYABLE AND SOLVEABLE
___________
what WORKS:
                        ++ 2 - Player
                        ++ simple AI:   Player 1 (SOUTH) is human - Player 2 (NORTH) is computer
                        ++ AI shows next turn
                        ++ show rectangle around target- and startfield, if right-mouse-button is pressed
                        ++ solving the game

___________
known BUGS:
                        -- sometimes right-mouse-button isn`t working well in computer-turn
                        -- game may crash if you are not playing for a long time
                        -- ESC-key isn`t working at GAME-OVER-screen

for bug-reports or anything else, please send email to <andi@obergrabnerhof.at>

Version 1.00
by AE may, 2010
*/
/*
MANCALA - Bohnenspiel

todo:
>>>>solved   Wechsel von einer Seite zur anderen während ZUG
>>>>solved   2 - Spieler
>>>>solved   Siegbedingungen - sobald ein Spieler mehr als 24 Steine hat oder auf einer Seite alle Steine weg sind
>>>>solved   Code in mehrere Dateien aufteilen
>>>>solved   falls letzter Stein in Ziel landet - erneuter Zug
>>>>solved   falls letzter Stein in Feld mit 0 Steinen landet - bekommt Spieler diesen und die gegenüberliegenden ins Zielfeld
>>>>solved   Rahmen um Ziel - teilweise fehlerhaft -- zug.cpp überrbeiten

andere Schriftart als QUIZ.FNT einsetzen


NETWORK PLAY
Diverse Bugs entfernen

Version 1.00 - playable
*/

#include <allegro.h>

// for DEBUG:
// #include <iostream>

#include "stones.h"
#include "show_nr.h"
#include "mouse.h"
#include "rect.h"
#include "turn.h"
#include "ai.h"
#include "ai_rect.h"

DATAFILE *fontDat;
FONT *oldFont;

BITMAP *doublebuffer = NULL;
BITMAP *pointer = NULL;
BITMAP *bg = NULL;
BITMAP *spielfeld = NULL;
BITMAP *bean_1 = NULL;
BITMAP *bean_2 = NULL;
BITMAP *end_1 = NULL;
BITMAP *end_2 = NULL;
BITMAP *bttn_1 = NULL;
BITMAP *bttn_2 = NULL;

const int mouse_ofs_x = -34;
const int mouse_ofs_y = -2;

const int anz_beans = 48;
const int anz_holes = 12;

int player = 1;  // allways start with player 1 (SOUTH)
int map[anz_holes] = {0,0,0,0,0,0,0,0,0,0,0,0};

int x[2][12] = {{480,400,320,240,160,80,80,160,240,320,400,480}, {560,480,400,320,240,160,160,240,320,400,480,560}};
int y[2][2] = {{140,260}, {220,340}};

int pl_end[] = {0,0};
int game_over = 0;  // 1 = GAME OVER

int ki = 0;
// ----------------------------  FUNCTIONS  -------------------------------
// ----------------------------  WINDOW CLOSE BUTTON ----------------
volatile int close_button_pressed = FALSE;
void close_button_handler(void)  {
    close_button_pressed = TRUE;
}  END_OF_FUNCTION(close_button_handler)

// -------------------------  put stones onto playfield ----------------------------
void beans()  {
    int bea = 0;
    for (int b=0; b < anz_beans; b++)  {
        if (bea >= anz_holes)  {
            bea = 0;
            b--;
        }
        else  {
            map[bea]++;
            bea++;
        }
    }
}

// ---------------------------- SIEG (WON)  --------------------------------
void sieg()  {
    if (pl_end[0] > pl_end[1] && pl_end[0] > (anz_beans / 2) || map[0] + map[1] + map[2] + map[3] + map[4] + map[5] <= 0)  {
        game_over = 1;
        textout_centre_ex(doublebuffer, font, "GAME OVER", doublebuffer->w/2, 225, makecol(255,255,0), -1);
        textprintf_centre_ex(doublebuffer, font, doublebuffer->w/2, 430, makecol(0,0,0), -1, "[Gewinner] Spieler 1 hat %d Steine", pl_end[0]);
        textout_centre_ex(doublebuffer, font, "Spieler 1 hat gewonnen", doublebuffer->w/2, 245, makecol(255,255,0), -1);
        if (ki == 1)  {
            textprintf_centre_ex(doublebuffer, font, doublebuffer->w/2, 50, makecol(0,0,0), -1, "COMPUTER hat %d Steine", pl_end[1]);
        }
        else  {
            textprintf_centre_ex(doublebuffer, font, doublebuffer->w/2, 50, makecol(0,0,0), -1, "Spieler 2 hat %d Steine", pl_end[1]);
        }
    }
    else if (pl_end[1] > pl_end[0] && pl_end[1] > (anz_beans / 2) || map[6] + map[7] + map[8] + map[9] + map[10] + map[11] <= 0)  {
        game_over = 1;
        textout_centre_ex(doublebuffer, font, "GAME OVER", doublebuffer->w/2, 225, makecol(255,255,0), -1);
        textprintf_centre_ex(doublebuffer, font, doublebuffer->w/2, 430, makecol(0,0,0), -1, "Spieler 1 hat %d Steine", pl_end[0]);
        if (ki == 1)  {
            textprintf_centre_ex(doublebuffer, font, doublebuffer->w/2, 50, makecol(0,0,0), -1, "[Gewinner] COMPUTER hat %d Steine", pl_end[1]);
            textout_centre_ex(doublebuffer, font, "COMPUTER hat gewonnen", doublebuffer->w/2, 245, makecol(255,255,0), -1);
        }
        else  {
            textprintf_centre_ex(doublebuffer, font, doublebuffer->w/2, 50, makecol(0,0,0), -1, "[Gewinner] Spieler 2 hat %d Steine", pl_end[1]);
            textout_centre_ex(doublebuffer, font, "Spieler 2 hat gewonnen", doublebuffer->w/2, 245, makecol(255,255,0), -1);
        }
    }
    if (map[0] + map[1] + map[2] + map[3] + map[4] + map[5] <= 0)  {
        if (ki == 1)  {
            textout_centre_ex(doublebuffer, font, "COMPUTER hat keine Steine mehr", doublebuffer->w/2, 80, makecol(0,0,0), -1);
        }
        else  {
            textout_centre_ex(doublebuffer, font, "Spieler 2 hat keine Steine mehr", doublebuffer->w/2, 80, makecol(0,0,0), -1);
        }
    }
    else if (map[6] + map[7] + map[8] + map[9] + map[10] + map[11] <= 0)  {
        textout_centre_ex(doublebuffer, font, "Spieler 1 hat keine Steine mehr", doublebuffer->w/2, 400, makecol(0,0,0), -1);
    }
}

// set graphicmode:
int setGfxMode(int mode, int width, int height)  {
    static int colorDepths[] = {16, 24, 15, 32};
    int a;
    for (a=0; a < 4; a++)  {
        set_color_depth(colorDepths[a]);
        if (set_gfx_mode(mode, width, height, 0, 0) >= 0)  {
            return 1;
        }
    }
    return 0;
}

//  set allegro
void init()  {
    set_uformat(U_UTF8);
    fontDat = load_datafile("fnt.fnt");
    oldFont = font;
    font= (FONT*) fontDat[0].dat;
    allegro_init();
    LOCK_FUNCTION(close_button_handler);
    set_close_button_callback(close_button_handler);
// set graphicmode - fullscreen uncomment / windowed
 //   if (!setGfxMode(GFX_AUTODETECT_FULLSCREEN, 640, 480))  {
        if (!setGfxMode(GFX_AUTODETECT_WINDOWED, 640, 480))  {
            allegro_message("Unable to set a graphics mode");
        }
//    }
//    install_timer();
    install_keyboard();
    install_mouse();
//    install_joystick(JOY_TYPE_AUTODETECT);
//    install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
    doublebuffer = create_bitmap(SCREEN_W, SCREEN_H);
    if (!doublebuffer)  {
        allegro_message("Unable to create double buffer");
    }
    pointer = load_bitmap("pointer.bmp", NULL);
    if (!pointer)  {
        allegro_message("Unable to create mouse-cursor");
    }
}

//  ---------------------  CLEANUP  ------------------------
void done()  {
    destroy_bitmap(doublebuffer);
    destroy_bitmap(pointer);
    destroy_bitmap(bg);
    destroy_bitmap(spielfeld);
    destroy_bitmap(bean_1);
    destroy_bitmap(bean_2);
    destroy_bitmap(end_1);
    destroy_bitmap(end_2);
    destroy_bitmap(bttn_1);
    destroy_bitmap(bttn_2);
// fallback to old font
    font = oldFont;
    unload_datafile(fontDat);
}
//  ---------------------------  END FUNCTIONS ---------------------------

// ----------------------------  BEGIN MAIN ---------------------------------
int main(int argc, char **argv)  {
    init();
    beans();
    BITMAP *bg = load_bitmap("background.tga"  , NULL);
    BITMAP *spielfeld = load_bitmap("spielfeld.tga"  , NULL);
    BITMAP *bttn_1 = load_bitmap("bttn_1.pcx"  , NULL);
    BITMAP *bttn_2 = load_bitmap("bttn_2.pcx"  , NULL);
//  -----------------  mouserange ----------------
    set_mouse_range(0, 0, SCREEN_W, SCREEN_H);
// ------------ MAIN - LOOP ----------------------
    while ((!key[KEY_ESC]) && (!close_button_pressed))  {
//  ------------------  GAME-OVER - LOOP ---------------------------
        if (game_over >= 1)  {
            while (!mouse_b)  {
    // ------------ Display ----------------------
                clear(doublebuffer);
                blit(bg, doublebuffer, 0, 0, 0, 0, bg->w, bg->h);
                draw_sprite(doublebuffer, spielfeld, 0, 130);
    //   -------------zeichne Steine --------------
                show_stones();
                show_nr();
    // -------------- zeige END - Spielfeld -------------------
                sieg();
    //  ------------- say what to do -------------
                textout_centre_ex(doublebuffer, font, "Rechte Maustaste startet neues Spiel", doublebuffer->w/2, 350, makecol(0,0,0), -1);
     //           textout_centre_ex(doublebuffer, font, "ESC zum beenden", 320, 380, makecol(0,0,0), -1);
    // ---------------- zeige Maus -------------
                draw_sprite(doublebuffer, pointer, mouse_x + mouse_ofs_x, mouse_y+ mouse_ofs_y);
                vsync();
                blit(doublebuffer, screen, 0, 0, 0, 0, doublebuffer->w, doublebuffer->h);
    //  -------------  restart game if right mousebutton  -----------------
                if (mouse_b & 0x02)  {
    // ----------  clear all beans  --------------
                    for (int a=0; a < anz_holes; a++)  {
                        map[a] = 0;
                    }
    //  ----------- fill with new beans  ---------
                    beans();
    //  -----------  clear end-beans
                    pl_end[0] = 0;
                    pl_end[1] = 0;
    //  ----------  player 1 starts first
                    player = 1;
    //  ---------  restart
                    game_over = 0;
                }
            }
        }
//  --------------------------- GAME-ON - LOOP -----------------------------------------
        else  {
// ------------ Display ----------------------
            clear(doublebuffer);
            blit(bg, doublebuffer, 0, 0, 0, 0, bg->w, bg->h);
            draw_sprite(doublebuffer, spielfeld, 0, 130);
// ------------ KI - ON - OFF -------------------------
            if (ki < 1)  {
                draw_sprite(doublebuffer, bttn_1, 470, 390);
                if (mouse_b & 0x01 && mouse_y < 430 && mouse_y > 390 && mouse_x < 640 && mouse_x > 470)  {
                    ki = 1;
                }
            }
            else if (ki > 0)  {
                draw_sprite(doublebuffer, bttn_2, 470, 430);
                if (mouse_b & 0x01 && mouse_y < 470 && mouse_y > 430 && mouse_x < 640 && mouse_x > 470)  {
                    ki = 0;
                }
            }
//   -------------zeichne Steine --------------
            show_stones();
            show_nr();
// -------------- GAME-OVER -------------------
            sieg();
//  ------------- KI and GAME ---------------------
            //  KI 1 = easy ...
            if (ki == 1 && player == 2 || ki == 1 && player == 4)  {
                textout_centre_ex(doublebuffer, font, "COMPUTER - Spieler 2", doublebuffer->w/2, 50, makecol(0,0,0), -1);
                textout_centre_ex(doublebuffer, font, "Computer am Zug", doublebuffer->w/2, 360, makecol(0,0,0), -1);
                textout_centre_ex(doublebuffer, font, "Rechte Maustaste zum fortsetzen", doublebuffer->w/2, 380, makecol(0,0,0), -1);
                while (!(mouse_b & 0x02))  {
                    clear(doublebuffer);
                    blit(bg, doublebuffer, 0, 0, 0, 0, bg->w, bg->h);
                    draw_sprite(doublebuffer, spielfeld, 0, 130);
                    draw_sprite(doublebuffer, bttn_2, 470, 430);
                    show_stones();
                    show_nr();
                    //  --------------   KI  -------------
                    ai_rect();
                    if (mouse_b & 0x02)  {
                        ai_turn();
                    }
                    // -------------- END KI ------------
                    sieg();
                    textout_centre_ex(doublebuffer, font, "COMPUTER - Spieler 2", doublebuffer->w/2, 50, makecol(0,0,0), -1);
                    textout_centre_ex(doublebuffer, font, "Computer am Zug", doublebuffer->w/2, 360, makecol(0,0,0), -1);
                    textout_centre_ex(doublebuffer, font, "Rechte Maustaste zum fortsetzen", doublebuffer->w/2, 380, makecol(0,0,0), -1);
                    draw_sprite(doublebuffer, pointer, mouse_x + mouse_ofs_x, mouse_y+ mouse_ofs_y);
                    vsync();
                    blit(doublebuffer, screen, 0, 0, 0, 0, doublebuffer->w, doublebuffer->h);
                }
            }
            else  {
                mouse_click();
            }
// ----------------MAUS - ZEIGER----------------
            draw_sprite(doublebuffer, pointer, mouse_x + mouse_ofs_x, mouse_y+ mouse_ofs_y);
            vsync();
            blit(doublebuffer, screen, 0, 0, 0, 0, doublebuffer->w, doublebuffer->h);
        }
    }
//  ---------------------  DEBUG - KONSOLE: -----------------
    //
/*
    for (int b=0; b < anz_holes; b++) {
    printf("map  : %02d \n", map[b]);
}*/
    //
//  ------------------------------------------------------------------
    done();
} END_OF_MAIN()
