#include "KGF.h"


LogFileClass *GlobalLog=NULL;


void CreateLog() {
  GlobalLog = new LogFileClass("gamelog.txt");
}

void CloseLog() {
  delete GlobalLog;
}


void Notification(std::string message) {
  if (Display) al_show_native_message_box("Notification", "", message.c_str(), NULL, ALLEGRO_MESSAGEBOX_WARN);
  GlobalLog->LogMessage("Note: " + message);
}

void Notification(char *str) {
  Notification(ToString(str));
}


void Warning(std::string message) {
  if (Display) al_show_native_message_box("Warning", "", message.c_str(), NULL, ALLEGRO_MESSAGEBOX_WARN);
  GlobalLog->LogMessage("Warning: " + message);
}


void Warning(char *str) {
  Warning(ToString(str));
}


void Error(std::string message) {
  if (Display) al_show_native_message_box("Fatal Error", "", message.c_str(), NULL, ALLEGRO_MESSAGEBOX_ERROR);
  GlobalLog->LogMessage("Error: " + message);
  abort();
}


void Error(char *str) {
  Error(ToString(str));
}


bool FileExists(char *str) {
  return al_filename_exists(str);
}

bool FileExists(std::string str) {
  return al_filename_exists(str.c_str());
}
