#include "ConfigLib.h"
#include "StringLib.h"


int GetConfigInt(ALLEGRO_CONFIG *cfg, char *section, char *name, int def) {
  const char *str;
  str = al_get_config_value(cfg, section, name);
  if (str != NULL) return ToFloat(ToString(str));
  else return def;
}


const char *GetConfigStr(ALLEGRO_CONFIG *cfg, char *section, char *name, char *def) {
  const char *str;
  str = al_get_config_value(cfg, section, name);
  if (str != NULL) return str;
  else return def;
}

std::string GetConfigString(ALLEGRO_CONFIG *cfg, char *section, char *name, std::string def) {
  const char *str;
  str = al_get_config_value(cfg, section, name);
  if (str != NULL) return ToString(str);
  else return def;
}


float GetConfigFloat(ALLEGRO_CONFIG *cfg, char *section, char *name, float def) {
  const char *str;
  str = al_get_config_value(cfg, section, name);
  if (str != NULL) return ToFloat(ToString(str));
  else return def;
}
