#include "GResource.h"


#ifndef ANSPRITE_H_INCLUDED
#define ANSPRITE_H_INCLUDED

class SpriteAnimation {
  public:
    std::string name, internal_name;
    std::deque<GBitmap *> bits;
    float frame, speed;
    bool bidirectional, loop;
    bool finished;
    int dir;

    SpriteAnimation(std::string nm, std::string int_nm, float sp, float lp, float bd);

    void Update();

    GBitmap *GetActualBit() {
      frame = SnapFloat(frame, 0, bits.size()-1);
      return bits[frame];
    }

    void SetAtEnd() {frame = bits.size()-1;}

    void SetAtFrame(float v) {
      frame = v;
      frame = SnapFloat(frame, 0, bits.size()-1);
    }

    void SetAtFrameP(float v) {
      frame = (bits.size()*v)-1;
      frame = SnapFloat(frame, 0, bits.size()-1);
    }

    void Start() {frame=0; dir=1; finished=false;}
};


class AnimatedSprite {
  protected:
    std::string name;
    std::deque<SpriteAnimation *> animations;
    SpriteAnimation *actual_animation;
  public:
    AnimatedSprite(std::string);
    void Update();

    void SetActualAnimation(std::string name) {
      actual_animation = NULL;
      for (std::deque<SpriteAnimation *>::iterator it=animations.begin(); it!=animations.end(); it+=1) {
        if (actual_animation != (*it)) {
          if ((*it)->internal_name == name) {
            actual_animation = (*it);
            actual_animation->Start();
          }
        }
      }
    }

    GBitmap *GetActualBit() {
      if (actual_animation == NULL) {
        return GetBitmap("Data/Missing.png");
      }
      else {
        return actual_animation->GetActualBit();
      }
    }

    bool Finished() {
      if (actual_animation != NULL) {
        return actual_animation->finished;
      }
      return false;
    }

    float Width() {return GetActualBit()->Width();}
    float Height() {return GetActualBit()->Height();}

    void SetAtEnd() {
      if (actual_animation != NULL) actual_animation->SetAtEnd();
    }

    void SetAtFrame(float v) {
      if (actual_animation != NULL) actual_animation->SetAtFrame(v);
    }

    void SetAtFrameP(float v) {
      if (actual_animation != NULL) actual_animation->SetAtFrameP(v);
    }

    void SetActualAnimationSpeed(float v) {
      if (actual_animation != NULL) actual_animation->speed = v;
    }
};


#endif
