#include "allegroall.h"
#include <deque>
#include <string>

#ifndef PROGRAM_H_INCLUDED
#define PROGRAM_H_INCLUDED

#define SCREEN_W al_get_display_width()
#define SCREEN_H al_get_display_height()


extern ALLEGRO_EVENT_QUEUE *Queue;
extern ALLEGRO_TIMER *Timer;
extern ALLEGRO_VOICE *Voice;
extern ALLEGRO_MIXER *Mixer;
extern ALLEGRO_MIXER *MusicMixer;
extern ALLEGRO_DISPLAY *Display;

extern bool ProgramStarted;

extern float AspectRatio;

class GScene {
  protected:
    std::string name;
    void (*start)();
    void (*close)();
    void (*update)();
    void (*draw)();
  public:
    GScene() {
      name="";update=draw=start=close=NULL;
    }
    GScene(std::string nm, void (*st)(), void (*up)(), void (*dr)(), void (*cl)()) {
      name = nm; start = st; update = up; draw = dr; close = cl;
    }
    void Start() {if (start != NULL)  (*start)();}
    void Draw()  {if (draw != NULL)   (*draw)();}
    void Update(){if (update != NULL) (*update)();}
    void Close() {if (close != NULL)  (*close)();}

    void SetName(std::string nm) {name=nm;}
    std::string GetName() {return name;}

    void SetStart(void (*v)())  {start = v; }
    void SetUpdate(void (*v)()) {update = v;}
    void SetDraw(void (*v)())   {draw = v;  }
    void SetClose(void (*v)())  {close = v; }
};


class GProgram {
  protected:
    std::string actual_scene_name;
    GScene *next_scene;
    GScene *actual_scene;
    GScene *last_scene;
    std::deque<GScene *> scenes;
  public:
    GProgram() {
      actual_scene=NULL;
      actual_scene_name="";
      scenes.clear();
      last_scene = NULL;
      Start();
    }
    void ChangeScene(std::string name);
    void ClearScene() {next_scene=NULL;}
    void Start();
    void Close();
    void Main();
    void Update();
    void Draw();
    void CreateScenes();
};



extern GProgram *Game;

extern int DebugMode;

#endif
