#include "InputLib.h"
#include "Program.h"

#define KEY_DELAY_TO_DOUBLEPRESS   22

#define MY_KEAYBOARD_SIZE          512

ALLEGRO_MOUSE_STATE mous;
ALLEGRO_KEYBOARD_STATE keyb;


char Keys_To_Check[512];
int Keyboard_Size=0;

char KB_Input[512];
char KB_Released[512];
char KB_DoublePressed[512];

char KB_Active[512];


float mouse_x, mouse_y, last_mouse_x, last_mouse_y, last_mouse_z, mouse_z, mick_x, mick_y;

int Keyboard_Last_Pressed[512];
int KB_TimePressed[512];
int Keyboard_To_Double_Press[512];

void InitMapping() {
  int ind;

  ind = 0;
  while (ind != 512) {
    Keys_To_Check[ind] = 0;
    ++ind;
  }
  Keys_To_Check[ALLEGRO_KEY_A] = 1; Keys_To_Check[ALLEGRO_KEY_B] = 1;
  Keys_To_Check[ALLEGRO_KEY_C] = 1; Keys_To_Check[ALLEGRO_KEY_D] = 1;
  Keys_To_Check[ALLEGRO_KEY_E] = 1; Keys_To_Check[ALLEGRO_KEY_F] = 1;
  Keys_To_Check[ALLEGRO_KEY_G] = 1; Keys_To_Check[ALLEGRO_KEY_H] = 1;
  Keys_To_Check[ALLEGRO_KEY_I] = 1; Keys_To_Check[ALLEGRO_KEY_J] = 1;
  Keys_To_Check[ALLEGRO_KEY_K] = 1; Keys_To_Check[ALLEGRO_KEY_L] = 1;
  Keys_To_Check[ALLEGRO_KEY_M] = 1; Keys_To_Check[ALLEGRO_KEY_N] = 1;
  Keys_To_Check[ALLEGRO_KEY_O] = 1; Keys_To_Check[ALLEGRO_KEY_P] = 1;
  Keys_To_Check[ALLEGRO_KEY_Q] = 1; Keys_To_Check[ALLEGRO_KEY_R] = 1;
  Keys_To_Check[ALLEGRO_KEY_S] = 1; Keys_To_Check[ALLEGRO_KEY_T] = 1;
  Keys_To_Check[ALLEGRO_KEY_U] = 1; Keys_To_Check[ALLEGRO_KEY_V] = 1;
  Keys_To_Check[ALLEGRO_KEY_W] = 1; Keys_To_Check[ALLEGRO_KEY_X] = 1;
  Keys_To_Check[ALLEGRO_KEY_Y] = 1; Keys_To_Check[ALLEGRO_KEY_Z] = 1;
  Keys_To_Check[ALLEGRO_KEY_1] = 1; Keys_To_Check[ALLEGRO_KEY_2] = 1;
  Keys_To_Check[ALLEGRO_KEY_3] = 1; Keys_To_Check[ALLEGRO_KEY_4] = 1;
  Keys_To_Check[ALLEGRO_KEY_5] = 1; Keys_To_Check[ALLEGRO_KEY_6] = 1;
  Keys_To_Check[ALLEGRO_KEY_7] = 1; Keys_To_Check[ALLEGRO_KEY_8] = 1;
  Keys_To_Check[ALLEGRO_KEY_9] = 1; Keys_To_Check[ALLEGRO_KEY_0] = 1;
  Keys_To_Check[ALLEGRO_KEY_PAD_1] = 1; Keys_To_Check[ALLEGRO_KEY_PAD_2] = 1;
  Keys_To_Check[ALLEGRO_KEY_PAD_3] = 1; Keys_To_Check[ALLEGRO_KEY_PAD_4] = 1;
  Keys_To_Check[ALLEGRO_KEY_PAD_5] = 1; Keys_To_Check[ALLEGRO_KEY_PAD_6] = 1;
  Keys_To_Check[ALLEGRO_KEY_PAD_7] = 1; Keys_To_Check[ALLEGRO_KEY_PAD_8] = 1;
  Keys_To_Check[ALLEGRO_KEY_PAD_9] = 1; Keys_To_Check[ALLEGRO_KEY_PAD_0] = 1;
  Keys_To_Check[ALLEGRO_KEY_MOUSE_LCLICK] = 1;
  Keys_To_Check[ALLEGRO_KEY_MOUSE_RCLICK] = 1;
  Keys_To_Check[ALLEGRO_KEY_MOUSE_MCLICK] = 1;

  Keys_To_Check[ALLEGRO_KEY_ALT] = 1;
  Keys_To_Check[ALLEGRO_KEY_ESCAPE] = 1; Keys_To_Check[ALLEGRO_KEY_TILDE] = 1;
  Keys_To_Check[ALLEGRO_KEY_MINUS] = 1; Keys_To_Check[ALLEGRO_KEY_EQUALS] = 1;
  Keys_To_Check[ALLEGRO_KEY_BACKSPACE] = 1; Keys_To_Check[ALLEGRO_KEY_COMMA] = 1;
  Keys_To_Check[ALLEGRO_KEY_OPENBRACE] = 1; Keys_To_Check[ALLEGRO_KEY_TAB] = 1;
  Keys_To_Check[ALLEGRO_KEY_CLOSEBRACE] = 1; Keys_To_Check[ALLEGRO_KEY_ENTER] = 1;
  Keys_To_Check[ALLEGRO_KEY_QUOTE] = 1; Keys_To_Check[ALLEGRO_KEY_BACKSLASH] = 1;
  Keys_To_Check[ALLEGRO_KEY_FULLSTOP] = 1; Keys_To_Check[ALLEGRO_KEY_SLASH] = 1;
  Keys_To_Check[ALLEGRO_KEY_SEMICOLON] = 1; Keys_To_Check[ALLEGRO_KEY_BACKSLASH2] = 1;
  Keys_To_Check[ALLEGRO_KEY_SPACE] = 1; Keys_To_Check[ALLEGRO_KEY_DELETE] = 1;
  Keys_To_Check[ALLEGRO_KEY_INSERT] = 1; Keys_To_Check[ALLEGRO_KEY_END] = 1;
  Keys_To_Check[ALLEGRO_KEY_HOME] = 1; Keys_To_Check[ALLEGRO_KEY_PGUP] = 1;
  Keys_To_Check[ALLEGRO_KEY_PGDN] = 1; Keys_To_Check[ALLEGRO_KEY_LEFT] = 1;
  Keys_To_Check[ALLEGRO_KEY_RIGHT] = 1; Keys_To_Check[ALLEGRO_KEY_UP] = 1;
  Keys_To_Check[ALLEGRO_KEY_DOWN] = 1; Keys_To_Check[ALLEGRO_KEY_PAD_SLASH] = 1;
  Keys_To_Check[ALLEGRO_KEY_PAD_ASTERISK] = 1; Keys_To_Check[ALLEGRO_KEY_PAD_MINUS] = 1;
  Keys_To_Check[ALLEGRO_KEY_PAD_PLUS] = 1; Keys_To_Check[ALLEGRO_KEY_PAD_DELETE] = 1;
  Keys_To_Check[ALLEGRO_KEY_PAD_ENTER] = 1;
  Keys_To_Check[ALLEGRO_KEY_F1] = 1; Keys_To_Check[ALLEGRO_KEY_F6] = 1;
  Keys_To_Check[ALLEGRO_KEY_F2] = 1; Keys_To_Check[ALLEGRO_KEY_F7] = 1;
  Keys_To_Check[ALLEGRO_KEY_F3] = 1; Keys_To_Check[ALLEGRO_KEY_F8] = 1;
  Keys_To_Check[ALLEGRO_KEY_F4] = 1; Keys_To_Check[ALLEGRO_KEY_F9] = 1;
  Keys_To_Check[ALLEGRO_KEY_F5] = 1; Keys_To_Check[ALLEGRO_KEY_F10] = 1;
  Keys_To_Check[ALLEGRO_KEY_F11] = 1;Keys_To_Check[ALLEGRO_KEY_F12] = 1;
  Keys_To_Check[ALLEGRO_KEY_PRINTSCREEN]= 1;

  Keys_To_Check[ALLEGRO_KEY_LSHIFT] = 1;
  Keys_To_Check[ALLEGRO_KEY_LCTRL] = 1; Keys_To_Check[ALLEGRO_KEY_RCTRL] = 1;
}


 /*Clears all the buffers. Used for Transitions between Scenes*/
void clear_my_keyboard() {
  int ind, k;
  ind = 0;
  while (ind != 258) {
    if (Keys_To_Check[ind]) {
      k = ind;
      KB_TimePressed[k]=0;
      KB_DoublePressed[k]=0;
      Keyboard_To_Double_Press[k]=0;
      KB_Released[k]=0;
      KB_Input[k]=0;
      Keyboard_Last_Pressed[k]=0;
    }
    ++ind;
  }
}



void PollInput() {
  int ind, k, joy_num, i;
  al_get_keyboard_state(&keyb);
  al_get_mouse_state(&mous);
  int mx, my;
  mx = mouse_x;
  my = mouse_y;

  last_mouse_x = mouse_x;
  last_mouse_y = mouse_y;
  last_mouse_z = mouse_z;

  mouse_x = al_get_mouse_state_axis(&mous, 0);
  mouse_y = al_get_mouse_state_axis(&mous, 1);
  mouse_z = mous.z;

  mick_x = mouse_x - mx;
  mick_y = mouse_y - my;

  if (keyb.display != Display) {
    clear_my_keyboard();
    return;
  }

  ind = 0;
  while (ind != 512) {
    if (Keys_To_Check[ind]) {
      k = ind;
      if (k < 256) {
        KB_Active[k]=0;
        KB_Input[k]=0;
        KB_Released[k]=0;
        KB_DoublePressed[k]=0;
        if (al_key_down(&keyb, k)) KB_Active[k]=1;
        if (Keyboard_To_Double_Press[k] > 0) Keyboard_To_Double_Press[k] -= 1;
        if (al_key_down(&keyb, k))  KB_TimePressed[k] += 1;
        else KB_TimePressed[k] = 0;
        if (KB_TimePressed[k] > 2000) KB_TimePressed[k] = 2000;
        if ((al_key_down(&keyb, k))  && (Keyboard_To_Double_Press[k] > 0)) {
          KB_DoublePressed[k] = 1;
          Keyboard_To_Double_Press[k] = 0;
        }
        if (!(al_key_down(&keyb, k)) && (Keyboard_Last_Pressed[k])) {
          Keyboard_To_Double_Press[k] = KEY_DELAY_TO_DOUBLEPRESS;
          KB_Released[k]=1;
        }
        if ((al_key_down(&keyb, k)) && (Keyboard_Last_Pressed[k] == 0)) {
          KB_Input[k]=1;
          Keyboard_Last_Pressed[k] = 1;
        }
        if (al_key_down(&keyb, k)) Keyboard_Last_Pressed[k] = 1;
        else Keyboard_Last_Pressed[k] = 0;
      }
      else if (k >= 256 && k <= 258) {
        if (k == ALLEGRO_KEY_MOUSE_LCLICK) i = al_mouse_button_down(&mous, 1);
        if (k == ALLEGRO_KEY_MOUSE_RCLICK) i = al_mouse_button_down(&mous, 2);
        if (k == ALLEGRO_KEY_MOUSE_MCLICK) i = al_mouse_button_down(&mous, 3);
        KB_Active[k]=0;
        if (i)KB_Active[k]=1;
        KB_Input[k]=0;
        KB_Released[k]=0;
        KB_DoublePressed[k]=0;
        if (Keyboard_To_Double_Press[k] > 0) Keyboard_To_Double_Press[k] -= 1;
        if (i) KB_TimePressed[k] += 1;
        else KB_TimePressed[k] = 0;
        if (KB_TimePressed[k] > 2000) KB_TimePressed[k] = 2000;
        if ((i) && (Keyboard_To_Double_Press[k] > 0)) {
          KB_DoublePressed[k] = 1;
          Keyboard_To_Double_Press[k] = 0;
        }
        if ((!i) && (Keyboard_Last_Pressed[k])) {
          Keyboard_To_Double_Press[k] = KEY_DELAY_TO_DOUBLEPRESS;
          KB_Released[k]=1;
        }
        if ((i) && (Keyboard_Last_Pressed[k] == 0)) {
          KB_Input[k]=1;
          Keyboard_Last_Pressed[k] = 1;
        }
        if (i) Keyboard_Last_Pressed[k] = 1;
        else Keyboard_Last_Pressed[k] = 0;
      }
    }
    ++ind;
  }
}



char key_to_char(int ind, int mode) {
  char c;
  char tild[]="'";
  c=NULL;
  if (KB_Active[ALLEGRO_KEY_LSHIFT]) {
    if (mode != KEY_TO_CHAR_MODE_NUMBERS) {
    if (ind == ALLEGRO_KEY_A) c = 'A'; if (ind == ALLEGRO_KEY_B) c = 'B';
    if (ind == ALLEGRO_KEY_C) c = 'C'; if (ind == ALLEGRO_KEY_D) c = 'D';
    if (ind == ALLEGRO_KEY_E) c = 'E'; if (ind == ALLEGRO_KEY_F) c = 'F';
    if (ind == ALLEGRO_KEY_G) c = 'G'; if (ind == ALLEGRO_KEY_H) c = 'H';
    if (ind == ALLEGRO_KEY_I) c = 'I'; if (ind == ALLEGRO_KEY_J) c = 'J';
    if (ind == ALLEGRO_KEY_K) c = 'K'; if (ind == ALLEGRO_KEY_L) c = 'L';
    if (ind == ALLEGRO_KEY_M) c = 'M'; if (ind == ALLEGRO_KEY_N) c = 'N';
    if (ind == ALLEGRO_KEY_O) c = 'O'; if (ind == ALLEGRO_KEY_P) c = 'P';
    if (ind == ALLEGRO_KEY_Q) c = 'Q'; if (ind == ALLEGRO_KEY_R) c = 'R';
    if (ind == ALLEGRO_KEY_S) c = 'S'; if (ind == ALLEGRO_KEY_T) c = 'T';
    if (ind == ALLEGRO_KEY_U) c = 'U'; if (ind == ALLEGRO_KEY_W) c = 'W';
    if (ind == ALLEGRO_KEY_V) c = 'V'; if (ind == ALLEGRO_KEY_X) c = 'X';
    if (ind == ALLEGRO_KEY_Y) c = 'Y'; if (ind == ALLEGRO_KEY_Z) c = 'Z';
    }
    if ((mode != KEY_TO_CHAR_MODE_NUMBERS) && (mode != KEY_TO_CHAR_MODE_FILE_NAME)) {
    if (ind == ALLEGRO_KEY_1) c = '!';
    if (ind == ALLEGRO_KEY_2) c = '@';
    if (ind == ALLEGRO_KEY_3) c = '#';
    if (ind == ALLEGRO_KEY_4) c = '$';
    if (ind == ALLEGRO_KEY_5) c = '%';
    if (ind == ALLEGRO_KEY_6) c = '^';
    if (ind == ALLEGRO_KEY_7) c = '&';
    if (ind == ALLEGRO_KEY_8) c = '*';
    if (ind == ALLEGRO_KEY_9) c = '(';
    if (ind == ALLEGRO_KEY_0) c = ')';
    if (ind == ALLEGRO_KEY_TILDE) c = '~';
    if (ind == ALLEGRO_KEY_MINUS) c = '_';
    if (ind == ALLEGRO_KEY_EQUALS) c = '+';
    if (ind == ALLEGRO_KEY_OPENBRACE) c = '{';
    if (ind == ALLEGRO_KEY_CLOSEBRACE) c = '}';
    if (ind == ALLEGRO_KEY_COMMA) c = ':';
    if (ind == ALLEGRO_KEY_BACKSLASH) c = '"';
    if (ind == ALLEGRO_KEY_COMMA) c = '<';
    if (ind == ALLEGRO_KEY_FULLSTOP) c = '>';
    if (ind == ALLEGRO_KEY_SLASH) c = '?';
    }
  }
  else {
    if (mode != KEY_TO_CHAR_MODE_NUMBERS) {
    if (ind == ALLEGRO_KEY_A) c = 'a'; if (ind == ALLEGRO_KEY_B) c = 'b';
    if (ind == ALLEGRO_KEY_C) c = 'c'; if (ind == ALLEGRO_KEY_D) c = 'd';
    if (ind == ALLEGRO_KEY_E) c = 'e'; if (ind == ALLEGRO_KEY_F) c = 'f';
    if (ind == ALLEGRO_KEY_G) c = 'g'; if (ind == ALLEGRO_KEY_H) c = 'h';
    if (ind == ALLEGRO_KEY_I) c = 'i'; if (ind == ALLEGRO_KEY_J) c = 'j';
    if (ind == ALLEGRO_KEY_K) c = 'k'; if (ind == ALLEGRO_KEY_L) c = 'l';
    if (ind == ALLEGRO_KEY_M) c = 'm'; if (ind == ALLEGRO_KEY_N) c = 'n';
    if (ind == ALLEGRO_KEY_O) c = 'o'; if (ind == ALLEGRO_KEY_P) c = 'p';
    if (ind == ALLEGRO_KEY_Q) c = 'q'; if (ind == ALLEGRO_KEY_R) c = 'r';
    if (ind == ALLEGRO_KEY_S) c = 's'; if (ind == ALLEGRO_KEY_T) c = 't';
    if (ind == ALLEGRO_KEY_U) c = 'u'; if (ind == ALLEGRO_KEY_W) c = 'w';
    if (ind == ALLEGRO_KEY_V) c = 'v'; if (ind == ALLEGRO_KEY_X) c = 'x';
    if (ind == ALLEGRO_KEY_Y) c = 'y'; if (ind == ALLEGRO_KEY_Z) c = 'z';
    }
    if ((ind == ALLEGRO_KEY_1)  || (ind == ALLEGRO_KEY_PAD_1)) c = '1';
    if ((ind == ALLEGRO_KEY_2)  || (ind == ALLEGRO_KEY_PAD_2)) c = '2';
    if ((ind == ALLEGRO_KEY_3)  || (ind == ALLEGRO_KEY_PAD_3)) c = '3';
    if ((ind == ALLEGRO_KEY_4)  || (ind == ALLEGRO_KEY_PAD_4)) c = '4';
    if ((ind == ALLEGRO_KEY_5)  || (ind == ALLEGRO_KEY_PAD_5)) c = '5';
    if ((ind == ALLEGRO_KEY_6)  || (ind == ALLEGRO_KEY_PAD_6)) c = '6';
    if ((ind == ALLEGRO_KEY_7)  || (ind == ALLEGRO_KEY_PAD_7)) c = '7';
    if ((ind == ALLEGRO_KEY_8)  || (ind == ALLEGRO_KEY_PAD_8)) c = '8';
    if ((ind == ALLEGRO_KEY_9)  || (ind == ALLEGRO_KEY_PAD_9)) c = '9';
    if ((ind == ALLEGRO_KEY_0)  || (ind == ALLEGRO_KEY_PAD_0)) c = '0';
    if (ind == ALLEGRO_KEY_FULLSTOP) c = '.';
    if (ind == ALLEGRO_KEY_MINUS) c = '-';

    if ((mode != KEY_TO_CHAR_MODE_NUMBERS) && (mode != KEY_TO_CHAR_MODE_FILE_NAME)) {
    if (ind == ALLEGRO_KEY_TILDE) c = '`';
    if (ind == ALLEGRO_KEY_EQUALS) c = '=';
    if (ind == ALLEGRO_KEY_OPENBRACE) c = '[';
    if (ind == ALLEGRO_KEY_OPENBRACE) c = ']';
    if (ind == ALLEGRO_KEY_SEMICOLON) c = ';';
    if (ind == ALLEGRO_KEY_BACKSLASH) c = tild[0];  // The Compiler can't work out which character is in a '''.
    if (ind == ALLEGRO_KEY_COMMA) c = ',';
    if (ind == ALLEGRO_KEY_SLASH) c = '/';
    }

  }
  if (mode != KEY_TO_CHAR_MODE_NUMBERS) {
    if (ind == ALLEGRO_KEY_SPACE)c=' ';
  }
  return c;
}
