/*

     Resta Zero Versao 1.0
     Por Guilherme Goettems Schneider
     Inicio: 12/07/1999
     Termino: 06/08/1999

*/

#include <stdio.h>
#include <bios.h>
#include "allegro.h"
#include "rz.h"

#define ARQ "rz.dat"

BITMAP *fazfundo(BITMAP *fig, int tx, int ty);

int main()
{
  int i,j,k,z;
  int px, py;
  char x, y;
  int mov, umov;
  int t;
  int lim;
  char loc[100][20][20];
  char l[20][20];
  char cxi[100], cyi[100];
  int fase;

  DATAFILE *arqdados;
  BITMAP *tela;
  BITMAP *fundo;
  BITMAP *temp;
  BITMAP *tabu;
  BITMAP *bola;
  BITMAP *desv1;
  BITMAP *desv2;
  BITMAP *desv3;
  BITMAP *desv4;
  FILE *fases;

  allegro_init();
  install_keyboard();
  install_timer();
  if (install_sound(DIGI_AUTODETECT, MIDI_NONE, 0)) {
    allegro_exit();
    printf("Erro ao inicializar som\n");
    return 1;
  }
  arqdados = load_datafile(ARQ);
  if (!arqdados) {
    allegro_exit();
    printf("Erro ao carregar %s\n", ARQ);
    return 1;
  }


  set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0);
  set_pallete(arqdados[CORES].dat);
  tela = create_bitmap(640, 480);
  fundo = create_bitmap(640, 480);
  clear(tela);
  clear(fundo);

  //   ABERTURA

  fundo = fazfundo(arqdados[FUNDO].dat, 32, 32);
  blit (fundo, tela, 0,0, 0,0, 640, 480);

  masked_blit (arqdados[RZERO].dat, tela, 0,0, 206,65, 228,39);
  text_mode(-1);
  textout_centre(tela, arqdados[FONTE].dat, "Versao 1.0", SCREEN_W/2, 100, 194);
  textout_centre(tela, arqdados[FONTE].dat, "~", SCREEN_W/2, 90, 194);
  textout_centre(tela, arqdados[FONTE].dat, "Agosto 1999", SCREEN_W/2, 130, 194);
  textout_centre(tela, arqdados[FONTE].dat, "por", SCREEN_W/2, 190, 195);
  textout_centre(tela, arqdados[FONTE].dat, "Guilherme Goettems Schneider", SCREEN_W/2, 220, 196);
  textout_centre(tela, arqdados[FONTE].dat, "rsf3267@pro.via-rs.com.br", SCREEN_W/2, 250, 196);
  textout_centre(tela, arqdados[FONTE].dat, "Pressione  E  para editar fase ou outra tecla para jogar", SCREEN_W/2, 350, 197);
  textout_centre(tela, arqdados[FONTE].dat, "http://guibocca.cjb.net", SCREEN_W/2, 420, 195);
  blit (tela, screen, 0,0, 0,0, 640,480);
  t=readkey()>>8;
  blit (fundo, tela, 0,0, 0,0, 640, 480);
  tabu = create_bitmap(243,243);
  clear(tabu);
  blit (arqdados[QUADRO].dat, tabu, 0,0, 0,0, 243, 243);

  if ((fases = fopen("fases.rz1","rb")) == NULL) {
    textout_centre(screen, arqdados[FONTE].dat,"Erro ao tentar abrir arquivo de fases", SCREEN_W/2, 150, 21);
    readkey();
    goto fecha;
  }
  fread(loc,sizeof(char),40000,fases);
  fread(cxi,sizeof(char),100,fases);
  fread(cyi,sizeof(char),100,fases);
  fclose(fases);

/*
  for (i=0;i<100;i++) {
    cxi[i]=0; cyi[i]=0;
    for (j=0;j<20;j++)
      for (k=0;k<20;k++)
        loc[i][j][k] = 0;
  }
*/

  //VERIFICA O NUMERO DE FASES PRONTAS
  lim=99;
  for (i=0; i<100; i++) {
    z=0;
    for (j=0; j<20; j++)
      for (k=0; k<20; k++)
        if (loc[i][j][k]==1) z++;
    if (z==0) { lim=i-1; break; }
  }

  fase = 0;
  for (i=0;i<20;i++)
    for (j=0;j<20;j++) {
      switch (loc[fase][i][j]) {
        case 0: masked_blit (arqdados[VAZIO].dat, tabu, 0,0, 2+i*12, 2+j*12, 11,11); break;
        case 1: masked_blit (arqdados[OBJETO].dat, tabu, 0,0, 2+i*12, 2+j*12, 11,11); break;
        case 2: draw_sprite         (tabu, arqdados[DESVIO].dat, 2+i*12, 2+j*12); break;
        case 3: draw_sprite_h_flip  (tabu, arqdados[DESVIO].dat, 2+i*12, 2+j*12); break;
        case 4: draw_sprite_vh_flip (tabu, arqdados[DESVIO].dat, 2+i*12, 2+j*12); break;
        case 5: draw_sprite_v_flip  (tabu, arqdados[DESVIO].dat, 2+i*12, 2+j*12); break;
      }
    }

  masked_blit (tabu, tela, 0,0, 201,121, 243, 243);
  blit (tela, screen, 0,0, 0,0, 640,480);
  bola = create_bitmap(11,11);
  clear(bola);
//  stretch_blit (arqdados[BOLA].dat, bola, 0,0, 11,11, 1,1, 8,8);
  x=cxi[fase]; y=cyi[fase];
  px=203+x*12; py=123+y*12;

  if (t==KEY_E) { /*   *** EDITOR ***    */
    stretch_blit (arqdados[BOLA].dat, bola, 0,0, 11,11, 1,1, 8,8);
    masked_blit (arqdados[RZERO].dat, fundo, 0,0, 206,35, 228,39);
    textout_centre(fundo, arqdados[FONTE].dat, "ESC : Sai    < , > : Troca de fase   S : Salva   B : Limpa tudo", SCREEN_W/2, 370, 197);
    textout_centre(fundo, arqdados[FONTE].dat, "Setas : Move    0 : Limpa    1 : Objeto    2, 3, 4, 5 : Desvio" , SCREEN_W/2, 395, 197);
    textout_centre(fundo, arqdados[FONTE].dat, "http://guibocca.cjb.net", SCREEN_W/2, 420, 195);
    while (!key[KEY_ESC]) {
      if (!mov) {

        if (key[KEY_S]) { //SALVAR
          cxi[fase]=x;
          cyi[fase]=y;
          fases = fopen("fases.rz1","wb");
          z = fwrite(loc,sizeof(char),40000,fases);
          z += fwrite(cxi,sizeof(char),100,fases);
          z += fwrite(cyi,sizeof(char),100,fases);
          if (z<40200) {
            textout_centre(screen, arqdados[FONTE].dat,"Erro ao tentar salvar arquivo", SCREEN_W/2, 150, 21);
            clear_keybuf();
            readkey();
            fclose(fases);
            goto fecha;
          }
          fclose(fases);
          textout_centre(screen, arqdados[FONTE].dat,"Arquivo salvo!", SCREEN_W/2, 150, 4);
          clear_keybuf();
          readkey();
          mov=5;
        }
        if (key[KEY_B]) {
          for (i=0;i<20;i++)
            for (j=0;j<20;j++)
              loc[fase][i][j] = 0;
          mov=6;
        }
        if (key[KEY_STOP] || key[KEY_COMMA]) {
          cxi[fase]=x; cyi[fase]=y;
          if (key[KEY_STOP] && fase<99) fase++;
          if (key[KEY_COMMA] && fase>0) fase--;
          x=cxi[fase]; y=cyi[fase];
          px=203+x*12; py=123+y*12;
          mov=6;
        }
        if (key[KEY_0]) {
          loc[fase][x][y] = 0; mov=5;
          masked_blit (arqdados[VAZIO].dat, tabu, 0,0, 2+x*12, 2+y*12, 11,11);
        }
        if (key[KEY_1]) {
          loc[fase][x][y] = 1; mov=5;
          masked_blit (arqdados[OBJETO].dat, tabu, 0,0, 2+x*12, 2+y*12, 11,11);
        }
        if (key[KEY_2]) {
          loc[fase][x][y] = 2; mov=5;
          draw_sprite (tabu, arqdados[DESVIO].dat, 2+x*12, 2+y*12);
        }
        if (key[KEY_3]) {
          loc[fase][x][y] = 3; mov=5;
          draw_sprite_h_flip (tabu, arqdados[DESVIO].dat, 2+x*12, 2+y*12);
        }
        if (key[KEY_4]) {
          loc[fase][x][y] = 4; mov=5;
          draw_sprite_vh_flip (tabu, arqdados[DESVIO].dat, 2+x*12, 2+y*12);
        }
        if (key[KEY_5]) {
          loc[fase][x][y] = 5; mov=5;
          draw_sprite_v_flip (tabu, arqdados[DESVIO].dat, 2+x*12, 2+y*12);
        }
        if (key[KEY_RIGHT] && x<19) mov = 1;
        if (key[KEY_DOWN]  && y<19) mov = 2;
        if (key[KEY_LEFT]  && x>0)  mov = 3;
        if (key[KEY_UP]    && y>0)  mov = 4;
      }

      switch(mov) {
        case 1: px++; break;
        case 2: py++; break;
        case 3: px--; break;
        case 4: py--; break;
      }
      if (mov) {
        if (mov==6) {
          for (i=0;i<20;i++)
            for (j=0;j<20;j++)
              switch (loc[fase][i][j]) {
                case 0: masked_blit (arqdados[VAZIO].dat, tabu, 0,0, 2+i*12, 2+j*12, 11,11); break;
                case 1: masked_blit (arqdados[OBJETO].dat, tabu, 0,0, 2+i*12, 2+j*12, 11,11); break;
                case 2: draw_sprite         (tabu, arqdados[DESVIO].dat, 2+i*12, 2+j*12); break;
                case 3: draw_sprite_h_flip  (tabu, arqdados[DESVIO].dat, 2+i*12, 2+j*12); break;
                case 4: draw_sprite_vh_flip (tabu, arqdados[DESVIO].dat, 2+i*12, 2+j*12); break;
                case 5: draw_sprite_v_flip  (tabu, arqdados[DESVIO].dat, 2+i*12, 2+j*12); break;
              }
          rest(200);
        }
        if (!((px-203)%12) && !((py-123)%12)) {
          mov=0;
          x = (px-203)/12;
          y = (py-123)/12;
        }
        blit (fundo, tela, 0,0, 0,0, 640, 480);
        textprintf (tela,arqdados[FONTE].dat, 10,10, 20, "X:%d, Y:%d", x, y);
        textprintf (tela,arqdados[FONTE].dat, 280,80, 198, "Fase %d", fase+1);
        masked_blit (tabu, tela, 0,0, 201,121, 243,243);
        masked_blit (bola, tela, 0,0, px,py, 11,11);
        blit (tela, screen, 0,0, 0,0, 640,480);
        rest(6);
      }
    }
  }

  else {  /*   **** JOGO ****   */
    blit (arqdados[BOLA].dat, bola, 0,0, 0,0, 11,11);
    masked_blit (arqdados[RZERO].dat, fundo, 0,0, 206,35, 228,39);
    textout_centre(fundo, arqdados[FONTE].dat, "Setas : Move    < , > : Troca de fase    R : Reinicia fase", SCREEN_W/2, 370, 197);
    textout_centre(fundo, arqdados[FONTE].dat, "ESC : Sai", SCREEN_W/2, 395, 197);
    textout_centre(fundo, arqdados[FONTE].dat, "http://guibocca.cjb.net", SCREEN_W/2, 420, 195);
    mov=6;umov=0;
    for (i=0;i<20;i++)
      for (j=0;j<20;j++)
        l[i][j] = loc[fase][i][j];

    while (!key[KEY_ESC]) {
      if (!mov) {
        if (key[KEY_RIGHT] && umov != 3) { mov = 1; umov = 1; }
        if (key[KEY_DOWN]  && umov != 4) { mov = 2; umov = 2; }
        if (key[KEY_LEFT]  && umov != 1) { mov = 3; umov = 3; }
        if (key[KEY_UP]    && umov != 2) { mov = 4; umov = 4; }
      }
      if (key[KEY_STOP] || key[KEY_COMMA] || key[KEY_R]) {
        if (key[KEY_STOP] && fase<lim) fase++;
        if (key[KEY_COMMA] && fase>0) fase--;
        x=cxi[fase]; y=cyi[fase];
        px=203+x*12; py=123+y*12;
        mov=6;umov=0;
        for (i=0;i<20;i++)
          for (j=0;j<20;j++)
            l[i][j] = loc[fase][i][j];
      }
      switch(mov) {
        case 1: px++; break;
        case 2: py++; break;
        case 3: px--; break;
        case 4: py--; break;
      }
      if (mov) {
        if (mov==6) {
          mov=0;
          for (i=0;i<20;i++)
            for (j=0;j<20;j++)
              switch (l[i][j]) {
                case 0: masked_blit (arqdados[VAZIO].dat, tabu, 0,0, 2+i*12, 2+j*12, 11,11); break;
                case 1: masked_blit (arqdados[OBJETO].dat, tabu, 0,0, 2+i*12, 2+j*12, 11,11); break;
                case 2: draw_sprite         (tabu, arqdados[DESVIO].dat, 2+i*12, 2+j*12); break;
                case 3: draw_sprite_h_flip  (tabu, arqdados[DESVIO].dat, 2+i*12, 2+j*12); break;
                case 4: draw_sprite_vh_flip (tabu, arqdados[DESVIO].dat, 2+i*12, 2+j*12); break;
                case 5: draw_sprite_v_flip  (tabu, arqdados[DESVIO].dat, 2+i*12, 2+j*12); break;
              }
          blit (fundo, tela, 0,0, 0,0, 640, 480);
          textprintf (tela,arqdados[FONTE].dat, 200,80, 198, "Fase %d", fase+1);
          z=0;
          for (i=0; i<20; i++)
            for (j=0; j<20; j++)
              if (l[i][j]==1) z++;
          if (z>1) textprintf (tela,arqdados[FONTE].dat, 330,80, 198, "Restam %d", z); else textprintf (tela,arqdados[FONTE].dat, 360,80, 198, "Resta %d", z);
          if (z==0) { //  RESTA ZERO!!!
            play_sample(arqdados[SOM3].dat,150,127,1000,0);
            masked_blit (tabu, tela, 0,0, 201,121, 243,243);
            masked_blit (bola, tela, 0,0, px,py, 11,11);
            textout_centre(tela, arqdados[FONTE].dat, "RESTA ZERO!!!", SCREEN_W/2, 220, 2);
            blit (tela, screen, 0,0, 0,0, 640,480);
            clear_keybuf();
            readkey();
            if (fase<lim) fase++;
            x=cxi[fase]; y=cyi[fase];
            px=203+x*12; py=123+y*12;
            mov=6; umov=0;
            for (i=0;i<20;i++)
              for (j=0;j<20;j++)
                l[i][j] = loc[fase][i][j];
          }
          rest(150);
        }
        if (!((px-203)%12) && !((py-123)%12) && mov!=6) {
          x = (px-203)/12;
          y = (py-123)/12;
          if (l[x][y]==1) {
            mov=6;
            l[x][y] = 0;
            play_sample(arqdados[SOM1].dat,160,127,900,0);
            masked_blit (arqdados[VAZIO].dat, tabu, 0,0, 2+x*12, 2+y*12, 11,11);
          }
          if ((x<0||x>19||y<0||y>19) || (l[x][y]==2&&(mov==1||mov==2)) || (l[x][y]==3&&(mov==2||mov==3)) || (l[x][y]==4&&(mov==3||mov==4)) || (l[x][y]==5&&(mov==1||mov==4)) ) {
            play_sample(arqdados[SOM2].dat,150,127,900,0);
            x=cxi[fase]; y=cyi[fase];
            px=203+x*12; py=123+y*12;
            mov=6; umov=0;
            for (i=0;i<20;i++)
              for (j=0;j<20;j++)
                l[i][j] = loc[fase][i][j];
          }
          if (l[x][y]==2 && mov==3) {mov=2; umov=2;}
          if (l[x][y]==2 && mov==4) {mov=1; umov=1;}
          if (l[x][y]==3 && mov==1) {mov=2; umov=2;}
          if (l[x][y]==3 && mov==4) {mov=3; umov=3;}
          if (l[x][y]==4 && mov==2) {mov=3; umov=3;}
          if (l[x][y]==4 && mov==1) {mov=4; umov=4;}
          if (l[x][y]==5 && mov==2) {mov=1; umov=1;}
          if (l[x][y]==5 && mov==3) {mov=4; umov=4;}
        }
        masked_blit (tabu, tela, 0,0, 201,121, 243,243);
        masked_blit (bola, tela, 0,0, px,py, 11,11);
        blit (tela, screen, 0,0, 0,0, 640,480);
        rest(1);
      }
    }
  }

  fecha:
  destroy_bitmap(tela);
  destroy_bitmap(fundo);
  destroy_bitmap(tabu);
  destroy_bitmap(bola);
  unload_datafile(arqdados);
  return 0;
}

BITMAP *fazfundo(BITMAP *fig, int tx, int ty)
{
  int i, j;
  BITMAP *tela;
  tela = create_bitmap(640, 480);
  clear(tela);
  for (i=0; i<640; i+=tx)
    for (j=0; j<480; j+=ty)
      blit (fig, tela, 0,0, i,j, tx,ty);
  return (tela);
}
