/*
    This file is part of Funiter,
    Real and complex function iteration software.

    complex.h - complex math routines.

    Copyright (C) 1995-2007 Stijn Wolters.
    Original idea: Ernic Kamerich (University of Nijmegen)

    See README for contact information.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    See COPYING for more information.
*/

#ifndef _COMPLEX
    #define _COMPLEX

    typedef struct {
        double r;
        double i;
    } TComplex;

    TComplex Complex(double RealPart, double ImagPart);

    double Imag(TComplex c);
    double Real(TComplex c);

    TComplex CNeg(TComplex c);

    TComplex CAdd(TComplex c1, TComplex c2);
    TComplex CSub(TComplex c1, TComplex c2);
    TComplex CMul(TComplex c1, TComplex c2);
    TComplex CDiv(TComplex c1, TComplex c2);

    double CAbs(TComplex c);

    void CSqrt(TComplex *Root, TComplex c, int n);
  
    TComplex CSin(TComplex c);
    TComplex CCos(TComplex c);
    TComplex CExp(TComplex c);
    TComplex CLog(TComplex c);

    #include <stdio.h>
    #include <math.h>
#endif

