/*
    This file is part of Funiter,
    Real and complex function iteration software.

    settings.h - settings.

    Copyright (C) 1995-2007 Stijn Wolters.
    Original idea: Ernic Kamerich (University of Nijmegen)

    See README for contact information.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    See COPYING for more information.
*/

#ifndef _SETTINGS
    #define _SETTINGS

    #include <stdio.h>
    #include <stdlib.h>
    #include <assert.h>
    #include <allegro.h>
    #include "coords.h"

    /*
    **  Structure with information on settings.
    */

    typedef struct {
        unsigned int    GEN_MenuStyle, GEN_Fixedpoint, GEN_ParConnect,
                        LAY_Statusline, COO_Status, COO_Grid, COO_Calibrate,
                        SSI_Text, SSI_Lines, SSI_LineWidth, SSI_FontSize,
                        SSI_Accuracy, COL_Inside, COL_Outside,
                        COL_Grid, COL_Function, COL_XYLine, COL_Iter1,
                        COL_Iter2, COL_Max, COL_List[256],
                        DBG_SymmetryAreaColoring;
        RGB             Palette[256];
    } TSettings;

    TSettings *CreateSettings(void);
    void FreeSettings(TSettings *Settings);
    TSettings *SetDefaultSettings(TSettings *Settings);
    int LoadSettings(FILE *fp, TSettings *Settings);
    TSettings *ReadSettingsConfig(char *Filename, TSettings *Settings);
    int SaveSettings(FILE *fp, TSettings *Settings);
    void WriteSettingsConfig(char *Filename, TSettings *Settings);
    TSettings *ReadFractintMap(char *Filename, TSettings *Settings);

#endif
